/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class Hatchet
extends AoeToolCore {
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.field_151575_d, (Object)Material.field_151582_l, (Object)Material.field_151585_k, (Object)Material.field_151572_C, (Object)Material.field_151570_A);

    public Hatchet() {
        this(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.axeHead), PartMaterialType.extra(TinkerTools.binding));
    }

    protected Hatchet(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(Category.HARVEST);
        this.addCategory(Category.WEAPON);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public boolean isEffective(IBlockState block) {
        return effective_materials.contains((Object)block.func_185904_a()) || ItemAxe.field_150917_c.contains(block);
    }

    @Override
    public float damagePotential() {
        return 1.1f;
    }

    @Override
    public double attackSpeed() {
        return 1.1f;
    }

    @Override
    public float knockback() {
        return 1.3f;
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (state.func_177230_c().func_149688_o(state) == Material.field_151584_j) {
            return ToolHelper.calcDigSpeed(stack, state);
        }
        return super.func_150893_a(stack, state);
    }

    @Override
    public void afterBlockBreak(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase player, int damage, boolean wasEffective) {
        if (state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos)) {
            damage = 0;
        }
        super.afterBlockBreak(stack, world, state, pos, player, damage, wasEffective);
    }

    @Override
    public boolean dealDamage(ItemStack stack, EntityLivingBase player, EntityLivingBase entity, float damage) {
        boolean hit = super.dealDamage(stack, player, entity, damage);
        if (hit && this.readyForSpecialAttack(player)) {
            TinkerTools.proxy.spawnAttackParticle(Particles.HATCHET_ATTACK, (Entity)player, 0.8);
        }
        if (hit && !ToolHelper.isBroken(stack) && !player.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            ItemStack itemstack3;
            EntityPlayer entityplayer = (EntityPlayer)entity;
            ItemStack itemstack2 = player.func_184614_ca();
            ItemStack itemStack = itemstack3 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
            if (itemstack2 != null && itemstack3 != null && itemstack2.func_77973_b() == this && itemstack3.func_77973_b() == Items.field_185159_cQ) {
                float f3 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)player) * 0.05f;
                if (player.func_70051_ag()) {
                    f3 += 0.75f;
                }
                if (player.func_70681_au().nextFloat() < f3) {
                    entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                    player.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                }
            }
        }
        return hit;
    }

    @Override
    public NBTTagCompound buildTag(List<slimeknights.tconstruct.library.materials.Material> materials) {
        ToolNBT data = this.buildDefaultTag(materials);
        data.attack += 0.5f;
        return data.get();
    }
}

