/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.BroadSword;
import slimeknights.tconstruct.tools.modifiers.ModBeheading;

public class Cleaver
extends ToolCore {
    public Cleaver() {
        super(PartMaterialType.handle(TinkerTools.toughToolRod), PartMaterialType.head(TinkerTools.largeSwordBlade), PartMaterialType.head(TinkerTools.largePlate), PartMaterialType.extra(TinkerTools.toughToolRod));
        this.addCategory(Category.WEAPON);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer player, EnumHand hand) {
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemStackIn);
    }

    @Override
    public float damagePotential() {
        return 1.2f;
    }

    @Override
    public double attackSpeed() {
        return 0.7;
    }

    @Override
    public float damageCutoff() {
        return 25.0f;
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    @Override
    public boolean isEffective(IBlockState block) {
        return BroadSword.effective_materials.contains((Object)block.func_185904_a());
    }

    @Override
    public float miningSpeedModifier() {
        return 0.2f;
    }

    @Override
    public boolean dealDamage(ItemStack stack, EntityLivingBase player, EntityLivingBase entity, float damage) {
        boolean hit = super.dealDamage(stack, player, entity, damage);
        if (hit && this.readyForSpecialAttack(player)) {
            TinkerTools.proxy.spawnAttackParticle(Particles.CLEAVER_ATTACK, (Entity)player, 0.85);
        }
        return hit;
    }

    @Override
    public NBTTagCompound buildTag(List<Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        HeadMaterialStats shield = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        ExtraMaterialStats guard = (ExtraMaterialStats)materials.get(3).getStatsOrUnknown("extra");
        ToolNBT data = new ToolNBT();
        data.head(head, shield);
        data.extra(guard);
        data.handle(handle);
        data.attack *= 1.4f;
        data.attack += 2.0f;
        data.durability = (int)((float)data.durability * 2.0f);
        data.modifiers = 3;
        return data.get();
    }

    @Override
    public void addMaterialTraits(NBTTagCompound root, List<Material> materials) {
        super.addMaterialTraits(root, materials);
        ModBeheading.CLEAVER_BEHEADING_MOD.apply(root);
        ModBeheading.CLEAVER_BEHEADING_MOD.apply(root);
    }
}

