/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.TinkerPulse;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tinkering.IndestructibleEntityItem;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.library.tools.Shard;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.shared.tileentity.TileTable;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockSeared;
import slimeknights.tconstruct.tools.TableRecipe;
import slimeknights.tconstruct.tools.ToolEvents;
import slimeknights.tconstruct.tools.TraitEvents;
import slimeknights.tconstruct.tools.block.BlockToolForge;
import slimeknights.tconstruct.tools.block.BlockToolTable;
import slimeknights.tconstruct.tools.entity.EntityShuriken;
import slimeknights.tconstruct.tools.item.BattleSign;
import slimeknights.tconstruct.tools.item.BroadSword;
import slimeknights.tconstruct.tools.item.Cleaver;
import slimeknights.tconstruct.tools.item.Excavator;
import slimeknights.tconstruct.tools.item.FryPan;
import slimeknights.tconstruct.tools.item.Hammer;
import slimeknights.tconstruct.tools.item.Hatchet;
import slimeknights.tconstruct.tools.item.ItemBlockTable;
import slimeknights.tconstruct.tools.item.LongSword;
import slimeknights.tconstruct.tools.item.LumberAxe;
import slimeknights.tconstruct.tools.item.Mattock;
import slimeknights.tconstruct.tools.item.Pickaxe;
import slimeknights.tconstruct.tools.item.Rapier;
import slimeknights.tconstruct.tools.item.SharpeningKit;
import slimeknights.tconstruct.tools.item.Shovel;
import slimeknights.tconstruct.tools.item.Shuriken;
import slimeknights.tconstruct.tools.modifiers.ModAntiMonsterType;
import slimeknights.tconstruct.tools.modifiers.ModBeheading;
import slimeknights.tconstruct.tools.modifiers.ModCreative;
import slimeknights.tconstruct.tools.modifiers.ModDiamond;
import slimeknights.tconstruct.tools.modifiers.ModEmerald;
import slimeknights.tconstruct.tools.modifiers.ModFiery;
import slimeknights.tconstruct.tools.modifiers.ModFortify;
import slimeknights.tconstruct.tools.modifiers.ModHarvestSize;
import slimeknights.tconstruct.tools.modifiers.ModHaste;
import slimeknights.tconstruct.tools.modifiers.ModKnockback;
import slimeknights.tconstruct.tools.modifiers.ModLuck;
import slimeknights.tconstruct.tools.modifiers.ModNecrotic;
import slimeknights.tconstruct.tools.modifiers.ModReinforced;
import slimeknights.tconstruct.tools.modifiers.ModSharpness;
import slimeknights.tconstruct.tools.modifiers.ModSilktouch;
import slimeknights.tconstruct.tools.modifiers.ModSoulbound;
import slimeknights.tconstruct.tools.tileentity.TileCraftingStation;
import slimeknights.tconstruct.tools.tileentity.TilePartBuilder;
import slimeknights.tconstruct.tools.tileentity.TilePartChest;
import slimeknights.tconstruct.tools.tileentity.TilePatternChest;
import slimeknights.tconstruct.tools.tileentity.TileStencilTable;
import slimeknights.tconstruct.tools.tileentity.TileToolForge;
import slimeknights.tconstruct.tools.tileentity.TileToolStation;
import slimeknights.tconstruct.tools.traits.InfiTool;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlime;

@Pulse(id="TinkerTools", description="All the tools and everything related to it.")
public class TinkerTools
extends TinkerPulse {
    public static final String PulseId = "TinkerTools";
    static final Logger log = Util.getLogger("TinkerTools");
    @SidedProxy(clientSide="slimeknights.tconstruct.tools.ToolClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static BlockToolTable toolTables;
    public static BlockToolForge toolForge;
    public static Pattern pattern;
    public static Shard shard;
    public static SharpeningKit sharpeningKit;
    public static ToolCore pickaxe;
    public static ToolCore shovel;
    public static ToolCore hatchet;
    public static ToolCore mattock;
    public static ToolCore broadSword;
    public static ToolCore longSword;
    public static ToolCore rapier;
    public static ToolCore cutlass;
    public static ToolCore dagger;
    public static ToolCore fryPan;
    public static ToolCore battleSign;
    public static ToolCore hammer;
    public static ToolCore excavator;
    public static ToolCore lumberAxe;
    public static ToolCore cleaver;
    public static ToolCore battleAxe;
    public static ToolCore scythe;
    public static ToolCore shuriken;
    public static ToolPart pickHead;
    public static ToolPart shovelHead;
    public static ToolPart axeHead;
    public static ToolPart broadAxeHead;
    public static ToolPart swordBlade;
    public static ToolPart largeSwordBlade;
    public static ToolPart hammerHead;
    public static ToolPart excavatorHead;
    public static ToolPart scytheHead;
    public static ToolPart panHead;
    public static ToolPart signHead;
    public static ToolPart toolRod;
    public static ToolPart toughToolRod;
    public static ToolPart binding;
    public static ToolPart toughBinding;
    public static ToolPart wideGuard;
    public static ToolPart handGuard;
    public static ToolPart crossGuard;
    public static ToolPart largePlate;
    public static ToolPart knifeBlade;
    public static Modifier modBaneOfArthopods;
    public static Modifier modBeheading;
    public static Modifier modDiamond;
    public static Modifier modEmerald;
    public static Modifier modFiery;
    public static Modifier modHaste;
    public static Modifier modHarvestWidth;
    public static Modifier modHarvestHeight;
    public static Modifier modKnockback;
    public static Modifier modLuck;
    public static Modifier modNecrotic;
    public static Modifier modReinforced;
    public static Modifier modSharpness;
    public static Modifier modSilktouch;
    public static Modifier modSmite;
    public static Modifier modSoulbound;
    public static Modifier modCreative;
    public static List<Modifier> fortifyMods;
    static List<ToolCore> tools;
    static List<ToolPart> toolparts;
    static List<IModifier> modifiers;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        pattern = TinkerTools.registerItem(new Pattern(), "pattern");
        shard = TinkerTools.registerItem(new Shard(), "shard");
        sharpeningKit = (SharpeningKit)this.registerToolPart(new SharpeningKit(), "sharpening_kit");
        sharpeningKit.func_77637_a((CreativeTabs)TinkerRegistry.tabParts);
        TinkerRegistry.registerToolPart(sharpeningKit);
        this.registerToolParts();
        this.registerTools();
        this.registerModifiers();
        toolTables = (BlockToolTable)TinkerTools.registerBlock((ItemBlock)new ItemBlockTable((Block)new BlockToolTable()), "tooltables");
        toolForge = (BlockToolForge)TinkerTools.registerBlock((ItemBlock)new ItemBlockTable((Block)new BlockToolForge()), "toolforge");
        ItemBlockMeta.setMappingProperty((Block)toolTables, BlockToolTable.TABLES);
        TinkerTools.registerTE(TileTable.class, "table");
        TinkerTools.registerTE(TileCraftingStation.class, "craftingstation");
        TinkerTools.registerTE(TileStencilTable.class, "stenciltable");
        TinkerTools.registerTE(TilePartBuilder.class, "partbuilder");
        TinkerTools.registerTE(TilePatternChest.class, "patternchest");
        TinkerTools.registerTE(TilePartChest.class, "partchest");
        TinkerTools.registerTE(TileToolStation.class, "toolstation");
        TinkerTools.registerTE(TileToolForge.class, "toolforge");
        EntityRegistry.registerModEntity(IndestructibleEntityItem.class, (String)"Indestructible Item", (int)0, (Object)TConstruct.instance, (int)32, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityShuriken.class, (String)"shuriken", (int)12, (Object)TConstruct.instance, (int)64, (int)1, (boolean)false);
        proxy.preInit();
        TinkerRegistry.setShardItem(shard);
    }

    private void registerToolParts() {
        pickHead = this.registerToolPart(new ToolPart(288), "pick_head");
        shovelHead = this.registerToolPart(new ToolPart(288), "shovel_head");
        axeHead = this.registerToolPart(new ToolPart(288), "axe_head");
        broadAxeHead = this.registerToolPart(new ToolPart(1152), "broad_axe_head");
        swordBlade = this.registerToolPart(new ToolPart(288), "sword_blade");
        largeSwordBlade = this.registerToolPart(new ToolPart(1152), "large_sword_blade");
        hammerHead = this.registerToolPart(new ToolPart(1152), "hammer_head");
        excavatorHead = this.registerToolPart(new ToolPart(1152), "excavator_head");
        panHead = this.registerToolPart(new ToolPart(432), "pan_head");
        signHead = this.registerToolPart(new ToolPart(432), "sign_head");
        toolRod = this.registerToolPart(new ToolPart(144), "tool_rod");
        toughToolRod = this.registerToolPart(new ToolPart(432), "tough_tool_rod");
        binding = this.registerToolPart(new ToolPart(144), "binding");
        toughBinding = this.registerToolPart(new ToolPart(432), "tough_binding");
        wideGuard = this.registerToolPart(new ToolPart(144), "wide_guard");
        handGuard = this.registerToolPart(new ToolPart(144), "hand_guard");
        crossGuard = this.registerToolPart(new ToolPart(144), "cross_guard");
        largePlate = this.registerToolPart(new ToolPart(1152), "large_plate");
        knifeBlade = this.registerToolPart(new ToolPart(144), "knife_blade");
    }

    private void registerTools() {
        pickaxe = TinkerTools.registerTool(new Pickaxe(), "pickaxe");
        shovel = TinkerTools.registerTool(new Shovel(), "shovel");
        hatchet = TinkerTools.registerTool(new Hatchet(), "hatchet");
        mattock = TinkerTools.registerTool(new Mattock(), "mattock");
        broadSword = TinkerTools.registerTool(new BroadSword(), "broadsword");
        longSword = TinkerTools.registerTool(new LongSword(), "longsword");
        rapier = TinkerTools.registerTool(new Rapier(), "rapier");
        fryPan = TinkerTools.registerTool(new FryPan(), "frypan");
        battleSign = TinkerTools.registerTool(new BattleSign(), "battlesign");
        hammer = TinkerTools.registerTool(new Hammer(), "hammer");
        excavator = TinkerTools.registerTool(new Excavator(), "excavator");
        lumberAxe = TinkerTools.registerTool(new LumberAxe(), "lumberaxe");
        cleaver = TinkerTools.registerTool(new Cleaver(), "cleaver");
        shuriken = TinkerTools.registerTool(new Shuriken(), "shuriken");
    }

    private void registerModifiers() {
        modBaneOfArthopods = new ModAntiMonsterType("bane_of_arthopods", 6404681, 5, 24, EnumCreatureAttribute.ARTHROPOD);
        modBaneOfArthopods = this.registerModifier(modBaneOfArthopods);
        modBaneOfArthopods.addItem(Items.field_151071_bq);
        modBeheading = this.registerModifier(new ModBeheading());
        modBeheading.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{new ItemStack(Items.field_151079_bi), new ItemStack(Blocks.field_150343_Z)}));
        modDiamond = this.registerModifier(new ModDiamond());
        modDiamond.addItem("gemDiamond");
        modEmerald = this.registerModifier(new ModEmerald());
        modEmerald.addItem("gemEmerald");
        modFiery = this.registerModifier(new ModFiery());
        modFiery.addItem(Items.field_151065_br);
        modHaste = this.registerModifier(new ModHaste(50));
        modHaste.addItem("dustRedstone");
        modHaste.addItem("blockRedstone", 1, 9);
        modHarvestWidth = this.registerModifier(new ModHarvestSize("width"));
        modHarvestWidth.addItem(TinkerCommons.matExpanderW, 1, 1);
        modHarvestHeight = this.registerModifier(new ModHarvestSize("height"));
        modHarvestHeight.addItem(TinkerCommons.matExpanderH, 1, 1);
        modKnockback = this.registerModifier(new ModKnockback());
        modKnockback.addItem((Block)Blocks.field_150331_J, 1);
        modKnockback.addItem((Block)Blocks.field_150320_F, 1);
        modLuck = this.registerModifier(new ModLuck());
        modLuck.addItem("gemLapis");
        modLuck.addItem("blockLapis", 1, 9);
        modNecrotic = this.registerModifier(new ModNecrotic());
        modNecrotic.addItem(TinkerCommons.matNecroticBone, 1, 1);
        modReinforced = this.registerModifier(new ModReinforced());
        modReinforced.addItem(TinkerCommons.matReinforcement, 1, 1);
        modSharpness = this.registerModifier(new ModSharpness(72));
        modSharpness.addItem("gemQuartz");
        modSharpness.addItem("blockQuartz", 1, 4);
        modSilktouch = this.registerModifier(new ModSilktouch());
        modSilktouch.addItem(TinkerCommons.matSilkyJewel, 1, 1);
        modSmite = new ModAntiMonsterType("smite", 15258880, 5, 24, EnumCreatureAttribute.UNDEAD);
        modSmite = this.registerModifier(modSmite);
        modSmite.addItem(TinkerCommons.consecratedSoil, 1, 1);
        modSoulbound = this.registerModifier(new ModSoulbound());
        modSoulbound.addItem(Items.field_151156_bN);
        modCreative = this.registerModifier(new ModCreative());
        modCreative.addItem(TinkerCommons.matCreativeModifier, 1, 1);
        TinkerRegistry.addTrait(InfiTool.INSTANCE);
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        this.registerToolBuilding();
        this.registerRecipies();
        proxy.init();
    }

    private void registerToolBuilding() {
        TinkerRegistry.registerToolCrafting(pickaxe);
        TinkerRegistry.registerToolCrafting(shovel);
        TinkerRegistry.registerToolCrafting(hatchet);
        TinkerRegistry.registerToolCrafting(mattock);
        TinkerRegistry.registerToolCrafting(broadSword);
        TinkerRegistry.registerToolCrafting(longSword);
        TinkerRegistry.registerToolCrafting(rapier);
        TinkerRegistry.registerToolCrafting(fryPan);
        TinkerRegistry.registerToolCrafting(battleSign);
        TinkerRegistry.registerToolForgeCrafting(hammer);
        TinkerRegistry.registerToolForgeCrafting(excavator);
        TinkerRegistry.registerToolForgeCrafting(lumberAxe);
        TinkerRegistry.registerToolForgeCrafting(cleaver);
        TinkerRegistry.registerToolForgeCrafting(shuriken);
    }

    private void registerRecipies() {
        ItemStack pattern = new ItemStack((Item)TinkerTools.pattern, 4);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(pattern, new Object[]{"PS", "SP", Character.valueOf('P'), "plankWood", Character.valueOf('S'), "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(pattern, new Object[]{"SP", "PS", Character.valueOf('P'), "plankWood", Character.valueOf('S'), "stickWood"}));
        pattern.field_77994_a = 1;
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151122_aG), (Object[])new Object[]{Items.field_151121_aF, Items.field_151121_aF, Items.field_151121_aF, Items.field_151007_F, pattern, pattern});
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)toolTables, 1, BlockToolTable.TableTypes.CraftingStation.meta), new Object[]{"workbench"}));
        GameRegistry.addRecipe((IRecipe)new TableRecipe(OreDictionary.getOres((String)"plankWood"), toolTables, BlockToolTable.TableTypes.StencilTable.meta, "P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), "plankWood"));
        GameRegistry.addRecipe((ItemStack)BlockTable.createItemstack(toolTables, BlockToolTable.TableTypes.StencilTable.meta, (Block)TinkerCommons.blockFirewood, TinkerCommons.lavawood.func_77960_j()), (Object[])new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), TinkerCommons.lavawood});
        GameRegistry.addRecipe((ItemStack)BlockTable.createItemstack(toolTables, BlockToolTable.TableTypes.StencilTable.meta, Blocks.field_150448_aq, 0), (Object[])new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), Blocks.field_150448_aq});
        GameRegistry.addRecipe((ItemStack)BlockTable.createItemstack(toolTables, BlockToolTable.TableTypes.StencilTable.meta, Blocks.field_150440_ba, 0), (Object[])new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), Blocks.field_150440_ba});
        GameRegistry.addRecipe((IRecipe)new TableRecipe(OreDictionary.getOres((String)"logWood"), toolTables, BlockToolTable.TableTypes.PartBuilder.meta, "P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), "logWood"));
        GameRegistry.addRecipe((ItemStack)BlockTable.createItemstack(toolTables, BlockToolTable.TableTypes.PartBuilder.meta, (Block)TinkerCommons.blockFirewood, TinkerCommons.firewood.func_77960_j()), (Object[])new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), TinkerCommons.firewood});
        GameRegistry.addRecipe((ItemStack)BlockTable.createItemstack(toolTables, BlockToolTable.TableTypes.PartBuilder.meta, Blocks.field_150318_D, 0), (Object[])new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), Blocks.field_150318_D});
        GameRegistry.addRecipe((ItemStack)BlockTable.createItemstack(toolTables, BlockToolTable.TableTypes.PartBuilder.meta, (Block)Blocks.field_150434_aF, 0), (Object[])new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), Blocks.field_150434_aF});
        ItemStack patternChest = new ItemStack((Block)toolTables, 1, BlockToolTable.TableTypes.PatternChest.meta);
        ItemStack partChest = new ItemStack((Block)toolTables, 1, BlockToolTable.TableTypes.PartChest.meta);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(patternChest, new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), "chestWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(patternChest, new Object[]{"BBB", "BPB", "BBB", Character.valueOf('P'), pattern, Character.valueOf('B'), "plankWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(partChest, new Object[]{" P ", "SCS", " B ", Character.valueOf('C'), "chestWood", Character.valueOf('S'), "stickWood", Character.valueOf('B'), "plankWood", Character.valueOf('P'), pattern}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)toolTables, 1, BlockToolTable.TableTypes.ToolStation.meta), new Object[]{"P", "B", Character.valueOf('P'), pattern, Character.valueOf('B'), "workbench"}));
        ItemStack slimeBallBlue = TinkerCommons.matSlimeBallBlue;
        ItemStack slimeBallPurple = TinkerCommons.matSlimeBallPurple;
        ItemStack slimeBallMagma = TinkerCommons.matSlimeBallMagma;
        ItemStack knightSlime = TinkerCommons.ingotKnightSlime;
        if (!TinkerTools.isWorldLoaded()) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(slimeBallBlue, new Object[]{Items.field_151123_aH, "dyeBlue"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(slimeBallPurple, new Object[]{Items.field_151123_aH, "dyePurple"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(slimeBallMagma, new Object[]{Items.field_151123_aH, "dyeOrange"}));
        }
        if (!TinkerTools.isSmelteryLoaded()) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(knightSlime, new Object[]{slimeBallPurple, "ingotIron", "stone"}));
            if (!TinkerTools.isWorldLoaded()) {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(knightSlime, new Object[]{Items.field_151123_aH, "dyePurple", "ingotIron", "stone"}));
            }
            GameRegistry.addSmelting((ItemStack)TinkerCommons.oreArdite, (ItemStack)TinkerCommons.ingotArdite, (float)1.0f);
            GameRegistry.addSmelting((ItemStack)TinkerCommons.oreCobalt, (ItemStack)TinkerCommons.ingotCobalt, (float)1.0f);
            GameRegistry.addShapelessRecipe((ItemStack)TinkerCommons.ingotManyullyn, (Object[])new Object[]{TinkerCommons.ingotCobalt, TinkerCommons.ingotArdite, Blocks.field_150402_ci});
            GameRegistry.addShapelessRecipe((ItemStack)TinkerCommons.nuggetManyullyn, (Object[])new Object[]{TinkerCommons.nuggetCobalt, TinkerCommons.nuggetArdite, Items.field_151044_h});
            ItemStack pigiron = TinkerCommons.ingotPigIron.func_77946_l();
            pigiron.field_77994_a = 3;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(pigiron, new Object[]{"ingotIron", "ingotIron", "ingotIron", Items.field_151147_al, Items.field_151147_al, Items.field_151147_al, "gemEmerald"}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TinkerCommons.matExpanderW, new Object[]{" L ", "PSP", " L ", Character.valueOf('L'), "gemLapis", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('S'), slimeBallPurple}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TinkerCommons.matExpanderH, new Object[]{" P ", "LSL", " P ", Character.valueOf('L'), "gemLapis", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('S'), slimeBallPurple}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TinkerCommons.matSilkyCloth, new Object[]{"CCC", "CGC", "CCC", Character.valueOf('C'), Items.field_151007_F, Character.valueOf('G'), "ingotGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TinkerCommons.matSilkyJewel, new Object[]{" C ", "CEC", " C ", Character.valueOf('C'), TinkerCommons.matSilkyCloth, Character.valueOf('E'), "gemEmerald"}));
        String goldThing = "ingotGold";
        if (TinkerSmeltery.cast != null) {
            goldThing = "cast";
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TinkerCommons.matReinforcement, new Object[]{"OOO", "OPO", "OOO", Character.valueOf('O'), "obsidian", Character.valueOf('P'), goldThing}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(TinkerCommons.slimyMudGreen, new Object[]{Items.field_151123_aH, Items.field_151123_aH, Items.field_151123_aH, Items.field_151123_aH, "sand", "dirt"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(TinkerCommons.slimyMudBlue, new Object[]{slimeBallBlue, slimeBallBlue, slimeBallBlue, slimeBallBlue, "sand", "dirt"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(TinkerCommons.slimyMudMagma, new Object[]{slimeBallMagma, Items.field_151064_bs, slimeBallMagma, Items.field_151064_bs, Blocks.field_150425_aM, Blocks.field_150424_aL}));
        if (TinkerTools.isWorldLoaded()) {
            ItemStack congealed = new ItemStack((Block)TinkerWorld.slimeBlockCongealed, 0, BlockSlime.SlimeType.GREEN.meta);
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(TinkerCommons.slimyMudGreen, new Object[]{congealed, "sand", "dirt"}));
            congealed = new ItemStack((Block)TinkerWorld.slimeBlockCongealed, 0, BlockSlime.SlimeType.BLUE.meta);
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(TinkerCommons.slimyMudBlue, new Object[]{congealed, "sand", "dirt"}));
        }
        FurnaceRecipes.func_77602_a().func_151394_a(TinkerCommons.slimyMudGreen, TinkerCommons.matSlimeCrystalGreen, 0.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(TinkerCommons.slimyMudBlue, TinkerCommons.matSlimeCrystalBlue, 0.0f);
        FurnaceRecipes.func_77602_a().func_151394_a(TinkerCommons.slimyMudMagma, TinkerCommons.matSlimeCrystalMagma, 0.0f);
        if (!TinkerTools.isSmelteryLoaded()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TinkerCommons.lavawood, new Object[]{" B ", "BWB", " B ", Character.valueOf('B'), "plankWood", Character.valueOf('W'), Items.field_151129_at}));
        }
    }

    public static void registerToolForgeBlock(String oredict) {
        if (toolForge != null) {
            TinkerTools.toolForge.baseBlocks.add(oredict);
            TinkerTools.registerToolForgeRecipe(oredict);
        }
    }

    private static void registerToolForgeRecipe(String oredict) {
        BlockSeared brick = TinkerSmeltery.searedBlock;
        if (brick == null) {
            brick = Blocks.field_150417_aV;
        }
        GameRegistry.addRecipe((IRecipe)new TableRecipe(OreDictionary.getOres((String)oredict), toolForge, 0, new Object[]{"BBB", "MTM", "M M", Character.valueOf('B'), brick, Character.valueOf('M'), oredict, Character.valueOf('T'), new ItemStack((Block)toolTables, 1, BlockToolTable.TableTypes.ToolStation.meta)}));
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        this.registerFortifyModifiers();
        proxy.postInit();
        MinecraftForge.EVENT_BUS.register((Object)IndestructibleEntityItem.EventHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)new TraitEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ToolEvents());
        MinecraftForge.EVENT_BUS.register((Object)battleSign);
    }

    private <T extends IModifier> T registerModifier(T modifier) {
        TinkerRegistry.registerModifier(modifier);
        modifiers.add(modifier);
        return modifier;
    }

    private void registerFortifyModifiers() {
        fortifyMods = Lists.newArrayList();
        for (Material mat : TinkerRegistry.getAllMaterialsWithStats("head")) {
            fortifyMods.add(new ModFortify(mat));
        }
    }

    private static <T extends ToolCore> T registerTool(T item, String unlocName) {
        tools.add(item);
        return TinkerTools.registerItem(item, unlocName);
    }

    private ToolPart registerToolPart(ToolPart part, String name) {
        ToolPart ret = TinkerTools.registerItem(part, name);
        ItemStack stencil = new ItemStack((Item)pattern);
        Pattern.setTagForPart(stencil, part);
        TinkerRegistry.registerStencilTableCrafting(stencil);
        toolparts.add(ret);
        return ret;
    }

    static {
        tools = Lists.newLinkedList();
        toolparts = Lists.newLinkedList();
        modifiers = Lists.newLinkedList();
    }
}

