/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.multiblock;

import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.mantle.multiblock.MultiServantLogic;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockCuboid;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockDetection;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;

public class MultiblockSmeltery
extends MultiblockCuboid {
    public final TileSmeltery smeltery;
    public boolean hasTank;

    public MultiblockSmeltery(TileSmeltery smeltery) {
        super(true, false, false);
        this.smeltery = smeltery;
        this.hasTank = false;
    }

    @Override
    public MultiblockDetection.MultiblockStructure detectMultiblock(World world, BlockPos center, int limit) {
        this.hasTank = false;
        MultiblockDetection.MultiblockStructure ret = super.detectMultiblock(world, center, limit);
        if (!this.hasTank) {
            return null;
        }
        return ret;
    }

    @Override
    public boolean isValidBlock(World world, BlockPos pos) {
        MultiServantLogic slave;
        if (pos.equals((Object)this.smeltery.func_174877_v())) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultiServantLogic && (slave = (MultiServantLogic)te).hasValidMaster() && !this.smeltery.func_174877_v().equals((Object)slave.getMasterPosition())) {
            return false;
        }
        if (state.func_177230_c() == TinkerSmeltery.searedTank) {
            this.hasTank = true;
            return true;
        }
        return TinkerSmeltery.validSmelteryBlocks.contains((Object)state.func_177230_c());
    }

    @Override
    public boolean isFloorBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == TinkerSmeltery.searedBlock && this.isValidBlock(world, pos);
    }
}

