/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;

public class SmelteryRenderer
extends TileEntitySpecialRenderer<TileSmeltery> {
    public void renderTileEntityAt(@Nonnull TileSmeltery smeltery, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!smeltery.isActive()) {
            return;
        }
        SmelteryTank tank = smeltery.getTank();
        if (tank == null || smeltery.minPos == null || smeltery.maxPos == null) {
            return;
        }
        List<FluidStack> fluids = tank.getFluids();
        double x1 = smeltery.minPos.func_177958_n() - smeltery.func_174877_v().func_177958_n();
        double y1 = smeltery.minPos.func_177956_o() - smeltery.func_174877_v().func_177956_o();
        double z1 = smeltery.minPos.func_177952_p() - smeltery.func_174877_v().func_177952_p();
        double x2 = smeltery.maxPos.func_177958_n() - smeltery.func_174877_v().func_177958_n();
        double z2 = smeltery.maxPos.func_177952_p() - smeltery.func_174877_v().func_177952_p();
        if (!fluids.isEmpty()) {
            BlockPos minPos = new BlockPos(x1, y1, z1);
            BlockPos maxPos = new BlockPos(x2, y1, z2);
            int yd = 1 + Math.max(0, smeltery.maxPos.func_177956_o() - smeltery.minPos.func_177956_o());
            int[] heights = SmelteryRenderer.calcLiquidHeights(fluids, tank.getCapacity(), yd * 1000 - (int)((double)RenderUtil.FLUID_OFFSET * 2000.0), 100);
            double curY = RenderUtil.FLUID_OFFSET;
            for (int i = 0; i < fluids.size(); ++i) {
                double h = (double)heights[i] / 1000.0;
                RenderUtil.renderStackedFluidCuboid(fluids.get(i), x, y, z, smeltery.minPos, minPos, maxPos, curY, curY + h);
                curY += h;
            }
        }
        int xd = 1 + smeltery.maxPos.func_177958_n() - smeltery.minPos.func_177958_n();
        int zd = 1 + smeltery.maxPos.func_177952_p() - smeltery.minPos.func_177952_p();
        int layer = xd * zd;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderUtil.pre(x, y, z);
        GlStateManager.func_179129_p();
        GlStateManager.func_179137_b((double)x1, (double)y1, (double)z1);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        for (int i = 0; i < smeltery.func_70302_i_(); ++i) {
            if (!smeltery.isStackInSlot(i)) continue;
            int h = i / layer;
            int i2 = i % layer;
            BlockPos pos = smeltery.minPos.func_177982_a(i2 % xd, h, i2 / xd);
            int brightness = smeltery.func_145831_w().func_175626_b(pos, 0);
            ItemStack stack = smeltery.func_70301_a(i);
            boolean isItem = !(stack.func_77973_b() instanceof ItemBlock);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)(brightness % 65536) / 1.0f), (float)((float)(brightness / 65536) / 1.0f));
            GlStateManager.func_179109_b((float)(i2 % xd), (float)h, (float)(i2 / xd));
            if (isItem) {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, smeltery.func_145831_w(), null);
            model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.NONE, (boolean)false);
            Minecraft.func_71410_x().func_175599_af().func_180454_a(stack, model);
            if (isItem) {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179109_b((float)(-i2 % xd), (float)(-h), (float)(-i2 / xd));
        }
        RenderHelper.func_74519_b();
        RenderUtil.post();
    }

    public static int[] calcLiquidHeights(List<FluidStack> liquids, int capacity, int height, int min) {
        int[] fluidHeights = new int[liquids.size()];
        if (liquids.size() > 0) {
            for (int i = 0; i < liquids.size(); ++i) {
                FluidStack liquid = liquids.get(i);
                float h = (float)liquid.amount / (float)capacity;
                fluidHeights[i] = Math.max(min, (int)Math.ceil(h * (float)height));
            }
            int sum = 0;
            do {
                sum = 0;
                int biggest = -1;
                int m = 0;
                for (int i = 0; i < fluidHeights.length; ++i) {
                    sum += fluidHeights[i];
                    if (liquids.get((int)i).amount <= biggest) continue;
                    biggest = liquids.get((int)i).amount;
                    m = i;
                }
                if (fluidHeights[m] == 0) break;
                if (sum <= height) continue;
                int n = m;
                fluidHeights[n] = fluidHeights[n] - 1;
            } while (sum > height);
        }
        return fluidHeights;
    }
}

