/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.inventory.ContainerMultiModule;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.client.SmelteryRenderer;
import slimeknights.tconstruct.smeltery.client.module.GuiSmelterySideinventory;
import slimeknights.tconstruct.smeltery.inventory.ContainerSmeltery;
import slimeknights.tconstruct.smeltery.network.SmelteryFluidClicked;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import slimeknights.tconstruct.tools.inventory.ContainerSideInventory;

public class GuiSmeltery
extends GuiMultiModule {
    public static final ResourceLocation BACKGROUND = Util.getResource("textures/gui/smeltery.png");
    protected GuiElement scala = new GuiElement(176, 76, 52, 52, 256, 256);
    protected final GuiSmelterySideinventory sideinventory;
    protected final TileSmeltery smeltery;
    private TileSmeltery.FuelInfo fuelInfo;
    private static Map<Fluid, List<FluidGuiEntry>> fluidGui = Maps.newHashMap();

    public GuiSmeltery(ContainerSmeltery container, TileSmeltery smeltery) {
        super((ContainerMultiModule)container);
        this.smeltery = smeltery;
        this.sideinventory = new GuiSmelterySideinventory(this, container.getSubContainer(ContainerSideInventory.class), smeltery, smeltery.func_70302_i_(), container.calcColumns());
        this.addModule(this.sideinventory);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.smeltery.func_70302_i_() != this.sideinventory.field_147002_h.field_75151_b.size()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX + this.cornerX, mouseY + this.cornerY);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.scala.draw(8, 16);
        if (8 <= (mouseX -= this.cornerX) && mouseX < 60 && 16 <= (mouseY -= this.cornerY) && mouseY < 68) {
            FluidStack hovered = this.getFluidHovered(68 - mouseY - 1);
            ArrayList text = Lists.newArrayList();
            if (hovered == null) {
                int usedCap = this.smeltery.getTank().getFluidAmount();
                int maxCap = this.smeltery.getTank().getCapacity();
                text.add(TextFormatting.WHITE + Util.translate("gui.smeltery.capacity", new Object[0]));
                text.add(TextFormatting.GRAY.toString() + maxCap + Util.translate("gui.smeltery.liquid.millibucket", new Object[0]));
                text.add(Util.translateFormatted("gui.smeltery.capacity_available", new Object[0]));
                text.add(TextFormatting.GRAY.toString() + (maxCap - usedCap) + Util.translate("gui.smeltery.liquid.millibucket", new Object[0]));
            } else {
                text.add(TextFormatting.WHITE + hovered.getLocalizedName());
                this.liquidToString(hovered, text);
            }
            this.func_146283_a(text, mouseX, mouseY);
        } else if (71 <= mouseX && mouseX < 83 && 16 <= mouseY && mouseY < 68) {
            ArrayList text = Lists.newArrayList();
            FluidStack fuel = this.fuelInfo.fluid;
            text.add(TextFormatting.WHITE + Util.translate("gui.smeltery.fuel", new Object[0]));
            if (fuel != null) {
                text.add(fuel.getLocalizedName());
                this.liquidToString(fuel, text);
            } else {
                text.add(Util.translate("gui.smeltery.fuel.empty", new Object[0]));
            }
            text.add(Util.translateFormatted("gui.smeltery.fuel.heat", this.fuelInfo.heat));
            this.func_146283_a(text, mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(BACKGROUND);
        super.func_146976_a(partialTicks, mouseX, mouseY);
        SmelteryTank liquids = this.smeltery.getTank();
        if (liquids.getFluidAmount() > 0) {
            int capacity = Math.max(liquids.getFluidAmount(), liquids.getCapacity());
            int[] heights = this.calcLiquidHeights(liquids.getFluids(), capacity);
            int x = 8 + this.cornerX;
            int y = 16 + this.scala.h + this.cornerY;
            int w = this.scala.w;
            for (int i = 0; i < heights.length; ++i) {
                int h = heights[i];
                FluidStack liquid = liquids.getFluids().get(i);
                RenderUtil.renderTiledFluid(x, y - h, w, h, this.field_73735_i, liquid);
                y -= h;
            }
        }
        this.fuelInfo = this.smeltery.getFuelDisplay();
        if (this.fuelInfo.fluid != null && this.fuelInfo.fluid.amount > 0) {
            int x = 71 + this.cornerX;
            int y = 16 + this.cornerY + 52;
            int w = 12;
            int h = (int)(52.0f * (float)this.fuelInfo.fluid.amount / (float)this.fuelInfo.maxCap);
            RenderUtil.renderTiledFluid(x, y - h, w, h, this.field_73735_i, this.fuelInfo.fluid);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            if (8 <= (mouseX -= this.cornerX) && mouseX < 60 && 16 <= (mouseY -= this.cornerY) && mouseY < 68) {
                SmelteryTank tank = this.smeltery.getTank();
                int[] heights = this.calcLiquidHeights(tank.getFluids(), tank.getCapacity());
                int y = 68 - mouseY - 1;
                for (int i = 0; i < heights.length; ++i) {
                    if (y < heights[i]) {
                        TinkerNetwork.sendToServer((AbstractPacket)new SmelteryFluidClicked(i));
                        return;
                    }
                    y -= heights[i];
                }
            }
            mouseX += this.cornerX;
            mouseY += this.cornerY;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected FluidStack getFluidHovered(int y) {
        SmelteryTank tank = this.smeltery.getTank();
        int[] heights = this.calcLiquidHeights(tank.getFluids(), tank.getCapacity());
        for (int i = 0; i < heights.length; ++i) {
            if (y < heights[i]) {
                return tank.getFluids().get(i);
            }
            y -= heights[i];
        }
        return null;
    }

    protected int[] calcLiquidHeights(List<FluidStack> liquids, int capacity) {
        return SmelteryRenderer.calcLiquidHeights(liquids, capacity, this.scala.h, 3);
    }

    public void liquidToString(FluidStack fluid, List<String> text) {
        int amount = fluid.amount;
        if (!Util.isShiftKeyDown()) {
            List<FluidGuiEntry> entries = fluidGui.get(fluid.getFluid());
            if (entries == null) {
                entries = this.calcFluidGuiEntries(fluid.getFluid());
                fluidGui.put(fluid.getFluid(), entries);
            }
            for (FluidGuiEntry entry : entries) {
                amount = this.calcLiquidText(amount, entry.amount, entry.getText(), text);
            }
        }
        amount = this.calcLiquidText(amount, 1000000, Util.translate("gui.smeltery.liquid.kilobucket", new Object[0]), text);
        amount = this.calcLiquidText(amount, 1000, Util.translate("gui.smeltery.liquid.bucket", new Object[0]), text);
        this.calcLiquidText(amount, 1, Util.translate("gui.smeltery.liquid.millibucket", new Object[0]), text);
    }

    private List<FluidGuiEntry> calcFluidGuiEntries(Fluid fluid) {
        ArrayList list = Lists.newArrayList();
        for (CastingRecipe recipe : TinkerRegistry.getAllBasinCastingRecipes()) {
            if (recipe.getFluid().getFluid() != fluid || recipe.cast != null) continue;
            list.add(new FluidGuiEntry(recipe.getFluid().amount, "gui.smeltery.liquid.block"));
        }
        for (CastingRecipe recipe : TinkerRegistry.getAllTableCastingRecipes()) {
            if (recipe.getFluid().getFluid() != fluid || recipe.cast == null) continue;
            if (recipe.cast.matches(new ItemStack[]{TinkerSmeltery.castNugget}) != null) {
                list.add(new FluidGuiEntry(recipe.getFluid().amount, "gui.smeltery.liquid.nugget"));
            }
            if (recipe.cast.matches(new ItemStack[]{TinkerSmeltery.castIngot}) != null) {
                list.add(new FluidGuiEntry(recipe.getFluid().amount, "gui.smeltery.liquid.ingot"));
            }
            if (recipe.cast.matches(new ItemStack[]{TinkerSmeltery.castGem}) == null) continue;
            list.add(new FluidGuiEntry(recipe.getFluid().amount, "gui.smeltery.liquid.gem"));
        }
        Collections.sort(list, new Comparator<FluidGuiEntry>(){

            @Override
            public int compare(FluidGuiEntry o1, FluidGuiEntry o2) {
                return o2.amount - o1.amount;
            }
        });
        return ImmutableList.copyOf((Collection)list);
    }

    private int calcLiquidText(int amount, int divider, String unit, List<String> text) {
        int full = amount / divider;
        if (full > 0) {
            text.add(String.format("%d %s%s", full, TextFormatting.GRAY, unit));
        }
        return amount % divider;
    }

    private static class FluidGuiEntry {
        public final int amount;
        public final String unlocName;

        private FluidGuiEntry(int amount, String unlocName) {
            this.amount = amount;
            this.unlocName = unlocName;
        }

        public String getText() {
            return Util.translate(this.unlocName, new Object[0]);
        }
    }
}

