/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.TinkerIntegration;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.TinkerPulse;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.Cast;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.smeltery.OreCastingRecipe;
import slimeknights.tconstruct.library.tinkering.MaterialItem;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.block.BlockCasting;
import slimeknights.tconstruct.smeltery.block.BlockFaucet;
import slimeknights.tconstruct.smeltery.block.BlockSeared;
import slimeknights.tconstruct.smeltery.block.BlockSearedGlass;
import slimeknights.tconstruct.smeltery.block.BlockSearedSlab;
import slimeknights.tconstruct.smeltery.block.BlockSearedSlab2;
import slimeknights.tconstruct.smeltery.block.BlockSmelteryController;
import slimeknights.tconstruct.smeltery.block.BlockSmelteryIO;
import slimeknights.tconstruct.smeltery.block.BlockTank;
import slimeknights.tconstruct.smeltery.item.CastCustom;
import slimeknights.tconstruct.smeltery.item.ItemTank;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingBasin;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingTable;
import slimeknights.tconstruct.smeltery.tileentity.TileDrain;
import slimeknights.tconstruct.smeltery.tileentity.TileFaucet;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileSmelteryComponent;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlime;

@Pulse(id="TinkerSmeltery", description="The smeltery and items needed for it")
public class TinkerSmeltery
extends TinkerPulse {
    public static final String PulseId = "TinkerSmeltery";
    static final Logger log = Util.getLogger("TinkerSmeltery");
    @SidedProxy(clientSide="slimeknights.tconstruct.smeltery.SmelteryClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static BlockSeared searedBlock;
    public static BlockSmelteryController smelteryController;
    public static BlockTank searedTank;
    public static BlockFaucet faucet;
    public static BlockCasting castingBlock;
    public static BlockSmelteryIO smelteryIO;
    public static Block searedGlass;
    public static Block searedSlab;
    public static Block searedSlab2;
    public static Block searedStairsStone;
    public static Block searedStairsCobble;
    public static Block searedStairsPaver;
    public static Block searedStairsBrick;
    public static Block searedStairsBrickCracked;
    public static Block searedStairsBrickFancy;
    public static Block searedStairsBrickSquare;
    public static Block searedStairsBrickTriangle;
    public static Block searedStairsBrickSmall;
    public static Block searedStairsRoad;
    public static Block searedStairsTile;
    public static Block searedStairsCreeper;
    public static Cast cast;
    public static CastCustom castCustom;
    public static Cast clayCast;
    public static ItemStack castIngot;
    public static ItemStack castNugget;
    public static ItemStack castGem;
    public static ItemStack castShard;
    public static ItemStack castPlate;
    public static ItemStack castGear;
    private static Map<Fluid, Set<Pair<List<ItemStack>, Integer>>> knownOreFluids;
    public static List<FluidStack> castCreationFluids;
    public static List<FluidStack> clayCreationFluids;
    public static ImmutableSet<Block> validSmelteryBlocks;
    public static List<ItemStack> meltingBlacklist;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        searedBlock = TinkerSmeltery.registerEnumBlock(new BlockSeared(), "seared");
        smelteryController = TinkerSmeltery.registerBlock(new BlockSmelteryController(), "smeltery_controller");
        searedTank = (BlockTank)((Object)TinkerSmeltery.registerBlock((ItemBlock)new ItemTank((Block)new BlockTank()), "seared_tank"));
        faucet = TinkerSmeltery.registerBlock(new BlockFaucet(), "faucet");
        castingBlock = (BlockCasting)((Object)TinkerSmeltery.registerBlock((ItemBlock)new ItemBlockMeta((Block)new BlockCasting()), "casting"));
        smelteryIO = TinkerSmeltery.registerEnumBlock(new BlockSmelteryIO(), "smeltery_io");
        searedGlass = TinkerSmeltery.registerEnumBlock(new BlockSearedGlass(), "seared_glass");
        ItemBlockMeta.setMappingProperty((Block)searedTank, BlockTank.TYPE);
        ItemBlockMeta.setMappingProperty((Block)castingBlock, BlockCasting.TYPE);
        searedSlab = TinkerSmeltery.registerEnumBlockSlab(new BlockSearedSlab(), "seared_slab");
        searedSlab2 = TinkerSmeltery.registerEnumBlockSlab(new BlockSearedSlab2(), "seared_slab2");
        searedStairsStone = TinkerSmeltery.registerBlockStairsFrom(searedBlock, BlockSeared.SearedType.STONE, "seared_stairs_stone");
        searedStairsCobble = TinkerSmeltery.registerBlockStairsFrom(searedBlock, BlockSeared.SearedType.COBBLE, "seared_stairs_cobble");
        searedStairsPaver = TinkerSmeltery.registerBlockStairsFrom(searedBlock, BlockSeared.SearedType.PAVER, "seared_stairs_paver");
        searedStairsBrick = TinkerSmeltery.registerBlockStairsFrom(searedBlock, BlockSeared.SearedType.BRICK, "seared_stairs_brick");
        searedStairsBrickCracked = TinkerSmeltery.registerBlockStairsFrom(searedBlock, BlockSeared.SearedType.BRICK_CRACKED, "seared_stairs_brick_cracked");
        searedStairsBrickFancy = TinkerSmeltery.registerBlockStairsFrom(searedBlock, BlockSeared.SearedType.BRICK_FANCY, "seared_stairs_brick_fancy");
        searedStairsBrickSquare = TinkerSmeltery.registerBlockStairsFrom(searedBlock, BlockSeared.SearedType.BRICK_SQUARE, "seared_stairs_brick_square");
        searedStairsBrickTriangle = TinkerSmeltery.registerBlockStairsFrom(searedBlock, BlockSeared.SearedType.BRICK_TRIANGLE, "seared_stairs_brick_triangle");
        searedStairsBrickSmall = TinkerSmeltery.registerBlockStairsFrom(searedBlock, BlockSeared.SearedType.BRICK_SMALL, "seared_stairs_brick_small");
        searedStairsRoad = TinkerSmeltery.registerBlockStairsFrom(searedBlock, BlockSeared.SearedType.ROAD, "seared_stairs_road");
        searedStairsTile = TinkerSmeltery.registerBlockStairsFrom(searedBlock, BlockSeared.SearedType.TILE, "seared_stairs_tile");
        searedStairsCreeper = TinkerSmeltery.registerBlockStairsFrom(searedBlock, BlockSeared.SearedType.CREEPER, "seared_stairs_creeper");
        TinkerSmeltery.registerTE(TileSmeltery.class, "smeltery_controller");
        TinkerSmeltery.registerTE(TileSmelteryComponent.class, "smeltery_component");
        TinkerSmeltery.registerTE(TileTank.class, "tank");
        TinkerSmeltery.registerTE(TileFaucet.class, "faucet");
        TinkerSmeltery.registerTE(TileCastingTable.class, "casting_table");
        TinkerSmeltery.registerTE(TileCastingBasin.class, "casting_basin");
        TinkerSmeltery.registerTE(TileDrain.class, "smeltery_drain");
        cast = TinkerSmeltery.registerItem(new Cast(), "cast");
        castCustom = TinkerSmeltery.registerItem(new CastCustom(), "cast_custom");
        castIngot = castCustom.addMeta(0, "ingot", 144);
        castNugget = castCustom.addMeta(1, "nugget", 16);
        castGem = castCustom.addMeta(2, "gem", 666);
        castPlate = castCustom.addMeta(3, "plate", 144);
        castGear = castCustom.addMeta(4, "gear", 576);
        clayCast = TinkerSmeltery.registerItem(new Cast(), "clay_cast");
        if (TinkerRegistry.getShard() != null) {
            TinkerRegistry.addCastForItem(TinkerRegistry.getShard());
            castShard = new ItemStack((Item)cast);
            Cast.setTagForPart(castShard, TinkerRegistry.getShard());
        }
        proxy.preInit();
        TinkerRegistry.tabSmeltery.setDisplayIcon(new ItemStack((Block)searedTank));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)searedBlock);
        builder.add((Object)searedTank);
        builder.add((Object)smelteryIO);
        builder.add((Object)searedGlass);
        validSmelteryBlocks = builder.build();
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        castCreationFluids.add(new FluidStack((Fluid)TinkerFluids.gold, 288));
        if (TinkerIntegration.isIntegrated(TinkerFluids.brass)) {
            castCreationFluids.add(new FluidStack((Fluid)TinkerFluids.brass, 144));
        }
        if (FluidRegistry.isFluidRegistered((Fluid)TinkerFluids.clay)) {
            clayCreationFluids.add(new FluidStack((Fluid)TinkerFluids.clay, 288));
        }
        this.registerRecipes();
        proxy.init();
    }

    private void registerRecipes() {
        ItemStack stackSearedStone = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.STONE.getMeta());
        ItemStack stackSearedCobble = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.COBBLE.getMeta());
        ItemStack stackSearedPaver = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.PAVER.getMeta());
        ItemStack stackSearedBrick = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.BRICK.getMeta());
        ItemStack stackSearedBrickCracked = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.BRICK_CRACKED.getMeta());
        ItemStack stackSearedBrickFancy = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.BRICK_FANCY.getMeta());
        ItemStack stackSearedBrickSquare = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.BRICK_SQUARE.getMeta());
        ItemStack stackSearedBrickTriangle = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.BRICK_TRIANGLE.getMeta());
        ItemStack stackSearedBrickSmall = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.BRICK_SMALL.getMeta());
        ItemStack stackSearedRoad = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.ROAD.getMeta());
        ItemStack stackSearedTile = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.TILE.getMeta());
        ItemStack stackSearedCreeper = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.CREEPER.getMeta());
        ItemStack grout = TinkerCommons.grout.func_77946_l();
        grout.field_77994_a = 2;
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(grout, new Object[]{Items.field_151119_aD, Blocks.field_150351_n, "sand"}));
        grout = grout.func_77946_l();
        grout.field_77994_a = 8;
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(grout, new Object[]{Blocks.field_150351_n, "sand", Blocks.field_150351_n, "sand", Blocks.field_150435_aG, "sand", Blocks.field_150351_n, "sand", Blocks.field_150351_n}));
        ItemStack searedBrick = TinkerCommons.searedBrick;
        GameRegistry.addSmelting((ItemStack)TinkerCommons.grout, (ItemStack)TinkerCommons.searedBrick, (float)0.0f);
        GameRegistry.addShapedRecipe((ItemStack)stackSearedBrick, (Object[])new Object[]{"bb", "bb", Character.valueOf('b'), searedBrick});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(searedSlab, 1, BlockSearedSlab.SearedType.BRICK.getMeta()), (Object[])new Object[]{"bb", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)smelteryController), (Object[])new Object[]{"bbb", "b b", "bbb", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)smelteryIO, 1, BlockSmelteryIO.IOType.DRAIN.getMeta()), (Object[])new Object[]{"b b", "b b", "b b", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)searedTank, 1, BlockTank.TankType.TANK.getMeta()), new Object[]{"bbb", "bgb", "bbb", Character.valueOf('b'), searedBrick, Character.valueOf('g'), "blockGlass"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)searedTank, 1, BlockTank.TankType.GAUGE.getMeta()), new Object[]{"bgb", "ggg", "bgb", Character.valueOf('b'), searedBrick, Character.valueOf('g'), "blockGlass"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)searedTank, 1, BlockTank.TankType.WINDOW.getMeta()), new Object[]{"bgb", "bgb", "bgb", Character.valueOf('b'), searedBrick, Character.valueOf('g'), "blockGlass"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(searedGlass, 1, BlockSearedGlass.GlassType.GLASS.getMeta()), new Object[]{" b ", "bgb", " b ", Character.valueOf('b'), searedBrick, Character.valueOf('g'), "blockGlass"}));
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)castingBlock, 1, BlockCasting.CastingType.TABLE.getMeta()), (Object[])new Object[]{"bbb", "b b", "b b", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)castingBlock, 1, BlockCasting.CastingType.BASIN.getMeta()), (Object[])new Object[]{"b b", "b b", "bbb", Character.valueOf('b'), searedBrick});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)faucet), (Object[])new Object[]{"b b", " b ", Character.valueOf('b'), searedBrick});
        this.addSearedBrickRecipe(BlockSeared.SearedType.PAVER, BlockSeared.SearedType.STONE);
        this.addSearedBrickRecipe(BlockSeared.SearedType.BRICK, BlockSeared.SearedType.PAVER);
        this.addSearedBrickRecipe(BlockSeared.SearedType.BRICK_FANCY, BlockSeared.SearedType.BRICK);
        this.addSearedBrickRecipe(BlockSeared.SearedType.BRICK_SQUARE, BlockSeared.SearedType.BRICK_FANCY);
        this.addSearedBrickRecipe(BlockSeared.SearedType.BRICK_TRIANGLE, BlockSeared.SearedType.BRICK_SQUARE);
        this.addSearedBrickRecipe(BlockSeared.SearedType.CREEPER, BlockSeared.SearedType.BRICK_TRIANGLE);
        this.addSearedBrickRecipe(BlockSeared.SearedType.BRICK_SMALL, BlockSeared.SearedType.CREEPER);
        this.addSearedBrickRecipe(BlockSeared.SearedType.TILE, BlockSeared.SearedType.BRICK_SMALL);
        this.addSearedBrickRecipe(BlockSeared.SearedType.ROAD, BlockSeared.SearedType.TILE);
        this.addSearedBrickRecipe(BlockSeared.SearedType.PAVER, BlockSeared.SearedType.ROAD);
        GameRegistry.addSmelting((ItemStack)stackSearedBrick.func_77946_l(), (ItemStack)stackSearedBrickCracked.func_77946_l(), (float)0.1f);
        TinkerSmeltery.addSlabRecipe(new ItemStack(searedSlab, 1, BlockSearedSlab.SearedType.STONE.getMeta()), stackSearedStone.func_77946_l());
        TinkerSmeltery.addSlabRecipe(new ItemStack(searedSlab, 1, BlockSearedSlab.SearedType.COBBLE.getMeta()), stackSearedCobble.func_77946_l());
        TinkerSmeltery.addSlabRecipe(new ItemStack(searedSlab, 1, BlockSearedSlab.SearedType.PAVER.getMeta()), stackSearedPaver.func_77946_l());
        TinkerSmeltery.addSlabRecipe(new ItemStack(searedSlab, 1, BlockSearedSlab.SearedType.BRICK.getMeta()), stackSearedBrick.func_77946_l());
        TinkerSmeltery.addSlabRecipe(new ItemStack(searedSlab, 1, BlockSearedSlab.SearedType.BRICK_CRACKED.getMeta()), stackSearedBrickCracked.func_77946_l());
        TinkerSmeltery.addSlabRecipe(new ItemStack(searedSlab, 1, BlockSearedSlab.SearedType.BRICK_FANCY.getMeta()), stackSearedBrickFancy.func_77946_l());
        TinkerSmeltery.addSlabRecipe(new ItemStack(searedSlab, 1, BlockSearedSlab.SearedType.BRICK_SQUARE.getMeta()), stackSearedBrickSquare.func_77946_l());
        TinkerSmeltery.addSlabRecipe(new ItemStack(searedSlab, 1, BlockSearedSlab.SearedType.ROAD.getMeta()), stackSearedRoad.func_77946_l());
        TinkerSmeltery.addSlabRecipe(new ItemStack(searedSlab2, 1, BlockSearedSlab2.SearedType.CREEPER.getMeta()), stackSearedCreeper.func_77946_l());
        TinkerSmeltery.addSlabRecipe(new ItemStack(searedSlab2, 1, BlockSearedSlab2.SearedType.BRICK_TRIANGLE.getMeta()), stackSearedBrickTriangle.func_77946_l());
        TinkerSmeltery.addSlabRecipe(new ItemStack(searedSlab2, 1, BlockSearedSlab2.SearedType.BRICK_SMALL.getMeta()), stackSearedBrickSmall.func_77946_l());
        TinkerSmeltery.addSlabRecipe(new ItemStack(searedSlab2, 1, BlockSearedSlab2.SearedType.TILE.getMeta()), stackSearedTile.func_77946_l());
        TinkerSmeltery.addStairRecipe(searedStairsStone, stackSearedStone);
        TinkerSmeltery.addStairRecipe(searedStairsCobble, stackSearedCobble);
        TinkerSmeltery.addStairRecipe(searedStairsPaver, stackSearedPaver);
        TinkerSmeltery.addStairRecipe(searedStairsBrick, stackSearedBrick);
        TinkerSmeltery.addStairRecipe(searedStairsBrickCracked, stackSearedBrickCracked);
        TinkerSmeltery.addStairRecipe(searedStairsBrickFancy, stackSearedBrickFancy);
        TinkerSmeltery.addStairRecipe(searedStairsBrickSquare, stackSearedBrickSquare);
        TinkerSmeltery.addStairRecipe(searedStairsRoad, stackSearedRoad);
        TinkerSmeltery.addStairRecipe(searedStairsCreeper, stackSearedCreeper);
        TinkerSmeltery.addStairRecipe(searedStairsBrickTriangle, stackSearedBrickTriangle);
        TinkerSmeltery.addStairRecipe(searedStairsBrickSmall, stackSearedBrickSmall);
        TinkerSmeltery.addStairRecipe(searedStairsTile, stackSearedTile);
    }

    private void addSearedBrickRecipe(BlockSeared.SearedType out, BlockSeared.SearedType in) {
        TinkerSmeltery.addBrickRecipe((Block)searedBlock, out, in);
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        this.registerSmelteryFuel();
        this.registerMeltingCasting();
        this.registerAlloys();
        TinkerSmeltery.registerRecipeOredictMelting();
        for (FluidStack fs : castCreationFluids) {
            TinkerRegistry.registerTableCasting(new ItemStack((Item)cast), null, fs.getFluid(), fs.amount);
            TinkerRegistry.registerTableCasting(new CastingRecipe(castGem, RecipeMatch.of((String)"gemEmerald"), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castIngot, RecipeMatch.of((String)"ingotBrick"), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castIngot, RecipeMatch.of((String)"ingotBrickNether"), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castIngot, (RecipeMatch)new RecipeMatch.Item(TinkerCommons.searedBrick, 1), fs, true, true));
        }
        proxy.postInit();
    }

    private void registerSmelteryFuel() {
        TinkerRegistry.registerSmelteryFuel(new FluidStack(FluidRegistry.LAVA, 50), 100);
    }

    private void registerMeltingCasting() {
        ItemStack stack;
        int bucket = 1000;
        Fluid water = FluidRegistry.WATER;
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((Block)Blocks.field_150432_aD, (int)bucket), water, 305));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((Block)Blocks.field_150403_cj, (int)(bucket * 2)), water, 310));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((Block)Blocks.field_150433_aE, (int)bucket), water, 305));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((Item)Items.field_151126_ay, (int)(bucket / 8)), water, 301));
        TinkerRegistry.registerMelting(Items.field_151078_bh, (Fluid)TinkerFluids.blood, 5);
        if (TinkerCommons.matSlimeBallBlood != null) {
            TinkerRegistry.registerTableCasting(TinkerCommons.matSlimeBallBlood.func_77946_l(), null, TinkerFluids.blood, 160);
        }
        TinkerRegistry.registerMelting(TinkerCommons.matSlimeBallPurple, (Fluid)TinkerFluids.purpleSlime, 250);
        if (TinkerWorld.slimeBlockCongealed != null) {
            Object slimeblock = new ItemStack((Block)TinkerWorld.slimeBlockCongealed, 1, BlockSlime.SlimeType.PURPLE.meta);
            TinkerRegistry.registerMelting((ItemStack)slimeblock, (Fluid)TinkerFluids.purpleSlime, 1000);
            slimeblock = new ItemStack((Block)TinkerWorld.slimeBlock, 1, BlockSlime.SlimeType.PURPLE.meta);
            TinkerRegistry.registerMelting((ItemStack)slimeblock, (Fluid)TinkerFluids.purpleSlime, 2250);
        }
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount(RecipeMatch.of((String)"stone", (int)72), TinkerFluids.searedStone, Material.VALUE_Ore()));
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount(RecipeMatch.of((String)"cobblestone", (int)72), TinkerFluids.searedStone, Material.VALUE_Ore()));
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount(RecipeMatch.of((String)"obsidian", (int)Material.VALUE_Ore()), TinkerFluids.obsidian, Material.VALUE_Ore()));
        TinkerSmeltery.registerToolpartMeltingCasting(TinkerMaterials.obsidian);
        TinkerRegistry.registerBasinCasting(new ItemStack(Blocks.field_150343_Z), null, TinkerFluids.obsidian, Material.VALUE_Ore());
        TinkerRegistry.registerMelting(Items.field_151138_bX, (Fluid)TinkerFluids.iron, 1152);
        TinkerRegistry.registerMelting(Items.field_151136_bY, (Fluid)TinkerFluids.gold, 1152);
        for (IToolPart toolPart : TinkerRegistry.getToolParts()) {
            if (!(toolPart instanceof MaterialItem)) continue;
            stack = toolPart.getItemstackWithMaterial(TinkerMaterials.stone);
            TinkerRegistry.registerMelting(stack, (Fluid)TinkerFluids.searedStone, toolPart.getCost());
        }
        ItemStack blockSeared = new ItemStack((Block)searedBlock);
        blockSeared.func_77964_b(BlockSeared.SearedType.STONE.getMeta());
        TinkerRegistry.registerTableCasting(TinkerCommons.searedBrick, castIngot, TinkerFluids.searedStone, 72);
        TinkerRegistry.registerBasinCasting(blockSeared, null, TinkerFluids.searedStone, 288);
        ItemStack searedCobble = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.COBBLE.getMeta());
        TinkerRegistry.registerBasinCasting(new CastingRecipe(searedCobble, RecipeMatch.of((String)"cobblestone"), TinkerFluids.searedStone, 216));
        TinkerRegistry.registerMelting((Block)searedBlock, (Fluid)TinkerFluids.searedStone, 288);
        TinkerRegistry.registerMelting(TinkerCommons.searedBrick, (Fluid)TinkerFluids.searedStone, 72);
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount(RecipeMatch.of((ItemStack)TinkerCommons.grout, (int)72), TinkerFluids.searedStone, 24));
        stack = new ItemStack(Blocks.field_150346_d, 1, Short.MAX_VALUE);
        RecipeMatch.Item rm = new RecipeMatch.Item(stack, 1, 144);
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount((RecipeMatch)rm, TinkerFluids.dirt, 576));
        TinkerRegistry.registerTableCasting(TinkerCommons.mudBrick, castIngot, TinkerFluids.dirt, 144);
        TinkerRegistry.registerMelting(Items.field_151119_aD, (Fluid)TinkerFluids.clay, 144);
        TinkerRegistry.registerMelting(Blocks.field_150435_aG, (Fluid)TinkerFluids.clay, 576);
        TinkerRegistry.registerBasinCasting(new ItemStack(Blocks.field_150405_ch), null, TinkerFluids.clay, 576);
        TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack(Blocks.field_150405_ch), RecipeMatch.of((ItemStack)new ItemStack(Blocks.field_150406_ce, 1, Short.MAX_VALUE)), new FluidStack(FluidRegistry.WATER, 250), 150, true, false));
        if (Config.castableBricks) {
            TinkerRegistry.registerTableCasting(new ItemStack(Items.field_151118_aC), castIngot, TinkerFluids.clay, 144);
        }
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"gemEmerald", (int)666), TinkerFluids.emerald));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"oreEmerald", (int)((int)(666.0 * Config.oreToIngotRatio))), TinkerFluids.emerald));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"blockEmerald", (int)5994), TinkerFluids.emerald));
        TinkerRegistry.registerTableCasting(new ItemStack(Items.field_151166_bC), castGem, TinkerFluids.emerald, 666);
        TinkerRegistry.registerBasinCasting(new ItemStack(Blocks.field_150475_bE), null, TinkerFluids.emerald, 5994);
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"sand", (int)1000), TinkerFluids.glass));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"blockGlass", (int)1000), TinkerFluids.glass));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"paneGlass", (int)375), TinkerFluids.glass));
        TinkerRegistry.registerTableCasting(new CastingRecipe(new ItemStack(Blocks.field_150410_aZ), null, TinkerFluids.glass, 375, 50));
        TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack(TinkerCommons.blockClearGlass), null, TinkerFluids.glass, 1000, 120));
        TinkerRegistry.registerBasinCasting(new CastingRecipe(TinkerCommons.lavawood, RecipeMatch.of((String)"plankWood"), new FluidStack(FluidRegistry.LAVA, 250), 100, true, false));
        TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack((Block)Blocks.field_150354_m, 1, 1), RecipeMatch.of((ItemStack)new ItemStack((Block)Blocks.field_150354_m, 1, 0)), new FluidStack((Fluid)TinkerFluids.blood, 10), true, false));
        TinkerRegistry.registerEntityMelting(EntityIronGolem.class, new FluidStack((Fluid)TinkerFluids.iron, 18));
        TinkerRegistry.registerEntityMelting(EntitySnowman.class, new FluidStack(FluidRegistry.WATER, 100));
        TinkerRegistry.registerEntityMelting(EntityVillager.class, new FluidStack((Fluid)TinkerFluids.emerald, 6));
    }

    private void registerAlloys() {
        if (Config.obsidianAlloy) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.obsidian, 36), new FluidStack(FluidRegistry.WATER, 125), new FluidStack(FluidRegistry.LAVA, 125));
        }
        TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.clay, 144), new FluidStack(FluidRegistry.WATER, 250), new FluidStack((Fluid)TinkerFluids.searedStone, 72), new FluidStack((Fluid)TinkerFluids.dirt, 144));
        TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.knightslime, 72), new FluidStack((Fluid)TinkerFluids.iron, 72), new FluidStack((Fluid)TinkerFluids.purpleSlime, 125), new FluidStack((Fluid)TinkerFluids.searedStone, 144));
        TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.pigIron, 144), new FluidStack((Fluid)TinkerFluids.iron, 48), new FluidStack((Fluid)TinkerFluids.blood, 33), new FluidStack((Fluid)TinkerFluids.emerald, 74));
        TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.manyullyn, 2), new FluidStack((Fluid)TinkerFluids.cobalt, 2), new FluidStack((Fluid)TinkerFluids.ardite, 2));
        if (TinkerIntegration.isIntegrated(TinkerFluids.bronze) && TinkerIntegration.isIntegrated(TinkerFluids.copper) && TinkerIntegration.isIntegrated(TinkerFluids.tin)) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.bronze, 4), new FluidStack((Fluid)TinkerFluids.copper, 3), new FluidStack((Fluid)TinkerFluids.tin, 1));
        }
        if (TinkerIntegration.isIntegrated(TinkerFluids.electrum) && TinkerIntegration.isIntegrated(TinkerFluids.gold) && TinkerIntegration.isIntegrated(TinkerFluids.silver)) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.electrum, 2), new FluidStack((Fluid)TinkerFluids.gold, 1), new FluidStack((Fluid)TinkerFluids.silver, 1));
        }
        if (TinkerIntegration.isIntegrated(TinkerFluids.alubrass) && TinkerIntegration.isIntegrated(TinkerFluids.copper) && TinkerIntegration.isIntegrated(TinkerFluids.aluminum)) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.alubrass, 4), new FluidStack((Fluid)TinkerFluids.copper, 1), new FluidStack((Fluid)TinkerFluids.aluminum, 3));
        }
        if (TinkerIntegration.isIntegrated(TinkerFluids.brass) && TinkerIntegration.isIntegrated(TinkerFluids.copper) && TinkerIntegration.isIntegrated(TinkerFluids.zinc)) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.brass, 3), new FluidStack((Fluid)TinkerFluids.copper, 2), new FluidStack((Fluid)TinkerFluids.zinc, 1));
        }
    }

    public static void registerToolpartMeltingCasting(Material material) {
        Fluid fluid = material.getFluid();
        for (IToolPart toolPart : TinkerRegistry.getToolParts()) {
            if (!(toolPart instanceof MaterialItem)) continue;
            ItemStack stack = toolPart.getItemstackWithMaterial(material);
            ItemStack cast = new ItemStack((Item)TinkerSmeltery.cast);
            Cast.setTagForPart(cast, stack.func_77973_b());
            if (fluid != null) {
                TinkerRegistry.registerMelting(stack, fluid, toolPart.getCost());
                TinkerRegistry.registerTableCasting(stack, cast, fluid, toolPart.getCost());
            }
            for (FluidStack fs : castCreationFluids) {
                TinkerRegistry.registerTableCasting(new CastingRecipe(cast, RecipeMatch.ofNBT((ItemStack)stack), fs, true, true));
            }
            if (!Config.claycasts) continue;
            ItemStack clayCast = new ItemStack((Item)TinkerSmeltery.clayCast);
            Cast.setTagForPart(clayCast, stack.func_77973_b());
            if (fluid != null) {
                RecipeMatch rm = RecipeMatch.ofNBT((ItemStack)clayCast);
                FluidStack fs = new FluidStack(fluid, toolPart.getCost());
                TinkerRegistry.registerTableCasting(new CastingRecipe(stack, rm, fs, true, false));
            }
            for (FluidStack fs : clayCreationFluids) {
                TinkerRegistry.registerTableCasting(new CastingRecipe(clayCast, RecipeMatch.ofNBT((ItemStack)stack), fs, true, true));
            }
        }
        if (castShard != null) {
            ItemStack stack = TinkerRegistry.getShard(material);
            int cost = TinkerRegistry.getShard().getCost();
            if (fluid != null) {
                TinkerRegistry.registerMelting(stack, fluid, cost);
                TinkerRegistry.registerTableCasting(stack, castShard, fluid, cost);
            }
            for (FluidStack fs : castCreationFluids) {
                TinkerRegistry.registerTableCasting(new CastingRecipe(castShard, RecipeMatch.ofNBT((ItemStack)stack), fs, true, true));
            }
        }
    }

    public static void registerOredictMeltingCasting(Fluid fluid, String ore) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Pair nuggetOre = Pair.of((Object)OreDictionary.getOres((String)("nugget" + ore)), (Object)16);
        Pair ingotOre = Pair.of((Object)OreDictionary.getOres((String)("ingot" + ore)), (Object)144);
        Pair blockOre = Pair.of((Object)OreDictionary.getOres((String)("block" + ore)), (Object)1296);
        Pair oreOre = Pair.of((Object)OreDictionary.getOres((String)("ore" + ore)), (Object)Material.VALUE_Ore());
        Pair oreNetherOre = Pair.of((Object)OreDictionary.getOres((String)("oreNether" + ore)), (Object)((int)(288.0 * Config.oreToIngotRatio)));
        Pair oreDenseOre = Pair.of((Object)OreDictionary.getOres((String)("denseore" + ore)), (Object)((int)(432.0 * Config.oreToIngotRatio)));
        Pair orePoorOre = Pair.of((Object)OreDictionary.getOres((String)("orePoor" + ore)), (Object)((int)(16.0 * Config.oreToIngotRatio)));
        Pair plateOre = Pair.of((Object)OreDictionary.getOres((String)("plate" + ore)), (Object)144);
        Pair gearOre = Pair.of((Object)OreDictionary.getOres((String)("gear" + ore)), (Object)576);
        Pair dustOre = Pair.of((Object)OreDictionary.getOres((String)("dust" + ore)), (Object)144);
        builder.add((Object[])new Pair[]{nuggetOre, ingotOre, blockOre, oreOre, oreNetherOre, oreDenseOre, orePoorOre, plateOre, gearOre, dustOre});
        ImmutableSet knownOres = builder.build();
        for (Pair pair : knownOres) {
            TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((List)((List)pair.getLeft()), (int)((Integer)pair.getRight())), fluid));
        }
        TinkerRegistry.registerTableCasting(new OreCastingRecipe((List)ingotOre.getLeft(), RecipeMatch.ofNBT((ItemStack)castIngot), fluid, (int)((Integer)ingotOre.getRight())));
        TinkerRegistry.registerTableCasting(new OreCastingRecipe((List)nuggetOre.getLeft(), RecipeMatch.ofNBT((ItemStack)castNugget), fluid, (int)((Integer)nuggetOre.getRight())));
        TinkerRegistry.registerBasinCasting(new OreCastingRecipe((List)blockOre.getLeft(), null, fluid, (int)((Integer)blockOre.getRight())));
        TinkerRegistry.registerTableCasting(new OreCastingRecipe((List)plateOre.getLeft(), RecipeMatch.ofNBT((ItemStack)castPlate), fluid, (int)((Integer)plateOre.getRight())));
        TinkerRegistry.registerTableCasting(new OreCastingRecipe((List)gearOre.getLeft(), RecipeMatch.ofNBT((ItemStack)castGear), fluid, (int)((Integer)gearOre.getRight())));
        for (FluidStack fs : castCreationFluids) {
            TinkerRegistry.registerTableCasting(new CastingRecipe(castIngot, RecipeMatch.of((List)((List)ingotOre.getLeft())), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castNugget, RecipeMatch.of((List)((List)nuggetOre.getLeft())), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castPlate, RecipeMatch.of((List)((List)plateOre.getLeft())), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castGear, RecipeMatch.of((List)((List)gearOre.getLeft())), fs, true, true));
        }
        knownOreFluids.put(fluid, (Set<Pair<List<ItemStack>, Integer>>)knownOres);
    }

    private static void registerRecipeOredictMelting() {
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            List<Object> inputs;
            boolean blacklisted = false;
            for (ItemStack blacklistItem : meltingBlacklist) {
                if (!OreDictionary.itemMatches((ItemStack)blacklistItem, (ItemStack)irecipe.func_77571_b(), (boolean)false)) continue;
                blacklisted = true;
                break;
            }
            if (blacklisted || TinkerRegistry.getMelting(irecipe.func_77571_b()) != null) continue;
            if (irecipe instanceof ShapelessOreRecipe) {
                inputs = ((ShapelessOreRecipe)irecipe).getInput();
            } else if (irecipe instanceof ShapedOreRecipe) {
                inputs = Arrays.asList(((ShapedOreRecipe)irecipe).getInput());
            } else if (irecipe instanceof ShapelessRecipes) {
                inputs = Lists.newLinkedList((Iterable)((ShapelessRecipes)irecipe).field_77579_b);
            } else {
                if (!(irecipe instanceof ShapedRecipes)) continue;
                inputs = Arrays.asList((Object[])((ShapedRecipes)irecipe).field_77574_d);
            }
            HashMap known = Maps.newHashMap();
            for (Object o : inputs) {
                if (o == null) continue;
                boolean found = false;
                for (Map.Entry<Fluid, Set<Pair<List<ItemStack>, Integer>>> entry : knownOreFluids.entrySet()) {
                    for (Pair<List<ItemStack>, Integer> pair : entry.getValue()) {
                        if (o != pair.getLeft() && (!(o instanceof ItemStack) || !((List)pair.getLeft()).contains(o))) continue;
                        Integer amount = (Integer)known.get(entry.getKey());
                        if (amount == null) {
                            amount = 0;
                        }
                        amount = amount + (Integer)pair.getRight();
                        known.put(entry.getKey(), amount);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                known.clear();
                break;
            }
            if (known.keySet().size() != 1) continue;
            Fluid fluid = (Fluid)known.keySet().iterator().next();
            ItemStack output = irecipe.func_77571_b().func_77946_l();
            int amount = (Integer)known.get(fluid) / output.field_77994_a;
            output.field_77994_a = 1;
            TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((ItemStack)output, (int)amount), fluid));
            log.trace("Added automatic melting recipe for {} ({} {})", new Object[]{irecipe.func_77571_b().toString(), amount, fluid.getName()});
        }
    }

    static {
        knownOreFluids = Maps.newHashMap();
        castCreationFluids = Lists.newLinkedList();
        clayCreationFluids = Lists.newLinkedList();
        meltingBlacklist = Lists.newLinkedList();
    }
}

