/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.IAoeTool;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.traits.InfiTool;
import slimeknights.tconstruct.tools.traits.ToolGrowth;

public abstract class ToolCore
extends TinkersItem {
    protected static final int DEFAULT_MODIFIERS = 3;
    protected static final ToolGrowth toolGrowth = new ToolGrowth();

    public ToolCore(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.func_77637_a((CreativeTabs)TinkerRegistry.tabTools);
        this.setNoRepair();
        TinkerRegistry.registerTool(this);
        this.addCategory(Category.TOOL);
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolHelper.getDurabilityStat(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, damage);
        if (this.getDamage(stack) == this.getMaxDamage(stack)) {
            ToolHelper.breakTool(stack, null);
        }
    }

    public boolean func_77645_m() {
        return true;
    }

    public float miningSpeedModifier() {
        return 1.0f;
    }

    public abstract float damagePotential();

    public float damageCutoff() {
        return 15.0f;
    }

    public abstract double attackSpeed();

    public float knockback() {
        return 1.0f;
    }

    public boolean dealDamage(ItemStack stack, EntityLivingBase player, EntityLivingBase entity, float damage) {
        if (player instanceof EntityPlayer) {
            return entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), damage);
        }
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), damage);
    }

    protected boolean readyForSpecialAttack(EntityLivingBase player) {
        return player instanceof EntityPlayer && ((EntityPlayer)player).func_184825_o(0.5f) > 0.9f;
    }

    public void reduceDurabilityOnHit(ItemStack stack, EntityPlayer player, float damage) {
        damage = Math.max(1.0f, damage / 10.0f);
        if (!this.hasCategory(Category.WEAPON)) {
            damage *= 2.0f;
        }
        ToolHelper.damageTool(stack, (int)damage, (EntityLivingBase)player);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.isEffective(state) || ToolHelper.isToolEffective(stack, state)) {
            return ToolHelper.calcDigSpeed(stack, state);
        }
        return super.func_150893_a(stack, state);
    }

    public boolean isEffective(IBlockState block) {
        return false;
    }

    public boolean canHarvestBlock(@Nonnull IBlockState state, ItemStack stack) {
        return this.isEffective(state);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (!ToolHelper.isBroken(itemstack) && this instanceof IAoeTool && ((IAoeTool)((Object)this)).isAoeHarvestTool() && ToolHelper.isToolEffective2(itemstack, player.field_70170_p.func_180495_p(pos))) {
            for (BlockPos extraPos : ((IAoeTool)((Object)this)).getAOEBlocks(itemstack, player.field_70170_p, player, pos)) {
                ToolHelper.breakExtraBlock(itemstack, player.field_70170_p, player, extraPos, pos);
            }
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return ToolHelper.attackEntity(stack, this, (EntityLivingBase)player, entity);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return super.onEntitySwing(entityLiving, stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        float speed = ToolHelper.getActualAttackSpeed(stack);
        int time = Math.round(20.0f / speed);
        if (time < target.field_70172_ad / 2) {
            target.field_70172_ad = (target.field_70172_ad + time) / 2;
            target.field_70737_aN = (target.field_70737_aN + time) / 2;
        }
        return super.func_77644_a(stack, target, attacker);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND && !ToolHelper.isBroken(stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)ToolHelper.getActualAttack(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)ToolHelper.getActualAttackSpeed(stack) - 4.0, 0));
        }
        return multimap;
    }

    @Override
    public List<String> getInformation(ItemStack stack) {
        return this.getInformation(stack, true);
    }

    @Override
    public void getTooltip(ItemStack stack, List<String> tooltips) {
        if (ToolHelper.isBroken(stack)) {
            tooltips.add("" + TextFormatting.DARK_RED + TextFormatting.BOLD + this.getBrokenTooltip(stack));
        }
        super.getTooltip(stack, tooltips);
    }

    protected String getBrokenTooltip(ItemStack itemStack) {
        return Util.translate("tooltip.tool.broken", new Object[0]);
    }

    @Override
    public void getTooltipDetailed(ItemStack stack, List<String> tooltips) {
        tooltips.addAll(this.getInformation(stack, false));
    }

    public List<String> getInformation(ItemStack stack, boolean detailed) {
        TooltipBuilder info = new TooltipBuilder(stack);
        info.addDurability(!detailed);
        if (this.hasCategory(Category.HARVEST)) {
            info.addHarvestLevel();
            info.addMiningSpeed();
        }
        info.addAttack();
        if (ToolHelper.getFreeModifiers(stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        return info.getTooltip();
    }

    @Override
    public void getTooltipComponents(ItemStack stack, List<String> tooltips) {
        List<Material> materials = TinkerUtil.getMaterialsFromTagList(TagUtil.getBaseMaterialsTagList(stack));
        List<PartMaterialType> component = this.getRequiredComponents();
        if (materials.size() < component.size()) {
            return;
        }
        for (int i = 0; i < component.size(); ++i) {
            IToolPart part;
            ItemStack partStack;
            PartMaterialType pmt = component.get(i);
            Material material = materials.get(i);
            Iterator<IToolPart> partIter = pmt.getPossibleParts().iterator();
            if (!partIter.hasNext() || (partStack = (part = partIter.next()).getItemstackWithMaterial(material)) == null) continue;
            tooltips.add(material.getTextColor() + TextFormatting.UNDERLINE + partStack.func_82833_r());
            HashSet usedTraits = Sets.newHashSet();
            for (IMaterialStats stats : material.getAllStats()) {
                if (!pmt.usesStat(stats.getIdentifier())) continue;
                tooltips.addAll(stats.getLocalizedInfo());
                for (ITrait trait : pmt.getApplicableTraitsForMaterial(material)) {
                    if (usedTraits.contains(trait)) continue;
                    tooltips.add(material.getTextColor() + trait.getLocalizedName());
                    usedTraits.add(trait);
                }
            }
            tooltips.add("");
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.fontRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return TagUtil.hasEnchantEffect(stack);
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        List<Material> materials = TinkerUtil.getMaterialsFromTagList(TagUtil.getBaseMaterialsTagList(stack));
        LinkedHashSet nameMaterials = Sets.newLinkedHashSet();
        for (int index : this.getRepairParts()) {
            if (index >= materials.size()) continue;
            nameMaterials.add(materials.get(index));
        }
        String itemName = super.func_77653_i(stack);
        if (nameMaterials.isEmpty()) {
            return itemName;
        }
        if (nameMaterials.size() == 1) {
            return ((Material)((Object)nameMaterials.iterator().next())).getLocalizedItemName(itemName);
        }
        StringBuilder sb = new StringBuilder();
        Iterator iter = nameMaterials.iterator();
        Material material = (Material)((Object)iter.next());
        sb.append(material.getLocalizedName());
        while (iter.hasNext()) {
            material = (Material)((Object)iter.next());
            sb.append("-");
            sb.append(material.getLocalizedName());
        }
        sb.append(" ");
        sb.append(itemName);
        return sb.toString();
    }

    public void func_150895_a(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        this.addDefaultSubItems(subItems);
    }

    protected void addDefaultSubItems(List<ItemStack> subItems) {
        for (Material head : TinkerRegistry.getAllMaterials()) {
            if (!head.hasStats("head")) continue;
            ArrayList<Material> mats = new ArrayList<Material>(this.requiredComponents.length);
            for (int i = 0; i < this.requiredComponents.length; ++i) {
                mats.add(head);
            }
            ItemStack tool = this.buildItem(mats);
            if (!this.hasValidMaterials(tool)) continue;
            subItems.add(tool);
        }
    }

    protected void addInfiTool(List<ItemStack> subitems, String name) {
        ItemStack tool = this.getInfiTool(name);
        if (this.hasValidMaterials(tool)) {
            subitems.add(tool);
        }
    }

    protected ItemStack getInfiTool(String name) {
        Object materials = ImmutableList.of((Object)((Object)TinkerMaterials.slime), (Object)((Object)TinkerMaterials.cobalt), (Object)((Object)TinkerMaterials.ardite), (Object)((Object)TinkerMaterials.ardite));
        materials = materials.subList(0, this.requiredComponents.length);
        ItemStack tool = this.buildItem((List<Material>)materials);
        InfiTool.INSTANCE.apply(tool);
        tool.func_151001_c(name);
        return tool;
    }

    public int getHarvestLevel(ItemStack stack, @Nonnull String toolClass) {
        if (this.getToolClasses(stack).contains(toolClass)) {
            NBTTagCompound tag = TagUtil.getToolTag(stack);
            return ToolHelper.getHarvestLevelStat(stack);
        }
        return super.getHarvestLevel(stack, toolClass);
    }

    public String getIdentifier() {
        return Util.getItemLocation(this).func_110623_a();
    }

    public String getLocalizedToolName() {
        return Util.translate(this.func_77658_a() + ".name", new Object[0]);
    }

    public String getLocalizedToolName(Material material) {
        return material.getLocalizedItemName(this.getLocalizedToolName());
    }

    public String getLocalizedDescription() {
        return Util.translate(this.func_77658_a() + ".desc", new Object[0]);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        NBTTagList list = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(list.func_150307_f(i));
            if (trait == null) continue;
            trait.onUpdate(stack, worldIn, entityIn, itemSlot, isSelected);
        }
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (ToolHelper.isBroken(stack)) {
            return false;
        }
        boolean effective = this.isEffective(state) || ToolHelper.isToolEffective(stack, worldIn.func_180495_p(pos));
        int damage = effective ? 1 : 2;
        this.afterBlockBreak(stack, worldIn, state, pos, entityLiving, damage, effective);
        return this.hasCategory(Category.TOOL);
    }

    public void afterBlockBreak(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase player, int damage, boolean wasEffective) {
        NBTTagList list = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(list.func_150307_f(i));
            if (trait == null) continue;
            trait.afterBlockBreak(stack, world, state, pos, player, wasEffective);
        }
        ToolHelper.damageTool(stack, damage, player);
    }

    @Nonnull
    public RayTraceResult func_77621_a(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        return super.func_77621_a(worldIn, playerIn, useLiquids);
    }

    protected void preventSlowDown(Entity entityIn, float originalSpeed) {
        TinkerTools.proxy.preventPlayerSlowdown(entityIn, originalSpeed, this);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        if (oldStack == newStack) {
            return false;
        }
        if (slotChanged) {
            return true;
        }
        if (oldStack.func_77962_s() != newStack.func_77962_s()) {
            return true;
        }
        Multimap attributes = newStack.func_111283_C(EntityEquipmentSlot.MAINHAND);
        for (Map.Entry entry : oldStack.func_111283_C(EntityEquipmentSlot.MAINHAND).entries()) {
            if (!attributes.containsKey(entry.getKey())) {
                return true;
            }
            if (attributes.get(entry.getKey()).equals(entry.getValue())) continue;
            return true;
        }
        if (oldStack.func_77973_b() == newStack.func_77973_b() && newStack.func_77973_b() instanceof ToolCore) {
            return !ToolCore.isEqualTinkersItem(oldStack, newStack);
        }
        return !ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)newStack);
    }

    protected ToolNBT buildDefaultTag(List<Material> materials) {
        ToolNBT data = new ToolNBT();
        if (materials.size() >= 2) {
            HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
            HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
            data.head(head);
            if (materials.size() >= 3) {
                ExtraMaterialStats binding = (ExtraMaterialStats)materials.get(2).getStatsOrUnknown("extra");
                data.extra(binding);
            }
            data.handle(handle);
        }
        data.modifiers = 3;
        return data;
    }

    public static boolean isEqualTinkersItem(ItemStack item1, ItemStack item2) {
        if (item1 == null || item2 == null || item1.func_77973_b() != item2.func_77973_b()) {
            return false;
        }
        if (!(item1.func_77973_b() instanceof ToolCore)) {
            return false;
        }
        NBTTagCompound tag1 = TagUtil.getTagSafe(item1);
        NBTTagCompound tag2 = TagUtil.getTagSafe(item2);
        NBTTagList mods1 = TagUtil.getModifiersTagList(tag1);
        NBTTagList mods2 = TagUtil.getModifiersTagList(tag2);
        if (mods1.func_74745_c() != mods1.func_74745_c()) {
            return false;
        }
        for (int i = 0; i < mods1.func_74745_c(); ++i) {
            NBTTagCompound tag = mods1.func_150305_b(i);
            ModifierNBT data = ModifierNBT.readTag(tag);
            IModifier modifier = TinkerRegistry.getModifier(data.identifier);
            if (modifier == null || modifier.equalModifier(tag, mods2.func_150305_b(i))) continue;
            return false;
        }
        return TagUtil.getBaseMaterialsTagList(tag1).equals((Object)TagUtil.getBaseMaterialsTagList(tag2)) && TagUtil.getBaseModifiersUsed(tag1) == TagUtil.getBaseModifiersUsed(tag2) && TagUtil.getOriginalToolStats(tag1).equals(TagUtil.getOriginalToolStats(tag2));
    }

    static {
        TinkerRegistry.addTrait(toolGrowth);
    }
}

