/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.tconstruct.library.tools.ITinkerProjectile;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TinkerProjectileHandler
implements ITinkerProjectile,
INBTSerializable<NBTTagCompound> {
    private ItemStack parent;

    @Override
    public ItemStack getItemStack() {
        return this.parent;
    }

    @Override
    public void setItemStack(ItemStack stack) {
        this.parent = stack;
    }

    @Override
    public boolean pickup(Entity entity, boolean simulate) {
        ItemStack stack = this.getMatchingItemstackFromInventory(entity, true);
        if (stack != null) {
            if (!simulate) {
                if (ToolHelper.isBroken(stack)) {
                    ToolHelper.unbreakTool(stack);
                }
                ToolHelper.healTool(stack, this.parent.field_77994_a, null);
            }
            return true;
        }
        return false;
    }

    public ItemStack getMatchingItemstackFromInventory(Entity entity, boolean damagedOnly) {
        if (this.parent == null || !entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return null;
        }
        if (entity instanceof EntityLivingBase) {
            ItemStack in = ((EntityLivingBase)entity).func_184614_ca();
            if (ToolCore.isEqualTinkersItem(in, this.parent) && (!damagedOnly || in.func_77952_i() > 0)) {
                return in;
            }
            in = ((EntityLivingBase)entity).func_184592_cb();
            if (ToolCore.isEqualTinkersItem(in, this.parent) && (!damagedOnly || in.func_77952_i() > 0)) {
                return in;
            }
        }
        IItemHandler itemHandler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack in = itemHandler.getStackInSlot(i);
            if (!ToolCore.isEqualTinkersItem(in, this.parent) || damagedOnly && in.func_77952_i() <= 0) continue;
            return in;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.parent != null) {
            this.parent.func_77955_b(tag);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.parent = ItemStack.func_77949_a((NBTTagCompound)nbt);
    }
}

