/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IProjectileStats;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;

public abstract class ProjectileCore
extends ToolCore
implements IProjectileStats {
    public ProjectileCore(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return Math.max(1, Math.round((float)super.getMaxDamage(stack) / 10.0f));
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return false;
    }

    @Override
    public double attackSpeed() {
        return 100.0;
    }

    @Override
    protected String getBrokenTooltip(ItemStack itemStack) {
        return Util.translate("tooltip.tool.empty", new Object[0]);
    }

    @Override
    public List<String> getInformation(ItemStack stack, boolean detailed) {
        TooltipBuilder info = new TooltipBuilder(stack);
        info.addAmmo(!detailed);
        info.addAttack();
        if (ToolHelper.getFreeModifiers(stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        return info.getTooltip();
    }

    @Override
    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack) {
        return this.func_111205_h(slot);
    }

    @Override
    public Multimap<String, AttributeModifier> getProjectileAttributeModifier(ItemStack stack) {
        return super.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack);
    }
}

