/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.smeltery;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import slimeknights.tconstruct.library.smeltery.ISmelteryTankHandler;

public class SmelteryTank
implements IFluidTank,
IFluidHandler {
    protected final ISmelteryTankHandler parent;
    protected List<FluidStack> liquids = Lists.newArrayList();
    protected int maxCapacity = 0;

    public SmelteryTank(ISmelteryTankHandler parent) {
        this.parent = parent;
    }

    public void setCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public List<FluidStack> getFluids() {
        return this.liquids;
    }

    public void setFluids(List<FluidStack> fluids) {
        this.liquids = fluids;
        this.parent.onTankChanged(this.liquids, null);
    }

    @Nullable
    public FluidStack getFluid() {
        return this.liquids.size() > 0 ? this.liquids.get(0) : null;
    }

    public int getFluidAmount() {
        int cap = 0;
        for (FluidStack liquid : this.liquids) {
            cap += liquid.amount;
        }
        return cap;
    }

    public int getCapacity() {
        return this.maxCapacity;
    }

    public FluidTankInfo getInfo() {
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[0];
    }

    public int fill(FluidStack resource, boolean doFill) {
        int used = this.getFluidAmount();
        int usable = Math.min(this.maxCapacity - used, resource.amount);
        if (!doFill) {
            return usable;
        }
        for (FluidStack liquid : this.liquids) {
            if (!liquid.isFluidEqual(resource)) continue;
            liquid.amount += usable;
            this.parent.onTankChanged(this.liquids, liquid);
            return usable;
        }
        resource = resource.copy();
        resource.amount = usable;
        this.liquids.add(resource);
        this.parent.onTankChanged(this.liquids, resource);
        return usable;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquids.isEmpty()) {
            return null;
        }
        FluidStack liquid = new FluidStack(this.liquids.get(0), maxDrain);
        return this.drain(liquid, doDrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        ListIterator<FluidStack> iter = this.liquids.listIterator();
        while (iter.hasNext()) {
            FluidStack liquid = iter.next();
            if (!liquid.isFluidEqual(resource)) continue;
            int drainable = Math.min(resource.amount, liquid.amount);
            if (doDrain) {
                liquid.amount -= drainable;
                if (liquid.amount <= 0) {
                    iter.remove();
                }
                this.parent.onTankChanged(this.liquids, liquid);
            }
            resource = resource.copy();
            resource.amount = drainable;
            return resource;
        }
        return null;
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList taglist = new NBTTagList();
        for (FluidStack liquid : this.liquids) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            liquid.writeToNBT(fluidTag);
            taglist.func_74742_a((NBTBase)fluidTag);
        }
        tag.func_74782_a("Liquids", (NBTBase)taglist);
        tag.func_74768_a("LiquidCapacity", this.maxCapacity);
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList taglist = tag.func_150295_c("Liquids", 10);
        this.liquids.clear();
        for (int i = 0; i < taglist.func_74745_c(); ++i) {
            NBTTagCompound fluidTag = taglist.func_150305_b(i);
            FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
            if (liquid == null) continue;
            this.liquids.add(liquid);
        }
        this.maxCapacity = tag.func_74762_e("LiquidCapacity");
    }

    public void moveFluidToBottom(int index) {
        if (index < this.liquids.size()) {
            FluidStack fluid = this.liquids.get(index);
            this.liquids.remove(index);
            this.liquids.add(0, fluid);
        }
    }
}

