/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;
import slimeknights.tconstruct.library.utils.HarvestLevels;

public class HeadMaterialStats
extends AbstractMaterialStats {
    public static final String TYPE = "head";
    public static final String LOC_Durability = "stat.head.durability.name";
    public static final String LOC_MiningSpeed = "stat.head.miningspeed.name";
    public static final String LOC_Attack = "stat.head.attack.name";
    public static final String LOC_HarvestLevel = "stat.head.harvestlevel.name";
    public static final String LOC_DurabilityDesc = "stat.head.durability.desc";
    public static final String LOC_MiningSpeedDesc = "stat.head.miningspeed.desc";
    public static final String LOC_AttackDesc = "stat.head.attack.desc";
    public static final String LOC_HarvestLevelDesc = "stat.head.harvestlevel.desc";
    public static final String COLOR_Durability = CustomFontColor.valueToColorCode(1.0f);
    public static final String COLOR_Attack = CustomFontColor.encodeColor(215, 100, 100);
    public static final String COLOR_Speed = CustomFontColor.encodeColor(120, 160, 205);
    public final int durability;
    public final int harvestLevel;
    public final float attack;
    public final float miningspeed;

    public HeadMaterialStats(int durability, float miningspeed, float attack, int harvestLevel) {
        super(TYPE);
        this.durability = durability;
        this.miningspeed = miningspeed;
        this.attack = attack;
        this.harvestLevel = harvestLevel;
    }

    @Override
    public List<String> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(HeadMaterialStats.formatDurability(this.durability));
        info.add(HeadMaterialStats.formatHarvestLevel(this.harvestLevel));
        info.add(HeadMaterialStats.formatMiningSpeed(this.miningspeed));
        info.add(HeadMaterialStats.formatAttack(this.attack));
        return info;
    }

    public static String formatDurability(int durability) {
        return HeadMaterialStats.formatNumber(LOC_Durability, COLOR_Durability, durability);
    }

    public static String formatDurability(int durability, int ref) {
        return String.format("%s: %s%s%s/%s%s", Util.translate(LOC_Durability, new Object[0]), CustomFontColor.valueToColorCode((float)durability / (float)ref), Util.df.format(durability), TextFormatting.GRAY.toString(), COLOR_Durability, Util.df.format(ref)) + TextFormatting.RESET;
    }

    public static String formatHarvestLevel(int level) {
        return String.format("%s: %s", Util.translate(LOC_HarvestLevel, new Object[0]), HarvestLevels.getHarvestLevelName(level)) + TextFormatting.RESET;
    }

    public static String formatMiningSpeed(float speed) {
        return HeadMaterialStats.formatNumber(LOC_MiningSpeed, COLOR_Speed, speed);
    }

    public static String formatAttack(float attack) {
        return HeadMaterialStats.formatNumber(LOC_Attack, COLOR_Attack, attack);
    }

    @Override
    public List<String> getLocalizedDesc() {
        ArrayList info = Lists.newArrayList();
        info.add(Util.translate(LOC_DurabilityDesc, new Object[0]));
        info.add(Util.translate(LOC_HarvestLevelDesc, new Object[0]));
        info.add(Util.translate(LOC_MiningSpeedDesc, new Object[0]));
        info.add(Util.translate(LOC_AttackDesc, new Object[0]));
        return info;
    }
}

