/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.entity;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.tools.CapabilityTinkerProjectile;
import slimeknights.tconstruct.library.tools.IProjectileStats;
import slimeknights.tconstruct.library.tools.TinkerProjectileHandler;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.ToolHelper;

public abstract class EntityProjectileBase
extends EntityArrow
implements IEntityAdditionalSpawnData {
    public TinkerProjectileHandler tinkerProjectile = new TinkerProjectileHandler();
    public boolean bounceOnNoDamage = true;
    public boolean defused = false;

    public EntityProjectileBase(World world) {
        super(world);
        this.init();
    }

    public EntityProjectileBase(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    public EntityProjectileBase(World world, EntityPlayer player, float speed, float accuracy, ItemStack stack) {
        this(world);
        this.field_70250_c = player;
        this.field_70251_a = player.func_184812_l_() ? EntityArrow.PickupStatus.CREATIVE_ONLY : EntityArrow.PickupStatus.ALLOWED;
        this.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70177_z, player.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, speed, accuracy);
        this.tinkerProjectile.setItemStack(stack);
    }

    protected void init() {
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        return capability == CapabilityTinkerProjectile.PROJECTILE_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityTinkerProjectile.PROJECTILE_CAPABILITY) {
            return (T)this.tinkerProjectile;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean isDefused() {
        return this.defused;
    }

    protected void defuse() {
        this.defused = true;
    }

    @Nonnull
    protected ItemStack func_184550_j() {
        return this.tinkerProjectile.getItemStack();
    }

    protected void playHitBlockSound(float speed, IBlockState state) {
        Material material = state.func_185904_a();
        if (material == Material.field_151575_d) {
            this.func_184185_a(Sounds.wood_hit, 1.0f, 1.0f);
        } else if (material == Material.field_151576_e) {
            this.func_184185_a(Sounds.stone_hit, 1.0f, 1.0f);
        }
        this.func_184185_a(state.func_177230_c().func_185467_w().func_185844_d(), 0.8f, 1.0f);
    }

    protected void playHitEntitySound() {
    }

    protected double getStuckDepth() {
        return 0.5;
    }

    protected void doLivingHit(EntityLivingBase entityHit) {
    }

    public void onHitBlock(RayTraceResult raytraceResult) {
        BlockPos blockpos = raytraceResult.func_178782_a();
        this.field_145791_d = blockpos.func_177958_n();
        this.field_145792_e = blockpos.func_177956_o();
        this.field_145789_f = blockpos.func_177952_p();
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        this.field_145790_g = iblockstate.func_177230_c();
        this.field_70253_h = this.field_145790_g.func_176201_c(iblockstate);
        this.field_70159_w = (float)(raytraceResult.field_72307_f.field_72450_a - this.field_70165_t);
        this.field_70181_x = (float)(raytraceResult.field_72307_f.field_72448_b - this.field_70163_u);
        this.field_70179_y = (float)(raytraceResult.field_72307_f.field_72449_c - this.field_70161_v);
        float speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)speed * (double)0.05f;
        this.field_70163_u -= this.field_70181_x / (double)speed * (double)0.05f;
        this.field_70161_v -= this.field_70179_y / (double)speed * (double)0.05f;
        this.playHitBlockSound(speed, iblockstate);
        this.field_70254_i = true;
        this.field_70249_b = 7;
        this.func_70243_d(false);
        if (iblockstate.func_185904_a() != Material.field_151579_a) {
            this.field_145790_g.func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
        }
        this.defused = true;
    }

    public void onHitEntity(RayTraceResult raytraceResult) {
        ItemStack item = this.tinkerProjectile.getItemStack();
        boolean bounceOff = false;
        if (item != null && item.func_77973_b() instanceof ToolCore && raytraceResult.field_72308_g instanceof EntityLivingBase && this.field_70250_c instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)this.field_70250_c;
            EntityLivingBase target = (EntityLivingBase)raytraceResult.field_72308_g;
            ItemStack inventoryItem = this.tinkerProjectile.getMatchingItemstackFromInventory((Entity)attacker, false);
            if (inventoryItem == null || inventoryItem.func_77973_b() != item.func_77973_b()) {
                inventoryItem = item;
            }
            this.unequip(attacker, EntityEquipmentSlot.OFFHAND);
            this.unequip(attacker, EntityEquipmentSlot.MAINHAND);
            if (item.func_77973_b() instanceof IProjectileStats) {
                attacker.func_110140_aT().func_111147_b(((IProjectileStats)item.func_77973_b()).getProjectileAttributeModifier(inventoryItem));
            }
            float speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            bounceOff = this.dealDamage(speed, inventoryItem, attacker, target);
            if (item.func_77973_b() instanceof IProjectileStats) {
                attacker.func_110140_aT().func_111148_a(((IProjectileStats)item.func_77973_b()).getProjectileAttributeModifier(inventoryItem));
            }
            this.equip(attacker, EntityEquipmentSlot.MAINHAND);
            this.equip(attacker, EntityEquipmentSlot.OFFHAND);
            if (!bounceOff) {
                this.doLivingHit(target);
            }
        }
        if (bounceOff) {
            if (!this.bounceOnNoDamage) {
                this.func_70106_y();
            }
            this.field_70159_w *= (double)-0.1f;
            this.field_70181_x *= (double)-0.1f;
            this.field_70179_y *= (double)-0.1f;
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.field_70257_an = 0;
        }
        this.playHitEntitySound();
    }

    private void unequip(EntityLivingBase entity, EntityEquipmentSlot slot) {
        ItemStack stack = entity.func_184582_a(slot);
        if (stack != null) {
            entity.func_110140_aT().func_111148_a(stack.func_111283_C(slot));
        }
    }

    private void equip(EntityLivingBase entity, EntityEquipmentSlot slot) {
        ItemStack stack = entity.func_184582_a(slot);
        if (stack != null) {
            entity.func_110140_aT().func_111147_b(stack.func_111283_C(slot));
        }
    }

    public boolean dealDamage(float speed, ItemStack item, EntityLivingBase attacker, EntityLivingBase target) {
        return ToolHelper.attackEntity(item, (ToolCore)item.func_77973_b(), attacker, (Entity)target, true);
    }

    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        BlockPos blockpos;
        IBlockState iblockstate;
        this.func_70030_z();
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        if ((iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.field_145791_d, this.field_145792_e, this.field_145789_f))).func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d(this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.field_70254_i = true;
        }
        if (this.field_70254_i) {
            this.updateInGround(iblockstate);
        } else {
            this.updateInAir();
        }
    }

    protected void updateInGround(IBlockState state) {
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        if (block == this.field_145790_g && meta == this.field_70253_h) {
            ++this.field_70252_j;
            if (this.field_70252_j >= 1200) {
                this.func_70106_y();
            }
        } else {
            this.field_70254_i = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70252_j = 0;
            this.field_70257_an = 0;
        }
        ++this.field_184552_b;
    }

    protected void updateInAir() {
        Entity entity;
        this.field_184552_b = 0;
        ++this.field_70257_an;
        Vec3d oldPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d newPos = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceResult = this.field_70170_p.func_147447_a(oldPos, newPos, false, true, false);
        if (raytraceResult != null) {
            newPos = new Vec3d(raytraceResult.field_72307_f.field_72450_a, raytraceResult.field_72307_f.field_72448_b, raytraceResult.field_72307_f.field_72449_c);
        }
        if ((entity = this.func_184551_a(oldPos, newPos)) != null) {
            raytraceResult = new RayTraceResult(entity);
        }
        if (raytraceResult != null && raytraceResult.field_72308_g != null && raytraceResult.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)raytraceResult.field_72308_g;
            if (entityplayer.field_71075_bZ.field_75102_a || this.field_70250_c instanceof EntityPlayer && !((EntityPlayer)this.field_70250_c).func_96122_a(entityplayer)) {
                raytraceResult = null;
            }
        }
        if (raytraceResult != null) {
            if (raytraceResult.field_72308_g != null) {
                this.onHitEntity(raytraceResult);
            } else {
                this.onHitBlock(raytraceResult);
            }
        }
        if (this.func_70241_g()) {
            this.drawCritParticles();
        }
        this.doMoveUpdate();
        double slowdown = 1.0 - this.getSlowdown();
        if (this.func_70090_H()) {
            for (int l = 0; l < 4; ++l) {
                float f3 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            slowdown = 1.0 - 20.0 * this.getSlowdown();
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        this.field_70159_w *= slowdown;
        this.field_70181_x *= slowdown;
        this.field_70179_y *= slowdown;
        this.field_70181_x -= this.getGravity();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    @Nullable
    protected Entity func_184551_a(@Nonnull Vec3d start, @Nonnull Vec3d end) {
        if (this.isDefused()) {
            return null;
        }
        return super.func_184551_a(start, end);
    }

    public void drawCritParticles() {
        for (int k = 0; k < 4; ++k) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + this.field_70159_w * (double)k / 4.0, this.field_70163_u + this.field_70181_x * (double)k / 4.0, this.field_70161_v + this.field_70179_y * (double)k / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y, new int[0]);
        }
    }

    protected void doMoveUpdate() {
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        double f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
    }

    protected double getSlowdown() {
        return 0.01;
    }

    protected double getGravity() {
        return 0.05;
    }

    public void func_70100_b_(@Nonnull EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.field_70254_i && this.field_70249_b <= 0) {
            boolean pickedUp;
            boolean bl = pickedUp = this.field_70251_a == EntityArrow.PickupStatus.ALLOWED || this.field_70251_a == EntityArrow.PickupStatus.CREATIVE_ONLY && player.field_71075_bZ.field_75098_d;
            if (pickedUp) {
                pickedUp = this.tinkerProjectile.pickup((Entity)player, this.field_70251_a != EntityArrow.PickupStatus.ALLOWED);
            }
            if (pickedUp) {
                this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    public void func_70014_b(NBTTagCompound tags) {
        super.func_70014_b(tags);
        tags.func_74782_a("item", (NBTBase)this.tinkerProjectile.serializeNBT());
    }

    public void func_70037_a(NBTTagCompound tags) {
        super.func_70037_a(tags);
        this.tinkerProjectile.deserializeNBT(tags.func_74775_l("item"));
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeFloat(this.field_70177_z);
        int id = this.field_70250_c == null ? this.func_145782_y() : this.field_70250_c.func_145782_y();
        data.writeInt(id);
        data.writeDouble(this.field_70159_w);
        data.writeDouble(this.field_70181_x);
        data.writeDouble(this.field_70179_y);
        ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.tinkerProjectile.getItemStack());
    }

    public void readSpawnData(ByteBuf data) {
        this.field_70177_z = data.readFloat();
        this.field_70250_c = this.field_70170_p.func_73045_a(data.readInt());
        this.field_70159_w = data.readDouble();
        this.field_70181_x = data.readDouble();
        this.field_70179_y = data.readDouble();
        this.tinkerProjectile.setItemStack(ByteBufUtils.readItemStack((ByteBuf)data));
    }
}

