/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import slimeknights.tconstruct.library.client.model.BakedMaterialModel;
import slimeknights.tconstruct.library.client.model.BakedToolModel;
import slimeknights.tconstruct.library.client.model.MaterialModel;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.client.model.ModifierModel;

public class ToolModel
implements IModel {
    private final List<MaterialModel> partBlocks;
    private final List<MaterialModel> brokenPartBlocks;
    private final Float[] layerRotations;
    private final ModifierModel modifiers;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transformsBlocking;
    private final ImmutableList<ResourceLocation> textures;

    public ToolModel(ImmutableList<ResourceLocation> defaultTextures, List<MaterialModel> parts, List<MaterialModel> brokenPartBlocks, Float[] layerRotations, ModifierModel modifiers, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transformsBlocking) {
        this.partBlocks = parts;
        this.brokenPartBlocks = brokenPartBlocks;
        this.layerRotations = layerRotations;
        this.modifiers = modifiers;
        this.transforms = transforms;
        this.transformsBlocking = transformsBlocking;
        this.textures = defaultTextures;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.textures);
        if (this.modifiers != null) {
            builder.addAll(this.modifiers.getTextures());
        }
        return builder.build();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        int i;
        IBakedModel base = new ItemLayerModel(this.textures).bake(state, format, bakedTextureGetter);
        BakedMaterialModel[] partModels = new BakedMaterialModel[this.partBlocks.size()];
        BakedMaterialModel[] brokenPartModels = new BakedMaterialModel[this.partBlocks.size()];
        for (i = 0; i < this.partBlocks.size(); ++i) {
            MaterialModel m = this.partBlocks.get(i);
            partModels[i] = m.bakeIt(this.getStateForPart(i, state), format, bakedTextureGetter);
        }
        for (i = 0; i < this.brokenPartBlocks.size(); ++i) {
            if (this.brokenPartBlocks.get(i) == null) continue;
            brokenPartModels[i] = this.brokenPartBlocks.get(i).bakeIt(this.getStateForPart(i, state), format, bakedTextureGetter);
        }
        Object modifierModels = this.modifiers != null ? this.modifiers.bakeModels(state, format, bakedTextureGetter) : new THashMap();
        HashMap builder = Maps.newHashMap();
        builder.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state));
        builder.putAll(this.transforms);
        HashMap builder2 = Maps.newHashMap();
        builder2.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state));
        builder2.putAll(this.transformsBlocking);
        return new BakedToolModel(base, partModels, brokenPartModels, (Map<String, IBakedModel>)modifierModels, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.copyOf((Map)builder), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.copyOf((Map)builder2));
    }

    private IModelState getStateForPart(int i, IModelState originalState) {
        if (this.layerRotations.length > i) {
            return new ModelStateComposition(originalState, (IModelState)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(null, TRSRTransformation.quatFromXYZ((float)0.0f, (float)0.0f, (float)((float)((double)this.layerRotations[i].floatValue() * Math.PI / 180.0))), null, null)));
        }
        return originalState;
    }

    public IModelState getDefaultState() {
        return ModelHelper.DEFAULT_TOOL_STATE;
    }
}

