/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.io.IOUtils;
import slimeknights.tconstruct.library.client.deserializer.ItemCameraTransformsDeserializer;
import slimeknights.tconstruct.library.client.deserializer.ItemTransformVec3fDeserializer;

public class ModelHelper
extends slimeknights.mantle.client.ModelHelper {
    public static final EnumFacing[] MODEL_SIDES = new EnumFacing[]{null, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    static final Type maptype = new TypeToken<Map<String, String>>(){}.getType();
    static final Type offsettype = new TypeToken<Offset>(){}.getType();
    static final Type transformtype = new TypeToken<ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>>(){}.getType();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(maptype, (Object)ModelTextureDeserializer.INSTANCE).registerTypeAdapter(offsettype, (Object)OffsetDeserializer.INSTANCE).registerTypeAdapter(transformtype, (Object)TransformDeserializer.INSTANCE).registerTypeAdapter(ItemCameraTransforms.class, (Object)ItemCameraTransformsDeserializer.INSTANCE).registerTypeAdapter(ItemTransformVec3f.class, (Object)ItemTransformVec3fDeserializer.INSTANCE).create();

    public static Reader getReaderForResource(ResourceLocation location) throws IOException {
        ResourceLocation file = new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".json");
        IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(file);
        return new BufferedReader(new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8));
    }

    public static Map<String, String> loadTexturesFromJson(ResourceLocation location) throws IOException {
        Reader reader = ModelHelper.getReaderForResource(location);
        try {
            Map map = (Map)GSON.fromJson(reader, maptype);
            return map;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static Offset loadOffsetFromJson(ResourceLocation location) throws IOException {
        Reader reader = ModelHelper.getReaderForResource(location);
        try {
            Offset offset = (Offset)GSON.fromJson(reader, offsettype);
            return offset;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> loadTransformFromJson(ResourceLocation location) throws IOException {
        return ModelHelper.loadTransformFromJson(location, "display");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> loadTransformFromJson(ResourceLocation location, String tag) throws IOException {
        Reader reader = ModelHelper.getReaderForResource(location);
        try {
            TransformDeserializer.tag = tag;
            ImmutableMap transforms = (ImmutableMap)GSON.fromJson(reader, transformtype);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : transforms.entrySet()) {
                if (((TRSRTransformation)entry.getValue()).equals((Object)TRSRTransformation.identity())) continue;
                builder.put(entry.getKey(), entry.getValue());
            }
            UnmodifiableIterator unmodifiableIterator = builder.build();
            return unmodifiableIterator;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> loadTransformFromJsonBackup(ResourceLocation location) throws IOException {
        Reader reader = ModelHelper.getReaderForResource(location);
        try {
            ModelBlock modelBlock = ModelBlock.func_178307_a((Reader)reader);
            ItemCameraTransforms itemCameraTransforms = modelBlock.func_181682_g();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
                if (itemCameraTransforms.func_181688_b(type) == ItemTransformVec3f.field_178366_a) continue;
                builder.put((Object)type, (Object)new TRSRTransformation(itemCameraTransforms.func_181688_b(type)));
            }
            ImmutableMap immutableMap = builder.build();
            return immutableMap;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransforms(IPerspectiveAwareModel model) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            TRSRTransformation transformation = new TRSRTransformation((Matrix4f)model.handlePerspective(type).getRight());
            if (transformation.equals((Object)TRSRTransformation.identity())) continue;
            builder.put((Object)type, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)transformation));
        }
        return builder.build();
    }

    public static ImmutableList<ResourceLocation> loadTextureListFromJson(ResourceLocation location) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String s : ModelHelper.loadTexturesFromJson(location).values()) {
            builder.add((Object)new ResourceLocation(s));
        }
        return builder.build();
    }

    public static Float[] loadLayerRotations(ResourceLocation location) throws IOException {
        JsonReader reader = new JsonReader(ModelHelper.getReaderForResource(location));
        try {
            reader.beginObject();
            while (reader.hasNext()) {
                if ("layerrotation".equals(reader.nextName())) {
                    Float[] floatArray = (Float[])GSON.fromJson(reader, Float[].class);
                    return floatArray;
                }
                reader.skipValue();
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader);
        }
        return new Float[0];
    }

    public static ResourceLocation getModelLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a() + ".json");
    }

    public static class Offset {
        public int x;
        public int y;
    }

    public static class TransformDeserializer
    implements JsonDeserializer<ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>> {
        public static final TransformDeserializer INSTANCE = new TransformDeserializer();
        public static String tag;

        public ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            JsonElement texElem = obj.get(tag);
            if (texElem != null && texElem.isJsonObject()) {
                ItemCameraTransforms itemCameraTransforms = (ItemCameraTransforms)context.deserialize((JsonElement)texElem.getAsJsonObject(), ItemCameraTransforms.class);
                return IPerspectiveAwareModel.MapWrapper.getTransforms((ItemCameraTransforms)itemCameraTransforms);
            }
            return ImmutableMap.of();
        }
    }

    public static class OffsetDeserializer
    implements JsonDeserializer<Offset> {
        public static final OffsetDeserializer INSTANCE = new OffsetDeserializer();
        private static final Gson GSON = new Gson();

        public Offset deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            JsonElement texElem = obj.get("offset");
            if (texElem == null) {
                return new Offset();
            }
            return (Offset)GSON.fromJson(texElem, offsettype);
        }
    }

    public static class ModelTextureDeserializer
    implements JsonDeserializer<Map<String, String>> {
        public static final ModelTextureDeserializer INSTANCE = new ModelTextureDeserializer();
        private static final Gson GSON = new Gson();

        public Map<String, String> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            JsonElement texElem = obj.get("textures");
            if (texElem == null) {
                throw new JsonParseException("Missing textures entry in json");
            }
            return (Map)GSON.fromJson(texElem, maptype);
        }
    }
}

