/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.model.DummyModel;
import slimeknights.tconstruct.library.client.model.MaterialModel;
import slimeknights.tconstruct.library.client.model.ModelHelper;

public class MaterialModelLoader
implements ICustomModelLoader {
    public static String EXTENSION = ".tmat";

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation.func_110623_a().endsWith(EXTENSION);
    }

    public IModel loadModel(ResourceLocation modelLocation) {
        if (!Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            return DummyModel.INSTANCE;
        }
        try {
            ModelHelper.Offset offset = ModelHelper.loadOffsetFromJson(modelLocation);
            MaterialModel model = new MaterialModel(ModelHelper.loadTextureListFromJson(modelLocation), offset.x, offset.y);
            CustomTextureCreator.registerTextures(model.getTextures());
            return model;
        }
        catch (IOException e) {
            TinkerRegistry.log.error("Could not load material model {}", new Object[]{modelLocation.toString()});
            return ModelLoaderRegistry.getMissingModel();
        }
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
    }
}

