/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import slimeknights.mantle.client.model.BakedSimple;
import slimeknights.mantle.client.model.BakedWrapper;
import slimeknights.tconstruct.library.client.model.BakedMaterialModel;
import slimeknights.tconstruct.library.utils.TagUtil;

public class BakedToolModel
extends BakedWrapper.Perspective {
    protected BakedMaterialModel[] parts;
    protected BakedMaterialModel[] brokenParts;
    protected Map<String, IBakedModel> modifierParts;
    protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> blockingTransforms;

    public BakedToolModel(IBakedModel parent, BakedMaterialModel[] parts, BakedMaterialModel[] brokenParts, Map<String, IBakedModel> modifierParts, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transform, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> blockingTransform) {
        super(parent, transform);
        if (parts.length != brokenParts.length) {
            throw new RuntimeException("TinkerModel: Length of Parts and BrokenParts Array has to match");
        }
        this.parts = parts;
        this.brokenParts = brokenParts;
        this.modifierParts = modifierParts;
        this.transforms = transform;
        this.blockingTransforms = blockingTransform;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ToolItemOverrideList.INSTANCE;
    }

    private static class ToolItemOverrideList
    extends ItemOverrideList {
        static ToolItemOverrideList INSTANCE = new ToolItemOverrideList();

        private ToolItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
            NBTTagCompound baseTag = TagUtil.getBaseTag(stack);
            if (!baseTag.func_82582_d()) {
                int i;
                BakedToolModel original = (BakedToolModel)originalModel;
                BakedMaterialModel[] parts = original.parts;
                BakedMaterialModel[] brokenParts = original.brokenParts;
                Map<String, IBakedModel> modifierParts = original.modifierParts;
                NBTTagCompound toolTag = TagUtil.getToolTag(stack);
                NBTTagList materials = TagUtil.getBaseMaterialsTagList(stack);
                NBTTagList modifiers = TagUtil.getBaseModifiersTagList(stack);
                ImmutableList.Builder quads = ImmutableList.builder();
                boolean broken = toolTag.func_74767_n("Broken");
                for (i = 0; i < parts.length; ++i) {
                    String id = materials.func_150307_f(i);
                    IBakedModel partModel = broken && brokenParts[i] != null ? brokenParts[i].getModelByIdentifier(id) : parts[i].getModelByIdentifier(id);
                    quads.addAll((Iterable)partModel.func_188616_a(null, null, 0L));
                }
                for (i = 0; i < modifiers.func_74745_c(); ++i) {
                    String modId = modifiers.func_150307_f(i);
                    IBakedModel modModel = modifierParts.get(modId);
                    if (modModel == null) continue;
                    quads.addAll((Iterable)modModel.func_188616_a(null, null, 0L));
                }
                ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transform = original.transforms;
                if (entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack) {
                    transform = original.blockingTransforms;
                }
                return new BakedSimple(quads.build(), transform, (IBakedModel)original);
            }
            return originalModel;
        }
    }
}

