/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.capability;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import slimeknights.tconstruct.library.capability.CapabilityTinkerPiggyback;
import slimeknights.tconstruct.library.capability.ITinkerPiggyback;
import slimeknights.tconstruct.library.capability.TinkerPiggybackHandler;

public class TinkerPiggybackSerializer
implements ICapabilitySerializable<NBTTagCompound> {
    private final EntityPlayer player;
    private final ITinkerPiggyback piggyback;

    public TinkerPiggybackSerializer(@Nonnull EntityPlayer player) {
        this.player = player;
        this.piggyback = new TinkerPiggybackHandler();
        this.piggyback.setRiddenPlayer(player);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityTinkerPiggyback.PIGGYBACK;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityTinkerPiggyback.PIGGYBACK) {
            return (T)this.piggyback;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagList riderList = new NBTTagList();
        for (Entity entity : this.player.func_184182_bu()) {
            NBTTagCompound entityTag = new NBTTagCompound();
            NBTTagCompound entityDataTag = new NBTTagCompound();
            entity.func_189511_e(entityDataTag);
            entityDataTag.func_74778_a("id", EntityList.func_75621_b((Entity)entity));
            entityTag.func_186854_a("Attach", entity.func_184187_bx().func_110124_au());
            entityTag.func_74782_a("Entity", (NBTBase)entityDataTag);
            riderList.func_74742_a((NBTBase)entityTag);
        }
        tagCompound.func_74782_a("riders", (NBTBase)riderList);
        if (riderList.func_82582_d()) {
            return new NBTTagCompound();
        }
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList riderList = nbt.func_150295_c("riders", 10);
        HashMap attachedTo = Maps.newHashMap();
        for (int i = 0; i < riderList.func_74745_c(); ++i) {
            NBTTagCompound entityTag = riderList.func_150305_b(i);
            Entity entity = AnvilChunkLoader.func_186051_a((NBTTagCompound)entityTag.func_74775_l("Entity"), (World)this.player.field_70170_p, (boolean)true);
            if (entity == null) continue;
            UUID uuid = entityTag.func_186857_a("Attach");
            attachedTo.put(uuid, entity);
        }
    }
}

