/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.block;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.TinkerRegistry;

public class BlockPunji
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool NORTHEAST = PropertyBool.func_177716_a((String)"northeast");
    public static final PropertyBool NORTHWEST = PropertyBool.func_177716_a((String)"northwest");
    private static final ImmutableMap<EnumFacing, AxisAlignedBB> BOUNDS;

    public BlockPunji() {
        super(Material.field_151585_k);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabGadgets);
        this.func_149711_c(3.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTHEAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTHWEST, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, NORTH, EAST, NORTHEAST, NORTHWEST});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta >= EnumFacing.values().length) {
            meta = EnumFacing.DOWN.ordinal();
        }
        EnumFacing face = EnumFacing.values()[meta];
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        int off = -facing.ordinal() % 2;
        EnumFacing face1 = EnumFacing.values()[(facing.ordinal() + 2) % 6];
        EnumFacing face2 = EnumFacing.values()[(facing.ordinal() + 4 + off) % 6];
        IBlockState north = worldIn.func_180495_p(pos.func_177972_a(face1));
        IBlockState east = worldIn.func_180495_p(pos.func_177972_a(face2));
        if (north.func_177230_c() == this && north.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(true));
        }
        if (east.func_177230_c() == this && east.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(true));
        }
        IBlockState northeast = worldIn.func_180495_p(pos.func_177972_a(face1).func_177972_a(face2));
        IBlockState northwest = worldIn.func_180495_p(pos.func_177972_a(face1).func_177972_a(face2.func_176734_d()));
        if (northeast.func_177230_c() == this && northeast.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)NORTHEAST, (Comparable)Boolean.valueOf(true));
        }
        if (northwest.func_177230_c() == this && northwest.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)NORTHWEST, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = facing.func_176734_d();
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public boolean func_176198_a(@Nonnull World worldIn, @Nonnull BlockPos pos, EnumFacing side) {
        return worldIn.isSideSolid(pos.func_177972_a(side.func_176734_d()), side, true);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (!worldIn.isSideSolid(pos.func_177972_a(facing), facing.func_176734_d(), true)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (AxisAlignedBB)BOUNDS.get((Object)state.func_177229_b((IProperty)FACING));
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            float damage = 3.0f;
            if (entityIn.field_70143_R > 0.0f) {
                damage += entityIn.field_70143_R * 1.5f + 2.0f;
            }
            entityIn.func_70097_a(DamageSource.field_76367_g, damage);
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, 1));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)EnumFacing.DOWN, (Object)new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.375, 0.8125));
        builder.put((Object)EnumFacing.UP, (Object)new AxisAlignedBB(0.1875, 0.625, 0.1875, 0.8125, 1.0, 0.8125));
        builder.put((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 0.375));
        builder.put((Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.1875, 0.1875, 0.625, 0.8125, 0.8125, 1.0));
        builder.put((Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.625, 0.1875, 0.1875, 1.0, 0.8125, 0.8125));
        builder.put((Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.375, 0.8125, 0.8125));
        BOUNDS = builder.build();
    }

    private static enum Corner implements IStringSerializable
    {
        NONE_UP,
        NORTH_DOWN,
        EAST_UP,
        EAST_DOWN,
        SOUTH_UP,
        SOUTH_DOWN,
        WEST_UP,
        WEST_DOWN;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }
    }
}

