/*
 * Decompiled with CFR 0.152.
 */
package net.quetzi.morpheus.world;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.quetzi.morpheus.Morpheus;

public class WorldSleepState {
    private int dimension;
    private HashMap<String, Boolean> playerStatus;

    public WorldSleepState(int dimension) {
        this.dimension = dimension;
        this.playerStatus = new HashMap();
    }

    public int getPercentSleeping() {
        return this.playerStatus.size() - this.getMiningPlayers() > 0 ? (this.getSleepingPlayers() > 0 ? this.getSleepingPlayers() * 100 / (this.playerStatus.size() - this.getMiningPlayers()) : 0) : 100;
    }

    private int getMiningPlayers() {
        int miningPlayers = 0;
        for (EntityPlayer player : MinecraftServer.func_71276_C().func_71218_a((int)this.dimension).field_73010_i) {
            if (!(player.field_70163_u < (double)Morpheus.groundLevel)) continue;
            ++miningPlayers;
        }
        return !Morpheus.includeMiners ? miningPlayers : 0;
    }

    public int getSleepingPlayers() {
        int asleepCount = 0;
        for (Map.Entry<String, Boolean> entry : this.playerStatus.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            ++asleepCount;
        }
        return asleepCount;
    }

    public String toString() {
        return Morpheus.includeMiners ? this.getSleepingPlayers() + "/" + this.playerStatus.size() + " (" + this.getPercentSleeping() + "%)" : this.getSleepingPlayers() + "/" + this.playerStatus.size() + " - " + this.getMiningPlayers() + " miners (" + this.getPercentSleeping() + "%)";
    }

    public void setPlayerAsleep(String username) {
        this.playerStatus.put(username, true);
    }

    public void setPlayerAwake(String username) {
        this.playerStatus.put(username, false);
    }

    public boolean isPlayerSleeping(String username) {
        if (this.playerStatus.containsKey(username)) {
            return this.playerStatus.get(username);
        }
        this.playerStatus.put(username, false);
        return false;
    }

    public void removePlayer(String username) {
        this.playerStatus.remove(username);
    }

    public void wakeAllPlayers() {
        for (Map.Entry<String, Boolean> entry : this.playerStatus.entrySet()) {
            entry.setValue(false);
        }
    }
}

