/*
 * Decompiled with CFR 0.152.
 */
package net.quetzi.morpheus;

import java.util.HashMap;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.quetzi.morpheus.MorpheusRegistry;
import net.quetzi.morpheus.commands.CommandMorpheus;
import net.quetzi.morpheus.helpers.MorpheusEventHandler;
import net.quetzi.morpheus.helpers.SleepChecker;
import net.quetzi.morpheus.world.WorldSleepState;
import org.apache.logging.log4j.Logger;

@Mod(modid="Morpheus", name="Morpheus", version="1.8.8-2.0.55", dependencies="required-after:Forge@[11.14.0.1239,);", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.8.8]")
public class Morpheus {
    public static int perc;
    public static String onSleepText;
    public static String onWakeText;
    public static String onMorningText;
    public static Logger mLog;
    public static final HashMap<Integer, WorldSleepState> playerSleepStatus;
    public static final SleepChecker checker;
    public static MorpheusRegistry register;
    private static boolean alertEnabled;
    public static boolean includeMiners;
    public static int groundLevel;
    public static Configuration config;
    @Mod.Instance(value="Morpheus")
    public static Morpheus INSTANCE;

    public static boolean isAlertEnabled() {
        return alertEnabled;
    }

    public static void setAlertPlayers(boolean state) {
        alertEnabled = state;
    }

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent event) {
        mLog = event.getModLog();
        mLog.info("Loading configuration");
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        perc = config.get("settings", "SleeperPerc", 50).getInt();
        alertEnabled = config.get("settings", "AlertEnabled", true).getBoolean();
        onSleepText = config.get("settings", "OnSleepText", "is now sleeping.").getString();
        onWakeText = config.get("settings", "OnWakeText", "has left their bed.").getString();
        onMorningText = config.get("settings", "OnMorningText", "Wakey, wakey, rise and shine... Good Morning everyone!").getString();
        includeMiners = config.get("settings", "IncludeMiners", true).getBoolean();
        groundLevel = config.getInt("settings", "GroundLevel", 64, 1, 255, "Ground Level (1-255)");
        config.save();
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new MorpheusEventHandler());
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandMorpheus());
    }

    static {
        playerSleepStatus = new HashMap();
        checker = new SleepChecker();
        register = new MorpheusRegistry();
    }
}

