/*
 * Decompiled with CFR 0.152.
 */
package net.quetzi.morpheus.helpers;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.quetzi.morpheus.Morpheus;
import net.quetzi.morpheus.MorpheusRegistry;
import net.quetzi.morpheus.helpers.DateHandler;

public class SleepChecker {
    private HashMap<Integer, Boolean> alertSent = new HashMap();

    public void updatePlayerStates(World world) {
        for (EntityPlayer player : world.field_73010_i) {
            String username = player.func_146103_bH().getName();
            if (player.func_71026_bH() && !Morpheus.playerSleepStatus.get(player.field_71093_bK).isPlayerSleeping(username)) {
                Morpheus.playerSleepStatus.get(player.field_71093_bK).setPlayerAsleep(username);
                this.alertPlayers(this.createAlert(player.field_71093_bK, player.getDisplayNameString(), Morpheus.onSleepText), world);
                continue;
            }
            if (player.func_71026_bH() || !Morpheus.playerSleepStatus.get(player.field_71093_bK).isPlayerSleeping(username)) continue;
            Morpheus.playerSleepStatus.get(player.field_71093_bK).setPlayerAwake(username);
            if (world.func_72935_r() || this.alertSent.get(world.field_73011_w.func_177502_q()).booleanValue()) continue;
            this.alertPlayers(this.createAlert(player.field_71093_bK, player.getDisplayNameString(), Morpheus.onWakeText), world);
        }
        if (this.areEnoughPlayersAsleep(world.field_73011_w.func_177502_q())) {
            this.advanceToMorning(world);
        } else {
            this.alertSent.put(world.field_73011_w.func_177502_q(), false);
        }
    }

    private void alertPlayers(ChatComponentText alert, World world) {
        if (alert != null && Morpheus.isAlertEnabled()) {
            for (EntityPlayer player : world.field_73010_i) {
                player.func_146105_b((IChatComponent)alert);
            }
        }
    }

    private ChatComponentText createAlert(int dimension, String username, String text) {
        String alertText = EnumChatFormatting.WHITE + username + EnumChatFormatting.GOLD + " " + text + " " + Morpheus.playerSleepStatus.get(dimension).toString();
        Morpheus.mLog.info(username + " " + text + " " + Morpheus.playerSleepStatus.get(dimension).toString());
        return new ChatComponentText(alertText);
    }

    private void advanceToMorning(World world) {
        try {
            MorpheusRegistry.registry.get(world.field_73011_w.func_177502_q()).startNewDay();
        }
        catch (Exception e) {
            Morpheus.mLog.error("Exception caught while starting a new day for dimension " + world.field_73011_w.func_177502_q());
        }
        if (!this.alertSent.get(world.field_73011_w.func_177502_q()).booleanValue()) {
            this.alertPlayers(new ChatComponentText(DateHandler.getMorningText()), world);
            Morpheus.playerSleepStatus.get(world.field_73011_w.func_177502_q()).wakeAllPlayers();
            this.alertSent.put(world.field_73011_w.func_177502_q(), true);
        }
        world.field_73011_w.resetRainAndThunder();
    }

    private boolean areEnoughPlayersAsleep(int dimension) {
        return (dimension == 0 || MorpheusRegistry.registry.get(dimension) != null) && Morpheus.playerSleepStatus.get(dimension).getPercentSleeping() >= Morpheus.perc;
    }
}

