/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.entity.IFuelable;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;

public class TileEntityBuggyFueler
extends TileEntityMulti
implements IMultiBlock,
IFuelable,
IFuelDock,
ICargoEntity {
    private IDockable dockedEntity;
    private boolean initialised;

    public TileEntityBuggyFueler() {
        super(null);
    }

    public void func_73660_a() {
        if (!this.initialised) {
            if (!this.field_145850_b.field_72995_K) {
                this.onCreate(this.field_145850_b, this.func_174877_v());
            }
            this.initialiseMultiTiles(this.func_174877_v(), this.field_145850_b);
            this.initialised = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            List list = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - 1.5, (double)this.func_174877_v().func_177956_o() - 2.0, (double)this.func_174877_v().func_177952_p() - 1.5, (double)this.func_174877_v().func_177958_n() + 1.5, (double)this.func_174877_v().func_177956_o() + 4.0, (double)this.func_174877_v().func_177952_p() + 1.5), input -> input instanceof IFuelable);
            boolean changed = false;
            for (Object o : list) {
                IDockable fuelable;
                if (o == null || !(o instanceof IDockable) || this.field_145850_b.field_72995_K || !(fuelable = (IDockable)o).isDockValid(this)) continue;
                this.dockedEntity = fuelable;
                this.dockedEntity.setPad(this);
                changed = true;
            }
            if (!changed) {
                if (this.dockedEntity != null) {
                    this.dockedEntity.setPad(null);
                }
                this.dockedEntity = null;
            }
        }
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public void onCreate(World world, BlockPos placedPosition) {
        this.mainBlockPosition = placedPosition;
        this.func_70296_d();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(placedPosition, positions);
        ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(world, positions, placedPosition, this.getMultiType());
    }

    @Override
    public BlockMulti.EnumBlockMultiType getMultiType() {
        return BlockMulti.EnumBlockMultiType.BUGGY_FUEL_PAD;
    }

    @Override
    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
        int y = placedPosition.func_177956_o();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (x == 0 && z == 0) continue;
                positions.add(new BlockPos(placedPosition.func_177958_n() + x, y, placedPosition.func_177952_p() + z));
            }
        }
    }

    @Override
    public void onDestroy(TileEntity callingBlock) {
        BlockPos thisBlock = this.func_174877_v();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(thisBlock, positions);
        for (BlockPos pos : positions) {
            IBlockState stateAt = this.field_145850_b.func_180495_p(pos);
            if (stateAt.func_177230_c() != GCBlocks.fakeBlock || (BlockMulti.EnumBlockMultiType)((Object)stateAt.func_177229_b((IProperty)BlockMulti.MULTI_TYPE)) != BlockMulti.EnumBlockMultiType.BUGGY_FUEL_PAD) continue;
            if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(pos, this.field_145850_b.func_180495_p(pos));
            }
            this.field_145850_b.func_175655_b(pos, false);
        }
        this.field_145850_b.func_175655_b(thisBlock, true);
        if (this.dockedEntity != null) {
            this.dockedEntity.onPadDestroyed();
            this.dockedEntity = null;
        }
    }

    @Override
    public int addFuel(FluidStack liquid, boolean doFill) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.addFuel(liquid, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack removeFuel(int amount) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.removeFuel(amount);
        }
        return null;
    }

    @Override
    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.addCargo(stack, doAdd);
        }
        return ICargoEntity.EnumCargoLoadingState.NOTARGET;
    }

    @Override
    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.removeCargo(doRemove);
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.NOTARGET, ItemStack.field_190927_a);
    }

    @Override
    public HashSet<ILandingPadAttachable> getConnectedTiles() {
        HashSet<ILandingPadAttachable> connectedTiles = new HashSet<ILandingPadAttachable>();
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                TileEntity tile;
                if (x != -2 && x != 2 && z != -2 && z != 2 || Math.abs(x) == Math.abs(z) || (tile = this.field_145850_b.func_175625_s(new BlockPos(this.func_174877_v().func_177958_n() + x, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + z))) == null || !(tile instanceof ILandingPadAttachable) || !((ILandingPadAttachable)tile).canAttachToLandingPad((IBlockAccess)this.field_145850_b, this.func_174877_v())) continue;
                connectedTiles.add((ILandingPadAttachable)tile);
            }
        }
        return connectedTiles;
    }

    @Override
    public boolean isBlockAttachable(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ILandingPadAttachable) {
            return ((ILandingPadAttachable)tile).canAttachToLandingPad(world, this.func_174877_v());
        }
        return false;
    }

    @Override
    public IDockable getDockedEntity() {
        return this.dockedEntity;
    }

    @Override
    public void dockEntity(IDockable entity) {
        this.dockedEntity = entity;
    }
}

