/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.dimension;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.entities.EntityLander;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TeleportTypeMoon
implements ITeleportType {
    @Override
    public boolean useParachute() {
        return ConfigManagerCore.disableLander;
    }

    @Override
    public Vector3 getPlayerSpawnLocation(WorldServer world, EntityPlayerMP player) {
        if (player != null) {
            GCPlayerStats stats = GCPlayerStats.get((Entity)player);
            double x = stats.getCoordsTeleportedFromX();
            double z = stats.getCoordsTeleportedFromZ();
            int limit = ConfigManagerCore.otherPlanetWorldBorders - 2;
            if (limit > 20) {
                if (x > (double)limit) {
                    z *= (double)limit / x;
                    x = limit;
                } else if (x < (double)(-limit)) {
                    z *= (double)(-limit) / x;
                    x = -limit;
                }
                if (z > (double)limit) {
                    x *= (double)limit / z;
                    z = limit;
                } else if (z < (double)(-limit)) {
                    x *= (double)(-limit) / z;
                    z = -limit;
                }
            }
            return new Vector3(x, ConfigManagerCore.disableLander ? 250.0 : 900.0, z);
        }
        return null;
    }

    @Override
    public Vector3 getEntitySpawnLocation(WorldServer world, Entity entity) {
        return new Vector3(entity.field_70165_t, ConfigManagerCore.disableLander ? 250.0 : 900.0, entity.field_70161_v);
    }

    @Override
    public Vector3 getParaChestSpawnLocation(WorldServer world, EntityPlayerMP player, Random rand) {
        if (ConfigManagerCore.disableLander) {
            double x = (rand.nextDouble() * 2.0 - 1.0) * 4.0;
            double z = (rand.nextDouble() * 2.0 - 1.0) * 4.0;
            return new Vector3(player.field_70165_t + x, 220.0, player.field_70161_v + z);
        }
        return null;
    }

    @Override
    public void onSpaceDimensionChanged(World newWorld, EntityPlayerMP player, boolean ridingAutoRocket) {
        GCPlayerStats stats = GCPlayerStats.get((Entity)player);
        if (!ridingAutoRocket && !ConfigManagerCore.disableLander && stats.getTeleportCooldown() <= 0) {
            if (player.field_71075_bZ.field_75100_b) {
                player.field_71075_bZ.field_75100_b = false;
            }
            EntityLander lander = new EntityLander(player);
            lander.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            if (!newWorld.field_72995_K) {
                CompatibilityManager.forceLoadChunks((WorldServer)newWorld);
                lander.field_98038_p = true;
                newWorld.func_72838_d((Entity)lander);
                CompatibilityManager.forceLoadChunksEnd((WorldServer)newWorld);
            }
            stats.setTeleportCooldown(10);
        }
    }

    @Override
    public void setupAdventureSpawn(EntityPlayerMP player) {
    }
}

