/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.render.tile;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import micdoodle8.mods.galacticraft.core.Constants;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDish;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class TileEntityDishRenderer
extends TileEntitySpecialRenderer<TileEntityDish> {
    private static final ResourceLocation textureSupport = new ResourceLocation(Constants.ASSET_PREFIX, "textures/model/telesupport.png");
    private static final ResourceLocation textureFork = new ResourceLocation(Constants.ASSET_PREFIX, "textures/model/telefork.png");
    private static final ResourceLocation textureDish = new ResourceLocation(Constants.ASSET_PREFIX, "textures/model/teledish.png");
    private static OBJModel.OBJBakedModel modelSupport;
    private static OBJModel.OBJBakedModel modelFork;
    private static OBJModel.OBJBakedModel modelDish;
    private TextureManager renderEngine;

    public TileEntityDishRenderer() {
        this.renderEngine = FMLClientHandler.instance().getClient().field_71446_o;
    }

    private void updateModels() {
        if (modelDish == null) {
            try {
                Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                OBJModel teleDish = (OBJModel)ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(Constants.ASSET_PREFIX, "teledish.obj"));
                OBJModel teleFork = (OBJModel)ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(Constants.ASSET_PREFIX, "telefork.obj"));
                OBJModel teleSupp = (OBJModel)ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(Constants.ASSET_PREFIX, "telesupport.obj"));
                teleDish = (OBJModel)teleDish.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                teleFork = (OBJModel)teleFork.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                teleSupp = (OBJModel)teleSupp.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                modelDish = (OBJModel.OBJBakedModel)teleDish.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"main"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
                modelFork = (OBJModel.OBJBakedModel)teleFork.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"main"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
                modelSupport = (OBJModel.OBJBakedModel)teleSupp.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"main"), false), DefaultVertexFormats.field_176599_b, spriteFunction);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void renderTileEntityAt(TileEntityDish tile, double par2, double par4, double par6, float partialTickTime, int par9) {
        this.updateModels();
        TileEntityDish dish = tile;
        float hour = dish.rotation(partialTickTime) % 360.0f;
        float declination = dish.elevation(partialTickTime) % 360.0f;
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)par2), (float)((float)par4), (float)((float)par6));
        GL11.glTranslatef((float)0.5f, (float)1.0f, (float)0.5f);
        GL11.glScalef((float)1.6f, (float)1.25f, (float)1.6f);
        this.renderEngine.func_110577_a(textureSupport);
        ClientUtil.drawBakedModel((IBakedModel)modelSupport);
        GL11.glScalef((float)1.25f, (float)1.6f, (float)1.25f);
        GL11.glTranslatef((float)0.0f, (float)0.27f, (float)0.0f);
        GL11.glScalef((float)0.85f, (float)0.85f, (float)0.85f);
        GL11.glRotatef((float)hour, (float)0.0f, (float)-1.0f, (float)0.0f);
        this.renderEngine.func_110577_a(textureFork);
        ClientUtil.drawBakedModel((IBakedModel)modelFork);
        GL11.glTranslatef((float)0.0f, (float)2.3f, (float)0.0f);
        GL11.glRotatef((float)declination, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-2.3f, (float)0.0f);
        this.renderEngine.func_110577_a(textureDish);
        ClientUtil.drawBakedModel((IBakedModel)modelDish);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }
}

