/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui.screen;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.Constants;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementCheckboxPreLaunch;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiPreLaunchChecklist
extends GuiScreen
implements GuiElementCheckboxPreLaunch.ICheckBoxCallback {
    private static final ResourceLocation bookGuiTexture = new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/checklist_book.png");
    private int bookImageWidth = 192;
    private int bookImageHeight = 192;
    private Map<String, List<String>> checklistKeys;
    private int currPage = 0;
    private int bookTotalPages;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private NBTTagCompound tagCompound;
    private Map<Integer, String> checkboxToKeyMap = Maps.newHashMap();

    public GuiPreLaunchChecklist(Map<String, List<String>> checklistKeys, NBTTagCompound tagCompound) {
        this.tagCompound = tagCompound != null ? tagCompound : new NBTTagCompound();
        this.checklistKeys = checklistKeys;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.checkboxToKeyMap.clear();
        int i = (this.field_146294_l - this.bookImageWidth) / 2;
        int j = 2;
        this.buttonNextPage = new NextPageButton(0, i + 120, j + 154, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(1, i + 38, j + 154, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        int yPos = 25;
        int index = 2;
        int page = 0;
        for (Map.Entry<String, List<String>> e : this.checklistKeys.entrySet()) {
            String title = e.getKey();
            List<String> checkboxes = e.getValue();
            GuiElementCheckboxPreLaunch element = new GuiElementCheckboxPreLaunch(index, this, this.field_146294_l / 2 - 73 + 11, yPos, GCCoreUtil.translate(title), 0);
            int size = element.willFit(152 - yPos);
            if (size >= 0) {
                if (page == this.currPage) {
                    this.field_146292_n.add(element);
                    this.checkboxToKeyMap.put(element.field_146127_k, title);
                    ++index;
                }
                yPos += size + this.field_146297_k.field_71466_p.field_78288_b / 2;
            } else {
                yPos = 25;
                size = element.willFit(152 - yPos);
                element = new GuiElementCheckboxPreLaunch(index, this, this.field_146294_l / 2 - 73 + 11, yPos, GCCoreUtil.translate(title), 0);
                if (++page == this.currPage) {
                    this.field_146292_n.add(element);
                    this.checkboxToKeyMap.put(element.field_146127_k, title);
                    ++index;
                }
                yPos += size + this.field_146297_k.field_71466_p.field_78288_b / 2;
            }
            for (String checkbox : checkboxes) {
                element = new GuiElementCheckboxPreLaunch(index, this, this.field_146294_l / 2 - 73 + 16, yPos, GCCoreUtil.translate("checklist." + checkbox + ".key"), 0);
                size = element.willFit(152 - yPos);
                if (size >= 0) {
                    if (page == this.currPage) {
                        this.field_146292_n.add(element);
                        this.checkboxToKeyMap.put(element.field_146127_k, title + "." + checkbox + ".key");
                        ++index;
                    }
                    yPos += size + this.field_146297_k.field_71466_p.field_78288_b / 2;
                    continue;
                }
                yPos = 25;
                size = element.willFit(152 - yPos);
                element = new GuiElementCheckboxPreLaunch(index, this, this.field_146294_l / 2 - 73 + 16, yPos, GCCoreUtil.translate("checklist." + checkbox + ".key"), 0);
                if (++page == this.currPage) {
                    this.field_146292_n.add(element);
                    this.checkboxToKeyMap.put(element.field_146127_k, title + "." + checkbox + ".key");
                    ++index;
                }
                yPos += size + this.field_146297_k.field_71466_p.field_78288_b / 2;
            }
        }
        this.bookTotalPages = page + 1;
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.currPage < this.bookTotalPages - 1;
        this.buttonPreviousPage.field_146125_m = this.currPage > 0;
    }

    private void onDataChange() {
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiElementCheckboxPreLaunch)) continue;
            this.tagCompound.func_74757_a(this.checkboxToKeyMap.get(button.field_146127_k), ((GuiElementCheckboxPreLaunch)button).isSelected.booleanValue());
        }
        GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_CHECKLIST, GCCoreUtil.getDimensionID(this.field_146297_k.field_71439_g.field_70170_p), new Object[]{this.tagCompound}));
        ItemStack stack = this.field_146297_k.field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74782_a("checklistData", (NBTBase)this.tagCompound);
        stack.func_77982_d(tagCompound);
    }

    protected void func_146284_a(GuiButton buttonClicked) {
        if (buttonClicked == this.buttonNextPage) {
            ++this.currPage;
            this.func_73866_w_();
        } else if (buttonClicked == this.buttonPreviousPage) {
            --this.currPage;
            this.func_73866_w_();
        }
    }

    public void func_73876_c() {
    }

    public void func_73863_a(int par1, int par2, float par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(bookGuiTexture);
        int i = (this.field_146294_l - this.bookImageWidth) / 2;
        int j = 2;
        this.func_73729_b(i, j, 0, 0, this.bookImageWidth, this.bookImageHeight);
        super.func_73863_a(par1, par2, par3);
    }

    @Override
    public void onSelectionChanged(GuiElementCheckboxPreLaunch element, boolean newSelected) {
        boolean started = false;
        for (int i = 2; i < this.field_146292_n.size(); ++i) {
            GuiButton button = (GuiButton)this.field_146292_n.get(i);
            if (started) {
                if (button.field_146128_h <= element.field_146128_h) break;
                ((GuiElementCheckboxPreLaunch)button).isSelected = newSelected;
                continue;
            }
            if (button != element) continue;
            started = true;
        }
        this.onDataChange();
    }

    @Override
    public boolean canPlayerEdit(GuiElementCheckboxPreLaunch checkbox, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean getInitiallySelected(GuiElementCheckboxPreLaunch checkbox) {
        return this.tagCompound.func_74767_n(this.checkboxToKeyMap.get(checkbox.field_146127_k));
    }

    @Override
    public void onIntruderInteraction() {
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean forward;

        public NextPageButton(int id, int x, int y, boolean forward) {
            super(id, x, y, 23, 13, "");
            this.forward = forward;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(bookGuiTexture);
                int i = 0;
                int j = 192;
                if (flag) {
                    i += 23;
                }
                if (!this.forward) {
                    j += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, i, j, 23, 13);
            }
        }
    }
}

