/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWallGC
extends Block
implements ISortableBlock {
    protected static final AxisAlignedBB[] AABB_BY_INDEX = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.3125, 1.0, 0.875, 0.6875), new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    protected static final AxisAlignedBB[] CLIP_AABB_BY_INDEX = new AxisAlignedBB[]{AABB_BY_INDEX[0].func_186666_e(1.5), AABB_BY_INDEX[1].func_186666_e(1.5), AABB_BY_INDEX[2].func_186666_e(1.5), AABB_BY_INDEX[3].func_186666_e(1.5), AABB_BY_INDEX[4].func_186666_e(1.5), AABB_BY_INDEX[5].func_186666_e(1.5), AABB_BY_INDEX[6].func_186666_e(1.5), AABB_BY_INDEX[7].func_186666_e(1.5), AABB_BY_INDEX[8].func_186666_e(1.5), AABB_BY_INDEX[9].func_186666_e(1.5), AABB_BY_INDEX[10].func_186666_e(1.5), AABB_BY_INDEX[11].func_186666_e(1.5), AABB_BY_INDEX[12].func_186666_e(1.5), AABB_BY_INDEX[13].func_186666_e(1.5), AABB_BY_INDEX[14].func_186666_e(1.5), AABB_BY_INDEX[15].func_186666_e(1.5)};
    public static PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);

    public BlockWallGC(String name) {
        super(Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149752_b(2.5f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)UP, (Comparable)Boolean.FALSE).func_177226_a((IProperty)NORTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)EAST, (Comparable)Boolean.FALSE).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.FALSE).func_177226_a((IProperty)WEST, (Comparable)Boolean.FALSE).func_177226_a((IProperty)VARIANT, (Comparable)((Object)BlockType.TIN_1_WALL)));
        this.func_149663_c(name);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return AABB_BY_INDEX[BlockWallGC.getAABBIndex(state)];
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        blockState = this.func_176221_a(blockState, worldIn, pos);
        return CLIP_AABB_BY_INDEX[BlockWallGC.getAABBIndex(blockState)];
    }

    private static int getAABBIndex(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    private boolean canConnectTo(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block == Blocks.field_180401_cv ? false : (block != this && !(block instanceof BlockFenceGate) ? (block.func_149688_o(state).func_76218_k() && block.func_149686_d(state) ? block.func_149688_o(state) != Material.field_151572_C : false) : true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < (GalacticraftCore.isPlanetsLoaded ? 6 : 4); ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN ? super.func_176225_a(blockState, blockAccess, pos, side) : true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BlockType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean flag = this.canConnectTo(world, pos.func_177978_c());
        boolean flag1 = this.canConnectTo(world, pos.func_177974_f());
        boolean flag2 = this.canConnectTo(world, pos.func_177968_d());
        boolean flag3 = this.canConnectTo(world, pos.func_177976_e());
        boolean flag4 = flag && !flag1 && flag2 && !flag3 || !flag && flag1 && !flag2 && flag3;
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(!flag4 || !world.func_175623_d(pos.func_177984_a()))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(flag)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(flag1)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(flag2)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(flag3));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, NORTH, EAST, WEST, SOUTH, VARIANT});
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.WALLS;
    }

    public static enum BlockType implements IStringSerializable
    {
        TIN_1_WALL("tin_1_wall"),
        TIN_2_WALL("tin_2_wall"),
        MOON_STONE_WALL("moon_stone_wall"),
        MOON_DUNGEON_BRICK_WALL("moon_dungeon_brick_wall"),
        MARS_COBBLESTONE_WALL("mars_cobblestone_wall"),
        MARS_DUNGEON_BRICK_WALL("mars_dungeon_brick_wall");

        private String name;

        private BlockType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

