/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCircuitFabricator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCoalGenerator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityElectricIngotCompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenStorageModule;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BlockMachine2
extends BlockTileGC
implements IShiftDescription,
ISortableBlock {
    public static final int ELECTRIC_COMPRESSOR_METADATA = 0;
    public static final int CIRCUIT_FABRICATOR_METADATA = 4;
    public static final int OXYGEN_STORAGE_MODULE_METADATA = 8;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", EnumMachineExtendedType.class);

    public BlockMachine2(String assetName) {
        super(GCBlocks.machine);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(assetName);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityCoalGenerator) {
            TileEntityCoalGenerator tileEntity = (TileEntityCoalGenerator)tile;
            if (tileEntity.heatGJperTick > 0.0f) {
                int metadata = this.func_176201_c(stateIn);
                float particlePosX = (float)pos.func_177958_n() + 0.5f;
                float particlePosY = (float)pos.func_177956_o() + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
                float particlePosZ = (float)pos.func_177952_p() + 0.5f;
                float particleSize0 = 0.52f;
                float particleSize1 = rand.nextFloat() * 0.6f - 0.3f;
                if (metadata == 3) {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX - particleSize0), (double)particlePosY, (double)(particlePosZ + particleSize1), 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)(particlePosX - particleSize0), (double)particlePosY, (double)(particlePosZ + particleSize1), 0.0, 0.0, 0.0, new int[0]);
                } else if (metadata == 2) {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX + particleSize0), (double)particlePosY, (double)(particlePosZ + particleSize1), 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)(particlePosX + particleSize0), (double)particlePosY, (double)(particlePosZ + particleSize1), 0.0, 0.0, 0.0, new int[0]);
                } else if (metadata == 1) {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX + particleSize1), (double)particlePosY, (double)(particlePosZ - particleSize0), 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)(particlePosX + particleSize1), (double)particlePosY, (double)(particlePosZ - particleSize0), 0.0, 0.0, 0.0, new int[0]);
                } else if (metadata == 0) {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX + particleSize1), (double)particlePosY, (double)(particlePosZ + particleSize0), 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)(particlePosX + particleSize1), (double)particlePosY, (double)(particlePosZ + particleSize0), 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int metadata = this.func_176201_c(state);
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = EnumFacing.func_176731_b((int)angle).func_176734_d().func_176736_b();
        if (metadata >= 8) {
            worldIn.func_180501_a(pos, this.func_176203_a(8 + change), 3);
        } else if (metadata >= 4) {
            worldIn.func_180501_a(pos, this.func_176203_a(4 + change), 3);
        } else if (metadata >= 0) {
            worldIn.func_180501_a(pos, this.func_176203_a(0 + change), 3);
        }
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        int metadata = this.func_176201_c(world.func_180495_p(pos));
        int change = ((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING)).func_176746_e().func_176736_b();
        world.func_180501_a(pos, this.func_176203_a(metadata - metadata % 4 + change), 3);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileBaseUniversalElectrical) {
            ((TileBaseUniversalElectrical)te).updateFacing();
        }
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            entityPlayer.openGui((Object)GalacticraftCore.instance, -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int metadata = this.func_176201_c(state);
        if (metadata >= 8) {
            return new TileEntityOxygenStorageModule();
        }
        if (metadata >= 4) {
            return new TileEntityCircuitFabricator();
        }
        if (metadata >= 0) {
            return new TileEntityElectricIngotCompressor();
        }
        return null;
    }

    public ItemStack getElectricCompressor() {
        return new ItemStack((Block)this, 1, 0);
    }

    public ItemStack getCircuitFabricator() {
        return new ItemStack((Block)this, 1, 4);
    }

    public ItemStack getOxygenStorageModule() {
        return new ItemStack((Block)this, 1, 8);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)this.getElectricCompressor());
        list.add((Object)this.getCircuitFabricator());
        list.add((Object)this.getOxygenStorageModule());
    }

    public int func_180651_a(IBlockState state) {
        int metadata = this.func_176201_c(state);
        if (metadata >= 8) {
            return 8;
        }
        if (metadata >= 4) {
            return 4;
        }
        if (metadata >= 0) {
            return 0;
        }
        return 0;
    }

    @Override
    public String getShiftDescription(int meta) {
        switch (meta) {
            case 4: {
                return GCCoreUtil.translate("tile.circuit_fabricator.description");
            }
            case 0: {
                return GCCoreUtil.translate("tile.compressor_electric.description");
            }
            case 8: {
                return GCCoreUtil.translate("tile.oxygen_storage_module.description");
            }
        }
        return "";
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta % 4));
        EnumMachineExtendedType type = EnumMachineExtendedType.byMetadata((int)Math.floor((double)meta / 4.0));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)TYPE, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((EnumMachineExtendedType)((Object)state.func_177229_b((IProperty)TYPE))).getMeta() * 4;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }

    public static enum EnumMachineExtendedType implements IStringSerializable
    {
        ELECTRIC_COMPRESSOR(0, "electric_compressor"),
        CIRCUIT_FABRICATOR(1, "circuit_fabricator"),
        OXYGEN_STORAGE(2, "oxygen_storage");

        private final int meta;
        private final String name;

        private EnumMachineExtendedType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumMachineExtendedType byMetadata(int meta) {
            return EnumMachineExtendedType.values()[meta];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

