/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class BlockFluidGC
extends BlockFluidClassic {
    private final String fluidName;
    private final Fluid fluid;

    public BlockFluidGC(Fluid fluid, String assetName) {
        super(fluid, assetName.startsWith("oil") || assetName.startsWith("fuel") ? GCFluids.materialOil : Material.field_151586_h);
        this.fluidName = assetName;
        this.fluid = fluid;
        if (assetName.startsWith("oil")) {
            this.field_149789_z = true;
        }
        this.func_149663_c(assetName);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K && this.fluidName.startsWith("oil") && playerIn instanceof EntityPlayerSP) {
            ClientProxyCore.playerClientHandler.onBuild(7, (EntityPlayerSP)playerIn);
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockPos below;
        IBlockState state;
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (this.fluidName.startsWith("oil") && rand.nextInt(1200) == 0) {
            worldIn.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187656_cX, SoundCategory.BLOCKS, rand.nextFloat() * 0.25f + 0.75f, 1.0E-5f + rand.nextFloat() * 0.5f);
        }
        if (this.fluidName.equals("oil") && rand.nextInt(10) == 0 && (state = worldIn.func_180495_p(below = pos.func_177977_b())).func_177230_c().isSideSolid(state, (IBlockAccess)worldIn, below, EnumFacing.UP) && !worldIn.func_180495_p(pos.func_177979_c(2)).func_177230_c().func_149688_o(worldIn.func_180495_p(pos)).func_76230_c()) {
            GalacticraftCore.proxy.spawnParticle("oilDrip", new Vector3((float)pos.func_177958_n() + rand.nextFloat(), (double)pos.func_177956_o() - 1.05, (float)pos.func_177952_p() + rand.nextFloat()), new Vector3(0.0, 0.0, 0.0), new Object[0]);
        }
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c().func_149688_o(world.func_180495_p(pos)).func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c().func_149688_o(world.func_180495_p(pos)).func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fluidName.startsWith("fuel")) {
            ((World)world).func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 6.0f, true);
            return true;
        }
        return this.fluidName.startsWith("oil");
    }
}

