/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.entity.IAntiGrav;
import micdoodle8.mods.galacticraft.api.entity.ICameraZoomEntity;
import micdoodle8.mods.galacticraft.api.item.IArmorGravity;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.client.FootprintRenderer;
import micdoodle8.mods.galacticraft.core.client.SkyProviderOverworld;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.player.EnumGravity;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class TransformerHooks {
    private static IWorldGenerator generatorGCGreg = null;
    private static IWorldGenerator generatorCoFH = null;
    private static IWorldGenerator generatorDenseOres = null;
    private static IWorldGenerator generatorTCAuraNodes = null;
    private static IWorldGenerator generatorAE2meteors = null;
    private static Method generateTCAuraNodes = null;
    private static boolean generatorsInitialised = false;

    public static double getGravityForEntity(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            if (entity instanceof EntityChicken && !OxygenUtil.isAABBInBreathableAirBlock(entity.field_70170_p, entity.func_174813_aQ())) {
                return 0.08;
            }
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)entity.field_70170_p.field_73011_w;
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (player.field_71071_by != null) {
                    int armorModLowGrav = 100;
                    int armorModHighGrav = 100;
                    for (ItemStack armorPiece : player.func_184193_aE()) {
                        if (armorPiece == null || !(armorPiece.func_77973_b() instanceof IArmorGravity)) continue;
                        armorModLowGrav -= ((IArmorGravity)armorPiece.func_77973_b()).gravityOverrideIfLow(player);
                        armorModHighGrav -= ((IArmorGravity)armorPiece.func_77973_b()).gravityOverrideIfHigh(player);
                    }
                    if (armorModLowGrav > 100) {
                        armorModLowGrav = 100;
                    }
                    if (armorModHighGrav > 100) {
                        armorModHighGrav = 100;
                    }
                    if (armorModLowGrav < 0) {
                        armorModLowGrav = 0;
                    }
                    if (armorModHighGrav < 0) {
                        armorModHighGrav = 0;
                    }
                    if (customProvider.getGravity() > 0.0f) {
                        return 0.08 - (double)(customProvider.getGravity() * (float)armorModLowGrav / 100.0f);
                    }
                    return 0.08 - (double)(customProvider.getGravity() * (float)armorModHighGrav / 100.0f);
                }
            }
            return 0.08 - (double)customProvider.getGravity();
        }
        if (entity instanceof IAntiGrav) {
            return 0.0;
        }
        return 0.08;
    }

    public static double getItemGravity(EntityItem e) {
        if (e.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)e.field_70170_p.field_73011_w;
            return Math.max(0.002, (double)0.04f - (customProvider instanceof IOrbitDimension ? 0.05999999910593033 : (double)customProvider.getGravity()) / 1.75);
        }
        return 0.04f;
    }

    public static float getArrowGravity(EntityArrow e) {
        if (e.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            return ((IGalacticraftWorldProvider)e.field_70170_p.field_73011_w).getArrowGravity();
        }
        return 0.05f;
    }

    public static float getRainStrength(World world, float partialTicks) {
        if (world.field_72995_K && world.field_73011_w.getSkyRenderer() instanceof SkyProviderOverworld) {
            return 0.0f;
        }
        return world.field_73003_n + (world.field_73004_o - world.field_73003_n) * partialTicks;
    }

    public static boolean otherModPreventGenerate(int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator) {
        IChunkProvider chunkProvider = world.func_72863_F();
        if (!(world.field_73011_w instanceof IGalacticraftWorldProvider)) {
            return false;
        }
        if (world.field_73011_w instanceof WorldProviderSpaceStation) {
            return true;
        }
        if (ConfigManagerCore.enableOtherModsFeatures) {
            return false;
        }
        if (!generatorsInitialised) {
            Set registeredGenerators;
            Field regField;
            block42: {
                block41: {
                    block40: {
                        block39: {
                            generatorsInitialised = true;
                            try {
                                Class<?> GCGreg = Class.forName("bloodasp.galacticgreg.GT_Worldgenerator_Space");
                                if (GCGreg == null) break block39;
                                regField = GameRegistry.class.getDeclaredField("worldGenerators");
                                regField.setAccessible(true);
                                registeredGenerators = (Set)regField.get(null);
                                for (IWorldGenerator gen : registeredGenerators) {
                                    if (!GCGreg.isInstance(gen)) continue;
                                    generatorGCGreg = gen;
                                    break;
                                }
                            }
                            catch (Exception GCGreg) {
                                // empty catch block
                            }
                        }
                        try {
                            Class<?> cofh = Class.forName("cofh.core.world.WorldHandler");
                            if (cofh == null || !ConfigManagerCore.whitelistCoFHCoreGen) break block40;
                            regField = GameRegistry.class.getDeclaredField("worldGenerators");
                            regField.setAccessible(true);
                            registeredGenerators = (Set)regField.get(null);
                            for (IWorldGenerator gen : registeredGenerators) {
                                if (!cofh.isInstance(gen)) continue;
                                generatorCoFH = gen;
                                break;
                            }
                        }
                        catch (Exception cofh) {
                            // empty catch block
                        }
                    }
                    try {
                        Class<?> denseOres = Class.forName("com.rwtema.denseores.WorldGenOres");
                        if (denseOres == null) break block41;
                        regField = GameRegistry.class.getDeclaredField("worldGenerators");
                        regField.setAccessible(true);
                        registeredGenerators = (Set)regField.get(null);
                        for (IWorldGenerator gen : registeredGenerators) {
                            if (!denseOres.isInstance(gen)) continue;
                            generatorDenseOres = gen;
                            break;
                        }
                    }
                    catch (Exception denseOres) {
                        // empty catch block
                    }
                }
                try {
                    Class<?> ae2meteorPlace = null;
                    try {
                        ae2meteorPlace = Class.forName("appeng.hooks.MeteoriteWorldGen");
                    }
                    catch (ClassNotFoundException regField2) {
                        // empty catch block
                    }
                    if (ae2meteorPlace == null) {
                        try {
                            ae2meteorPlace = Class.forName("appeng.worldgen.MeteoriteWorldGen");
                        }
                        catch (ClassNotFoundException regField2) {
                            // empty catch block
                        }
                    }
                    if (ae2meteorPlace == null) break block42;
                    regField = GameRegistry.class.getDeclaredField("worldGenerators");
                    regField.setAccessible(true);
                    registeredGenerators = (Set)regField.get(null);
                    for (IWorldGenerator gen : registeredGenerators) {
                        if (!ae2meteorPlace.isInstance(gen)) continue;
                        generatorAE2meteors = gen;
                        break;
                    }
                }
                catch (Exception ae2meteorPlace) {
                    // empty catch block
                }
            }
            try {
                Class<?> genThaumCraft = Class.forName("thaumcraft.common.lib.world.ThaumcraftWorldGenerator");
                if (genThaumCraft != null) {
                    regField = GameRegistry.class.getDeclaredField("worldGenerators");
                    regField.setAccessible(true);
                    registeredGenerators = (Set)regField.get(null);
                    for (IWorldGenerator gen : registeredGenerators) {
                        if (!genThaumCraft.isInstance(gen)) continue;
                        generatorTCAuraNodes = gen;
                        break;
                    }
                    if (generatorTCAuraNodes != null && ConfigManagerCore.enableThaumCraftNodes) {
                        generateTCAuraNodes = genThaumCraft.getDeclaredMethod("generateWildNodes", World.class, Random.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                        generateTCAuraNodes.setAccessible(true);
                    }
                }
            }
            catch (Exception genThaumCraft) {
                // empty catch block
            }
            if (generatorGCGreg != null) {
                GCLog.info("Whitelisting GalacticGreg oregen on planets.");
            }
            if (generatorCoFH != null) {
                GCLog.info("Whitelisting CoFHCore custom oregen on planets.");
            }
            if (generatorDenseOres != null) {
                GCLog.info("Whitelisting Dense Ores oregen on planets.");
            }
            if (generatorAE2meteors != null) {
                GCLog.info("Whitelisting AE2 meteorites worldgen on planets.");
            }
            if (generatorTCAuraNodes != null && generateTCAuraNodes != null) {
                GCLog.info("Whitelisting ThaumCraft aura node generation on planets.");
            }
        }
        if (generatorGCGreg != null || generatorCoFH != null || generatorDenseOres != null || generatorTCAuraNodes != null || generatorAE2meteors != null) {
            try {
                long worldSeed = world.func_72905_C();
                Random fmlRandom = new Random(worldSeed);
                long xSeed = fmlRandom.nextLong() >> 3;
                long zSeed = fmlRandom.nextLong() >> 3;
                long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
                fmlRandom.setSeed(chunkSeed);
                if (generatorCoFH != null) {
                    generatorCoFH.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                }
                if (generatorDenseOres != null) {
                    generatorDenseOres.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                }
                if (generatorGCGreg != null) {
                    generatorGCGreg.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                }
                if (generatorAE2meteors != null) {
                    generatorAE2meteors.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                }
                if (generateTCAuraNodes != null) {
                    generateTCAuraNodes.invoke((Object)generatorTCAuraNodes, world, fmlRandom, chunkX, chunkZ, false, true);
                }
            }
            catch (Exception e) {
                GCLog.severe("Error in another mod's worldgen.  This is NOT a Galacticraft bug.");
                e.printStackTrace();
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getWorldBrightness(WorldClient world) {
        if (world.field_73011_w instanceof WorldProviderMoon) {
            float f1 = world.func_72826_c(1.0f);
            float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * ((float)Math.PI * 2))) * 2.0f + 0.2f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            f2 = 1.0f - f2;
            return f2 * 0.8f;
        }
        return world.func_72971_b(1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static float getColorRed(World world) {
        return (float)WorldUtil.getWorldColor((World)world).x;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getColorGreen(World world) {
        return (float)WorldUtil.getWorldColor((World)world).y;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getColorBlue(World world) {
        return (float)WorldUtil.getWorldColor((World)world).z;
    }

    @SideOnly(value=Side.CLIENT)
    public static Vec3d getFogColorHook(World world) {
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (world.field_73011_w.getSkyRenderer() instanceof SkyProviderOverworld) {
            float var20 = ((float)player.field_70163_u - 200.0f) / 1000.0f;
            var20 = MathHelper.func_76129_c((float)var20);
            float var21 = Math.max(1.0f - var20 * 40.0f, 0.0f);
            Vec3d vec = world.func_72948_g(1.0f);
            return new Vec3d(vec.field_72450_a * (double)Math.max(1.0f - var20 * 1.29f, 0.0f), vec.field_72448_b * (double)Math.max(1.0f - var20 * 1.29f, 0.0f), vec.field_72449_c * (double)Math.max(1.0f - var20 * 1.29f, 0.0f));
        }
        return world.func_72948_g(1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static Vec3d getSkyColorHook(World world) {
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (world.field_73011_w.getSkyRenderer() instanceof SkyProviderOverworld || player != null && player.field_70163_u > 130.0 && player.func_184187_bx() instanceof EntitySpaceshipBase) {
            float f1 = world.func_72826_c(1.0f);
            float f2 = MathHelper.func_76134_b((float)(f1 * ((float)Math.PI * 2))) * 2.0f + 0.5f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            int i = MathHelper.func_76128_c((double)player.field_70165_t);
            int j = MathHelper.func_76128_c((double)player.field_70163_u);
            int k = MathHelper.func_76128_c((double)player.field_70161_v);
            BlockPos pos = new BlockPos(i, j, k);
            int l = ForgeHooksClient.getSkyBlendColour((World)world, (BlockPos)pos);
            float f4 = (float)(l >> 16 & 0xFF) / 255.0f;
            float f5 = (float)(l >> 8 & 0xFF) / 255.0f;
            float f6 = (float)(l & 0xFF) / 255.0f;
            f4 *= f2;
            f5 *= f2;
            f6 *= f2;
            if (player.field_70163_u <= 200.0) {
                Vec3d vec = world.func_72833_a(FMLClientHandler.instance().getClient().func_175606_aa(), 1.0f);
                double blend = (player.field_70163_u - 130.0) / 70.0;
                double ablend = 1.0 - blend;
                return new Vec3d((double)f4 * blend + vec.field_72450_a * ablend, (double)f5 * blend + vec.field_72448_b * ablend, (double)f6 * blend + vec.field_72449_c * ablend);
            }
            double blend = Math.min(1.0, (player.field_70163_u - 200.0) / 300.0);
            double ablend = 1.0 - blend;
            return new Vec3d((double)f4 * ablend + (blend /= 255.0) * 31.0, (double)f5 * ablend + blend * 8.0, (double)f6 * ablend + blend * 99.0);
        }
        return world.func_72833_a(FMLClientHandler.instance().getClient().func_175606_aa(), 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static double getRenderPosY(Entity viewEntity, double regular) {
        if (viewEntity.field_70163_u >= 256.0) {
            return 255.0;
        }
        return regular + (double)viewEntity.func_70047_e();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean shouldRenderFire(Entity entity) {
        if (entity.field_70170_p == null || !(entity.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider)) {
            return entity.func_70027_ad();
        }
        if (!(entity instanceof EntityLivingBase) && !(entity instanceof EntityArrow)) {
            return entity.func_70027_ad();
        }
        if (entity.func_70027_ad()) {
            if (OxygenUtil.noAtmosphericCombustion(entity.field_70170_p.field_73011_w)) {
                return OxygenUtil.isAABBInBreathableAirBlock(entity.field_70170_p, entity.func_174813_aQ());
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void orientCamera(float partialTicks) {
        Entity entity;
        float offset;
        EntityPlayerSP player = ClientProxyCore.mc.field_71439_g;
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)player);
        Entity viewEntity = ClientProxyCore.mc.func_175606_aa();
        if (player.func_184187_bx() instanceof ICameraZoomEntity && ClientProxyCore.mc.field_71474_y.field_74320_O == 0 && (offset = ((ICameraZoomEntity)(entity = player.func_184187_bx())).getRotateOffset()) > -10.0f) {
            GL11.glTranslatef((float)0.0f, (float)(-(offset += ClientProxyCore.PLAYER_Y_OFFSET)), (float)0.0f);
            float anglePitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
            float angleYaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks;
            GL11.glRotatef((float)(-anglePitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)angleYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)offset, (float)0.0f);
        }
        if (viewEntity instanceof EntityLivingBase && viewEntity.field_70170_p.field_73011_w instanceof IZeroGDimension && !((EntityLivingBase)viewEntity).func_70608_bn()) {
            float pitch = viewEntity.field_70127_C + (viewEntity.field_70125_A - viewEntity.field_70127_C) * partialTicks;
            float yaw = viewEntity.field_70126_B + (viewEntity.field_70177_z - viewEntity.field_70126_B) * partialTicks + 180.0f;
            float eyeHeightChange = viewEntity.field_70130_N / 2.0f;
            GL11.glRotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-pitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.1f);
            EnumGravity gDir = stats.getGdir();
            GL11.glRotatef((float)(180.0f * gDir.getThetaX()), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(180.0f * gDir.getThetaZ()), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(pitch * gDir.getPitchGravityX()), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(pitch * gDir.getPitchGravityY()), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(yaw * gDir.getYawGravityX()), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(yaw * gDir.getYawGravityY()), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(yaw * gDir.getYawGravityZ()), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(eyeHeightChange * gDir.getEyeVecX()), (float)(eyeHeightChange * gDir.getEyeVecY()), (float)(eyeHeightChange * gDir.getEyeVecZ()));
            if (stats.getGravityTurnRate() < 1.0f) {
                GL11.glRotatef((float)(90.0f * (stats.getGravityTurnRatePrev() + (stats.getGravityTurnRate() - stats.getGravityTurnRatePrev()) * partialTicks)), (float)stats.getGravityTurnVecX(), (float)stats.getGravityTurnVecY(), (float)stats.getGravityTurnVecZ());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderLiquidOverlays(float partialTicks) {
        boolean within = false;
        for (Map.Entry<Fluid, ResourceLocation> entry : ClientProxyCore.submergedTextures.entrySet()) {
            if (!FluidUtil.isInsideOfFluid((Entity)ClientProxyCore.mc.field_71439_g, entry.getKey())) continue;
            within = true;
            ClientProxyCore.mc.func_110434_K().func_110577_a(entry.getValue());
            break;
        }
        if (!within) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        float f1 = ClientProxyCore.mc.field_71439_g.func_70013_c(partialTicks) / 3.0f;
        GL11.glColor4f((float)f1, (float)f1, (float)f1, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        float f2 = 4.0f;
        float f3 = -1.1f;
        float f4 = 1.1f;
        float f5 = -1.1f;
        float f6 = 1.1f;
        float f7 = -0.25f;
        float f8 = -ClientProxyCore.mc.field_71439_g.field_70177_z / 64.0f;
        float f9 = ClientProxyCore.mc.field_71439_g.field_70125_A / 64.0f;
        VertexBuffer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)f3, (double)f5, (double)f7).func_187315_a((double)(f2 + f8), (double)(f2 + f9)).func_181675_d();
        worldRenderer.func_181662_b((double)f4, (double)f5, (double)f7).func_187315_a((double)(0.0f + f8), (double)(f2 + f9)).func_181675_d();
        worldRenderer.func_181662_b((double)f4, (double)f6, (double)f7).func_187315_a((double)(0.0f + f8), (double)(0.0f + f9)).func_181675_d();
        worldRenderer.func_181662_b((double)f3, (double)f6, (double)f7).func_187315_a((double)(f2 + f8), (double)(0.0f + f9)).func_181675_d();
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderFootprints(float partialTicks) {
        FootprintRenderer.renderFootprints((EntityPlayer)ClientProxyCore.mc.field_71439_g, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)new ClientProxyCore.EventSpecialRender(partialTicks));
    }

    @SideOnly(value=Side.CLIENT)
    public static double getCameraZoom(double previous) {
        if (ConfigManagerCore.disableVehicleCameraChanges) {
            return previous;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184187_bx() != null && player.func_184187_bx() instanceof ICameraZoomEntity) {
            return ((ICameraZoomEntity)player.func_184187_bx()).getCameraZoom();
        }
        return previous;
    }
}

