/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.world.gen;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.event.wgen.GCCoreEventPopulate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class BiomeDecoratorSpace {
    protected Random rand;
    protected int chunkX;
    protected int chunkZ;

    public void decorate(World world, Random random, int chunkX, int chunkZ) {
        if (this.getCurrentWorld() != null) {
            throw new RuntimeException("Already decorating!!");
        }
        this.setCurrentWorld(world);
        this.rand = random;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        BlockPos pos = new BlockPos(this.chunkX * 16, 0, this.chunkZ * 16);
        MinecraftForge.EVENT_BUS.post((Event)new GCCoreEventPopulate.Pre(world, this.rand, pos));
        this.decorate();
        MinecraftForge.EVENT_BUS.post((Event)new GCCoreEventPopulate.Post(world, this.rand, pos));
        this.setCurrentWorld(null);
        this.rand = null;
    }

    protected abstract void setCurrentWorld(World var1);

    protected abstract World getCurrentWorld();

    protected void generateOre(int amountPerChunk, WorldGenerator worldGenerator, int minY, int maxY) {
        World currentWorld = this.getCurrentWorld();
        for (int var5 = 0; var5 < amountPerChunk; ++var5) {
            int var6 = this.chunkX + this.rand.nextInt(16);
            int var7 = this.rand.nextInt(maxY - minY) + minY;
            int var8 = this.chunkZ + this.rand.nextInt(16);
            worldGenerator.func_180709_b(currentWorld, this.rand, new BlockPos(var6, var7, var8));
        }
    }

    protected abstract void decorate();
}

