/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base;

import java.util.Random;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.BaseConfiguration;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.BaseLinking;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.BaseStart;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.Piece;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;

public abstract class SizedPiece
extends Piece {
    protected EnumFacing direction;
    protected int sizeX;
    protected int sizeY;
    protected int sizeZ;

    public SizedPiece() {
    }

    public SizedPiece(BaseConfiguration configuration, int sizeX, int sizeY, int sizeZ, EnumFacing direction) {
        super(configuration);
        this.direction = direction;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public void setDirection(EnumFacing direction) {
        this.direction = direction;
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74768_a("dir", this.direction.ordinal());
        tagCompound.func_74768_a("sX", this.sizeX);
        tagCompound.func_74768_a("sY", this.sizeY);
        tagCompound.func_74768_a("sZ", this.sizeZ);
    }

    @Override
    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager manager) {
        super.func_143011_b(tagCompound, manager);
        this.sizeX = tagCompound.func_74762_e("sX");
        this.sizeY = tagCompound.func_74762_e("sY");
        this.sizeZ = tagCompound.func_74762_e("sZ");
        this.direction = tagCompound.func_74764_b("dir") ? EnumFacing.func_82600_a((int)tagCompound.func_74762_e("direction")) : EnumFacing.NORTH;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public int getSizeZ() {
        return this.sizeZ;
    }

    protected int func_74865_a(int x, int z) {
        if (this.func_186165_e() == null) {
            return x;
        }
        switch (this.func_186165_e()) {
            case NORTH: {
                return this.field_74887_e.field_78897_a + x;
            }
            case SOUTH: {
                return this.field_74887_e.field_78893_d - x;
            }
            case WEST: {
                return this.field_74887_e.field_78893_d - z;
            }
            case EAST: {
                return this.field_74887_e.field_78897_a + z;
            }
        }
        return x;
    }

    protected int func_74873_b(int x, int z) {
        if (this.func_186165_e() == null) {
            return z;
        }
        switch (this.func_186165_e()) {
            case NORTH: {
                return this.field_74887_e.field_78896_c + z;
            }
            case SOUTH: {
                return this.field_74887_e.field_78892_f - z;
            }
            case WEST: {
                return this.field_74887_e.field_78896_c + x;
            }
            case EAST: {
                return this.field_74887_e.field_78892_f - x;
            }
        }
        return z;
    }

    public Piece getDoorway(Random rand, BaseStart startPiece, int maxAttempts, boolean small) {
        int sizeZ;
        int sizeX;
        int blockZ;
        int blockX;
        EnumFacing randomDir;
        boolean valid;
        int attempts = maxAttempts;
        do {
            int randDir;
            randomDir = EnumFacing.func_176731_b((int)(((randDir = rand.nextInt(4)) == this.getDirection().func_176734_d().func_176736_b() ? randDir + 1 : randDir) % 4));
            StructureBoundingBox extension = this.getExtension(randomDir, 1, 3);
            blockX = extension.field_78897_a;
            blockZ = extension.field_78896_c;
            sizeX = extension.field_78893_d - extension.field_78897_a;
            sizeZ = extension.field_78892_f - extension.field_78896_c;
        } while (!(valid = true) && --attempts > 0);
        if (!valid) {
            return null;
        }
        return new BaseLinking(this.configuration, rand, blockX, this.field_74887_e.field_78895_b, blockZ, sizeX, 3, sizeZ, randomDir);
    }
}

