/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base;

import java.util.LinkedList;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.entities.EntityHangingSchematic;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCargoLoader;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCrafting;
import micdoodle8.mods.galacticraft.core.tile.TileEntityEnergyStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidTank;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.BaseConfiguration;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.BaseDeck;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.SizedPiece;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fluids.FluidStack;

public class BaseRoom
extends SizedPiece {
    private EnumRoomType type;
    private boolean nearEnd;
    private boolean farEnd;
    private int deckTier;
    private static final ItemStack TREASURE1 = new ItemStack(Items.field_151073_bk, 2, 0);
    private static final ItemStack TREASURE2 = new ItemStack(Items.field_151156_bN, 1, 0);

    public BaseRoom() {
    }

    public BaseRoom(BaseConfiguration configuration, Random rand, int blockPosX, int yPos, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing entranceDir, EnumRoomType roomType, boolean near, boolean far, int deckTier) {
        super(configuration, sizeX, sizeY, sizeZ, entranceDir.func_176734_d());
        this.func_186164_a(this.direction);
        this.type = roomType;
        this.nearEnd = near;
        this.farEnd = far;
        this.deckTier = deckTier;
        this.field_74887_e = new StructureBoundingBox(blockPosX, yPos, blockPosZ, blockPosX + this.sizeX, yPos + this.sizeY, blockPosZ + this.sizeZ);
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        int details = this.deckTier + (this.nearEnd ? 16 : 0) + (this.farEnd ? 32 : 0);
        tagCompound.func_74768_a("brT", this.type.ordinal());
        tagCompound.func_74768_a("brD", details);
    }

    @Override
    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager manager) {
        super.func_143011_b(tagCompound, manager);
        try {
            int typeNo = tagCompound.func_74762_e("brT");
            this.type = typeNo < EnumRoomType.values().length ? EnumRoomType.values()[typeNo] : EnumRoomType.EMPTY;
            int details = tagCompound.func_74762_e("brD");
            this.deckTier = details & 0xF;
            this.nearEnd = (details & 0x10) == 16;
            this.farEnd = (details & 0x20) == 32;
        }
        catch (Exception e) {
            System.err.println("Failed to read Abandoned Base configuration from NBT");
            System.err.println(tagCompound.toString());
        }
    }

    public boolean func_74875_a(World worldIn, Random random, StructureBoundingBox chunkBoundary) {
        IBlockState blockAir = Blocks.field_150350_a.func_176223_P();
        Block blockStair = GCBlocks.moonStoneStairs;
        boolean axisEW = this.getDirection().func_176740_k() == EnumFacing.Axis.X;
        int maxX = axisEW ? this.sizeZ : this.sizeX;
        int maxZ = axisEW ? this.sizeX : this.sizeZ;
        int randomInt = random.nextInt(99);
        for (int xx = 0; xx <= maxX; ++xx) {
            boolean near = this.nearEnd && xx == maxX;
            boolean far = this.farEnd && xx == 0;
            for (int yy = 0; yy <= this.sizeY; ++yy) {
                for (int zz = 0; zz <= maxZ; ++zz) {
                    boolean xEntrance;
                    if (xx == 0 || xx == maxX || yy == 0 || yy == this.sizeY || zz == maxZ) {
                        boolean bl = maxX > 6 ? xx > 2 && xx < maxX - 2 : (xEntrance = xx > 1 && xx < maxX - 1);
                        if (this.type.blockEntrance != null && yy == 0 && zz == 0 && xEntrance && this.configuration.getDeckType() != BaseDeck.EnumBaseType.TUNNELER) {
                            this.func_175811_a(worldIn, this.type.blockEntrance, xx, yy, zz, chunkBoundary);
                            this.func_175811_a(worldIn, this.configuration.getWallBlock(), xx, yy - 1, zz, chunkBoundary);
                            continue;
                        }
                        if (zz != maxZ && !near && !far || (yy != 0 || (this.deckTier & 1) != 1) && (yy != this.sizeY || (this.deckTier & 2) != 2) && (zz != maxZ || !near && !far) || zz == 0 && yy == 0) {
                            this.func_175811_a(worldIn, this.configuration.getWallBlock(), xx, yy, zz, chunkBoundary);
                            continue;
                        }
                        if (yy != this.sizeY || (this.deckTier & 2) != 2 || !this.configuration.isHangarDeck() || zz >= 3 || xx != 0 && xx != maxX) continue;
                        this.func_175811_a(worldIn, this.configuration.getWallBlock(), xx, yy, zz, chunkBoundary);
                        continue;
                    }
                    if (xx > 1 && xx < maxX - 1 && zz > 0 && zz < maxZ - 1 || yy > 1 && yy < this.sizeY - 1 || this.type.doEntryWallsToo) {
                        BlockPos blockpos = new BlockPos(this.func_74865_a(xx, zz), this.func_74862_a(yy), this.func_74873_b(xx, zz));
                        if (!chunkBoundary.func_175898_b((Vec3i)blockpos)) continue;
                        this.buildRoomContents(worldIn, xx, yy, zz, maxX - 1, maxZ - 1, blockpos, randomInt);
                        continue;
                    }
                    if (this.configuration.getDeckType() == BaseDeck.EnumBaseType.TUNNELER && (yy == 1 || yy == this.sizeY - 1)) {
                        int meta = 1;
                        if (xx == 1) {
                            meta = 3;
                        } else if (xx == maxX - 1) {
                            meta = 2;
                        } else if (zz == 0) {
                            meta = 0;
                        }
                        if (this.direction == EnumFacing.NORTH) {
                            meta ^= 3 ^ meta / 2;
                        } else if (this.direction == EnumFacing.SOUTH) {
                            meta ^= 2 + meta / 2;
                        } else if (this.direction == EnumFacing.EAST) {
                            meta ^= 1;
                        }
                        this.func_175811_a(worldIn, blockStair.func_176203_a(meta += yy == 1 ? 0 : 4), xx, yy, zz, chunkBoundary);
                        continue;
                    }
                    if (yy == 1 && this.type.blockFloor != null) {
                        boolean bl = maxX > 6 ? xx > 2 && xx < maxX - 2 : (xEntrance = xx > 1 && xx < maxX - 1);
                        if (zz == 0 && this.type.blockEntrance != null && xEntrance) {
                            this.func_175811_a(worldIn, blockAir, xx, yy, zz, chunkBoundary);
                            continue;
                        }
                        this.func_175811_a(worldIn, this.type.blockFloor, xx, yy, zz, chunkBoundary);
                        continue;
                    }
                    this.func_175811_a(worldIn, blockAir, xx, yy, zz, chunkBoundary);
                }
            }
        }
        return true;
    }

    private void buildRoomContents(World worldIn, int x, int y, int z, int maxX, int maxZ, BlockPos blockpos, int randomInt) {
        IBlockState state = Blocks.field_150350_a.func_176223_P();
        int semirand = ((blockpos.func_177956_o() * 379 + blockpos.func_177958_n()) * 373 + blockpos.func_177952_p()) * 7 & 0xF;
        int facing = 0;
        int facing1 = 0;
        int facing2 = 0;
        int facingLamp = 2;
        int facingScreen = 2;
        switch (this.direction) {
            case WEST: {
                facing1 = 3;
                facing2 = 2;
                facingLamp = 3;
                facingScreen = 5;
                break;
            }
            case EAST: {
                facing = 2;
                facing1 = 1;
                facing2 = 0;
                facingLamp = 2;
                facingScreen = 4;
                break;
            }
            case NORTH: {
                facing = 3;
                facing1 = 2;
                facing2 = 1;
                facingLamp = 5;
                facingScreen = 2;
                break;
            }
            case SOUTH: {
                facing = 1;
                facing1 = 0;
                facing2 = 3;
                facingLamp = 4;
                facingScreen = 3;
            }
        }
        int ox = maxX / 2 - 3;
        int xx = x - ox;
        block6 : switch (this.type) {
            case EMPTY: {
                if (!(z != 1 && z != maxZ - 1 || x != 2 && x != maxX - 1)) {
                    state = GCBlocks.wallGC.func_176203_a(2);
                    break;
                }
                if (y != 1 || semirand >= 2) break;
                state = AsteroidBlocks.spaceWart.func_176203_a(semirand);
                break;
            }
            case STORE: {
                if (maxX < 6 || y != 1 || maxZ < 5) break;
                if (xx >= 3 && xx <= 5 && z >= 2 && z <= 4) {
                    state = GCBlocks.landingPad.func_176223_P();
                    break;
                }
                if (xx != 2) break;
                switch (z) {
                    case 2: {
                        state = GCBlocks.cargoLoader.func_176203_a(facing);
                        break block6;
                    }
                    case 3: {
                        state = GCBlocks.aluminumWire.func_176203_a(1);
                        break block6;
                    }
                    case 4: {
                        state = GCBlocks.cargoLoader.func_176203_a(4 + (facing ^ 2));
                        break block6;
                    }
                }
                break;
            }
            case POWER: {
                facing = (facing + 1) % 4;
                switch (y) {
                    case 1: {
                        if (z == 3 && xx >= 4 && x <= maxX - 2) {
                            state = GCBlocks.sealableBlock.func_176203_a(14);
                            break;
                        }
                        if (xx < 3 || z <= 1 || z >= maxZ - 1 && z != 4) break;
                        state = this.configuration.getWallBlock();
                        break;
                    }
                    case 2: {
                        if (z == 2) {
                            if (xx == 3) {
                                state = GCBlocks.machineTiered.func_176203_a(0 + facing);
                                break;
                            }
                            if (xx > 3 && x < maxX - 2) {
                                state = GCBlocks.aluminumWire.func_176203_a(0);
                                break;
                            }
                            if (x == maxX - 2) {
                                state = GCBlocks.aluminumWire.func_176203_a(2);
                                break;
                            }
                            if (xx != 3 && x != maxX - 1) break;
                            state = AsteroidBlocks.blockMinerBase.func_176223_P();
                            break;
                        }
                        if (z == 3 && x == maxX - 2) {
                            state = GCBlocks.aluminumWire.func_176203_a(0);
                            break;
                        }
                        if (z != 4 || xx != 3 && x != maxX - 1) break;
                        state = AsteroidBlocks.blockMinerBase.func_176223_P();
                        break;
                    }
                    case 3: {
                        if (z == 2 && xx == 4) {
                            state = GCBlocks.aluminumWire.func_176203_a(0);
                            break;
                        }
                        if (z == 3 && x == maxX - 2) {
                            state = GCBlocks.machineTiered.func_176203_a(8 + (facing ^ 2));
                            break;
                        }
                        if (z == 3 && x == maxX - 1) {
                            state = GCBlocks.aluminumWire.func_176203_a(1);
                            break;
                        }
                        if (z == 3 && xx >= 4 && x < maxX - 2) {
                            state = GCBlocks.aluminumWire.func_176203_a(0);
                            break;
                        }
                        if (z != 2 && z != 4 || xx != 3 && x != maxX - 1) break;
                        state = AsteroidBlocks.blockMinerBase.func_176223_P();
                        break;
                    }
                    case 4: {
                        if (z == 3) {
                            if (x == maxX - 3) {
                                state = GCBlocks.machineTiered.func_176203_a(8 + facing);
                                break;
                            }
                            if (x != maxX - 1 && x != maxX - 2) break;
                            state = GCBlocks.aluminumWire.func_176203_a(1);
                            break;
                        }
                        if (z != 2 && z != 4 || xx < 3 || x >= maxX) break;
                        state = AsteroidBlocks.blockMinerBase.func_176223_P();
                    }
                }
                break;
            }
            case ENGINEERING: {
                int closerz;
                if (y != 1) break;
                int n = closerz = maxZ <= 5 ? 2 : 3;
                if ((z == maxZ - 2 && x == maxX / 2 + 1 || z == closerz && (x == 2 || x == maxX - 1) && maxX > 5) && maxZ > 3) {
                    state = GCBlocks.nasaWorkbench.func_176223_P();
                    break;
                }
                state = AsteroidBlocks.blockBasic.func_176203_a(6);
                break;
            }
            case MEDICAL: {
                int zTable = maxZ - 3;
                int zTank = maxZ - 1;
                int zLight = zTable;
                if (zTable <= 1) {
                    if (zTable < 0) break;
                    ++zTable;
                    ++zLight;
                    zTank = maxZ;
                }
                if (y == 1) {
                    if (z == zTable && x <= maxX - 1 && x >= maxX - 3) {
                        state = GCBlocks.crafting.func_176203_a(1);
                        break;
                    }
                    state = Blocks.field_180400_cw.func_176223_P();
                    break;
                }
                if (y == 2 || y == 3) {
                    if (y == 2 && z == zTable && x <= maxX - 1 && x >= maxX - 3) {
                        state = GCBlocks.landingPad.func_176223_P();
                        break;
                    }
                    if (z != zTank || (maxX - x) % 2 != 1) break;
                    state = GCBlocks.fluidTank.func_176223_P();
                    break;
                }
                if (y != 4 && y != 5 || z != zLight && z != zLight - 1) break;
                if (x == maxX) {
                    state = GCBlocks.concealedDetector.func_176203_a(8 + facing + (this.configuration.getDeckType() == BaseDeck.EnumBaseType.HUMANOID ? 0 : 4));
                    break;
                }
                if (x != maxX - 1) break;
                state = GCBlocks.brightLamp.func_176203_a(facingLamp);
                break;
            }
            case CREW: {
                if (y == 1) {
                    if (x == 2 || x == maxX - 1) {
                        if (z % 2 != 1) break;
                        state = GCBlocks.wallGC.func_176203_a(z == 1 ? 3 : 2);
                        break;
                    }
                    state = Blocks.field_150404_cg.func_176203_a(7);
                    break;
                }
                if (y != 2 || x != 2 && x != maxX - 1) break;
                if (z == 1) {
                    state = Blocks.field_150382_bo.func_176223_P();
                    break;
                }
                if (z <= 2 || z >= maxZ) break;
                state = GCBlocks.landingPad.func_176203_a(1);
                break;
            }
            case CONTROL: {
                if (y == 1) {
                    if (x == maxX / 2 + 1 && z == maxZ - 2) {
                        state = AsteroidBlocks.blockBasic.func_176203_a(6);
                        break;
                    }
                    state = GCBlocks.slabGCHalf.func_176203_a(6);
                    break;
                }
                if (y > 3) break;
                if ((x == 1 || x == maxX) && z != 0 && z != maxZ) {
                    state = GCBlocks.telemetry.func_176223_P();
                    break;
                }
                if ((x == 2 || x == maxX - 1) && z != 0 && z != maxZ) {
                    state = GCBlocks.screen.func_176203_a(x == 2 ? facingLamp : facingLamp ^ 1);
                    break;
                }
                if (z == maxZ && x > 2 && x < maxX - 1) {
                    state = GCBlocks.screen.func_176203_a(facingScreen);
                    break;
                }
                if (x != maxX / 2 + 1 || z != maxZ - 2 || y != 2) break;
                state = GCBlocks.landingPad.func_176203_a(1);
                break;
            }
            case CRYO: {
                boolean highEntrance;
                boolean xEntrance = maxX > 5 ? x > 2 && x < maxX - 1 : x > 1 && x < maxX;
                boolean bl = highEntrance = this.configuration.isHangarDeck() && this.configuration.getDeckType() == BaseDeck.EnumBaseType.AVIAN;
                if (y == 1) {
                    if (z == 1 && x > 1 && x < maxX) {
                        state = GCBlocks.slabGCHalf.func_176203_a(6);
                        break;
                    }
                    if (z == 0 && xEntrance && !highEntrance) break;
                    state = AsteroidBlocks.blockBasic.func_176203_a(6);
                    break;
                }
                if (!(z != 0 || y <= (highEntrance ? 5 : 3) && xEntrance)) {
                    state = AsteroidBlocks.blockBasic.func_176203_a(6);
                    break;
                }
                if (y <= 4 && (z == maxZ || x == 1 || x == maxX)) {
                    if (z == maxZ && x % 2 == 0 && x < maxX) {
                        if (y != 2) break;
                        state = MarsBlocks.machine.func_176203_a(4 + facing1);
                        break;
                    }
                    if (z < maxZ && z > 1 && (maxZ - z) % 2 == 0) {
                        if (y != 2) break;
                        state = MarsBlocks.machine.func_176203_a(4 + (x == 1 ? facing : facing2));
                        break;
                    }
                    state = AsteroidBlocks.blockBasic.func_176203_a(6);
                    break;
                }
                if (y <= 5 && y != this.configuration.getRoomHeight() && z != maxZ && x != 1 && x != maxX) break;
                state = AsteroidBlocks.blockBasic.func_176203_a(6);
                break;
            }
        }
        worldIn.func_180501_a(blockpos, state, 2);
        if (state.func_177230_c() instanceof ITileEntityProvider) {
            TileEntity tile = worldIn.func_175625_s(blockpos);
            if (tile instanceof IMultiBlock) {
                LinkedList positions = new LinkedList();
                ((IMultiBlock)tile).getPositions(blockpos, positions);
                for (BlockPos pos : positions) {
                    worldIn.func_180501_a(pos, GCBlocks.fakeBlock.func_176223_P().func_177226_a((IProperty)BlockMulti.MULTI_TYPE, (Comparable)((IMultiBlock)tile).getMultiType()), 2);
                }
            }
            if (tile instanceof TileEntityFluidTank) {
                ((TileEntityFluidTank)tile).fill(null, new FluidStack(MarsModule.sludge, 16000), true);
            } else if (tile instanceof TileEntityCargoLoader) {
                TileEntityCargoLoader loader = (TileEntityCargoLoader)tile;
                loader.locked = true;
                loader.addCargo(new ItemStack(Items.field_151170_bI, 64, 0), true);
                loader.addCargo(new ItemStack(Items.field_151170_bI, 64, 0), true);
                loader.addCargo(new ItemStack(Items.field_151170_bI, 64, 0), true);
                loader.addCargo(new ItemStack(Items.field_151170_bI, 64, 0), true);
                loader.addCargo(new ItemStack(Items.field_151078_bh, 64, 0), true);
                loader.addCargo(new ItemStack(GCItems.oilCanister, 1, 1001), true);
                loader.addCargo(new ItemStack(GCItems.oilCanister, 1, 1001), true);
                loader.addCargo(new ItemStack(GCItems.oilCanister, 1, 1001), true);
                loader.addCargo(new ItemStack(GCItems.oilCanister, 1, 1001), true);
                loader.addCargo(new ItemStack(GCItems.oilCanister, 1, 1001), true);
                loader.addCargo(new ItemStack(GCItems.oilCanister, 1, 1001), true);
                loader.addCargo(new ItemStack(GCItems.oilCanister, 1, 1001), true);
                loader.addCargo(TREASURE1.func_77946_l(), true);
                loader.addCargo(TREASURE2.func_77946_l(), true);
            } else if (tile instanceof TileEntityCrafting) {
                switch (semirand % 4) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        ((TileEntityCrafting)tile).craftMatrix.func_70299_a(1, new ItemStack(Items.field_151042_j));
                        ((TileEntityCrafting)tile).craftMatrix.func_70299_a(3, new ItemStack(Items.field_151042_j));
                        break;
                    }
                    case 2: {
                        int slot = semirand % 9;
                        ((TileEntityCrafting)tile).craftMatrix.func_70299_a(slot, new ItemStack(Items.field_151144_bL, 1, semirand % 13 < 6 ? 4 : 2));
                        break;
                    }
                    case 3: {
                        ((TileEntityCrafting)tile).craftMatrix.func_70299_a(0, new ItemStack(Items.field_151042_j));
                        ((TileEntityCrafting)tile).craftMatrix.func_70299_a(1, new ItemStack(Items.field_151042_j));
                        ((TileEntityCrafting)tile).craftMatrix.func_70299_a(3, new ItemStack(Items.field_151042_j));
                        ((TileEntityCrafting)tile).craftMatrix.func_70299_a(4, new ItemStack(Items.field_151055_y));
                        ((TileEntityCrafting)tile).craftMatrix.func_70299_a(7, new ItemStack(Items.field_151055_y));
                    }
                }
            } else if (tile instanceof TileEntityBrewingStand) {
                TileEntityBrewingStand stand = (TileEntityBrewingStand)tile;
                stand.func_70299_a(0, new ItemStack((Item)Items.field_151068_bn, 1, 8196));
                stand.func_70299_a(1, new ItemStack((Item)Items.field_151068_bn, 1, 8200));
                stand.func_70299_a(2, new ItemStack((Item)Items.field_151068_bn, 1, 8204));
            } else if (tile instanceof TileEntityEnergyStorageModule) {
                TileEntityEnergyStorageModule store = (TileEntityEnergyStorageModule)tile;
                if (semirand % 3 == 1) {
                    store.func_70299_a(1, new ItemStack(GCItems.battery, 1, 100));
                }
            }
        }
        if (this.type == EnumRoomType.ENGINEERING && y == (this.configuration.getRoomHeight() <= 4 ? 2 : 3) && z == maxZ && (x == 3 || x == 6)) {
            EntityHangingSchematic entityhanging;
            EnumFacing hangingDirection = this.direction;
            if (hangingDirection == EnumFacing.WEST || hangingDirection == EnumFacing.EAST) {
                hangingDirection = hangingDirection.func_176734_d();
            }
            if ((entityhanging = new EntityHangingSchematic(worldIn, blockpos, hangingDirection, x / 3 - 1)) != null) {
                worldIn.func_72838_d((Entity)entityhanging);
                entityhanging.setSendToClient();
            }
        }
    }

    public static enum EnumRoomType {
        ENGINEERING(AsteroidBlocks.blockBasic.func_176203_a(6), AsteroidBlocks.blockBasic.func_176203_a(6), false),
        POWER(null, null, false),
        STORE(null, null, false),
        EMPTY(null, null, false),
        MEDICAL(Blocks.field_180400_cw.func_176223_P(), Blocks.field_180400_cw.func_176203_a(8), false),
        CREW(null, null, false),
        CRYO(AsteroidBlocks.blockBasic.func_176203_a(6), AsteroidBlocks.blockBasic.func_176203_a(6), true),
        CONTROL(GCBlocks.slabGCHalf.func_176203_a(6), AsteroidBlocks.blockBasic.func_176203_a(6), false);

        public final IBlockState blockFloor;
        public final IBlockState blockEntrance;
        public final boolean doEntryWallsToo;

        private EnumRoomType(IBlockState floorBlock, IBlockState entrance, boolean doWalls) {
            this.blockFloor = floorBlock;
            this.blockEntrance = entrance;
            this.doEntryWallsToo = doWalls;
        }
    }
}

