/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.tile;

import java.util.LinkedList;
import micdoodle8.mods.galacticraft.api.power.ILaserNode;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;

public abstract class TileEntityBeamOutput
extends TileEntityAdvanced
implements ILaserNode {
    public LinkedList<ILaserNode> nodeList = new LinkedList();
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public BlockPos targetVec = new BlockPos(-1, -1, -1);
    public float pitch;
    public float yaw;
    private BlockPos preLoadTarget = null;
    private BlockPos lastTargetVec = new BlockPos(-1, -1, -1);

    public void func_73660_a() {
        TileEntity tileAtTarget;
        if (this.preLoadTarget != null && (tileAtTarget = this.field_145850_b.func_175625_s(this.preLoadTarget)) != null && tileAtTarget instanceof ILaserNode) {
            this.setTarget((ILaserNode)tileAtTarget);
            this.preLoadTarget = null;
        }
        super.func_73660_a();
        if (!this.targetVec.equals((Object)this.lastTargetVec)) {
            this.func_70296_d();
        }
        this.lastTargetVec = this.targetVec;
        if (this.field_145850_b.field_72995_K) {
            this.updateOrientation();
        } else if (this.targetVec.func_177958_n() == -1 && this.targetVec.func_177956_o() == -1 && this.targetVec.func_177952_p() == -1) {
            this.initiateReflector();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.invalidateReflector();
    }

    public void onLoad() {
    }

    public void onChunkUnload() {
        this.invalidateReflector();
    }

    public void invalidateReflector() {
        for (ILaserNode node : this.nodeList) {
            node.removeNode((ILaserNode)this);
        }
        this.nodeList.clear();
    }

    public void initiateReflector() {
        this.nodeList.clear();
        int chunkXMin = this.func_174877_v().func_177958_n() - 15 >> 4;
        int chunkZMin = this.func_174877_v().func_177952_p() - 15 >> 4;
        int chunkXMax = this.func_174877_v().func_177958_n() + 15 >> 4;
        int chunkZMax = this.func_174877_v().func_177952_p() + 15 >> 4;
        for (int cX = chunkXMin; cX <= chunkXMax; ++cX) {
            for (int cZ = chunkZMin; cZ <= chunkZMax; ++cZ) {
                if (this.field_145850_b.func_72863_F().func_186026_b(cX, cZ) == null) continue;
                Chunk chunk = this.field_145850_b.func_72964_e(cX, cZ);
                for (Object obj : chunk.func_177434_r().values()) {
                    ILaserNode laserNode;
                    if (obj == this || !(obj instanceof ILaserNode)) continue;
                    BlockVec3 deltaPos = new BlockVec3((TileEntity)this).subtract(new BlockVec3(((ILaserNode)obj).getTile()));
                    if (deltaPos.x >= 16 || deltaPos.y >= 16 || deltaPos.z >= 16 || !this.canConnectTo(laserNode = (ILaserNode)obj) || !laserNode.canConnectTo((ILaserNode)this)) continue;
                    this.addNode(laserNode);
                    laserNode.addNode((ILaserNode)this);
                }
            }
        }
        this.setTarget(this.nodeList.peekFirst());
    }

    public void addNode(ILaserNode node) {
        int index = -1;
        for (int i = 0; i < this.nodeList.size(); ++i) {
            if (!new BlockVec3(this.nodeList.get(i).getTile()).equals((Object)new BlockVec3(node.getTile()))) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.nodeList.set(index, node);
            return;
        }
        if (this.nodeList.isEmpty()) {
            this.nodeList.add(node);
        } else {
            int nodeCompare = this.nodeList.get(0).compareTo(node, new BlockVec3((TileEntity)this));
            if (nodeCompare <= 0) {
                this.nodeList.addFirst(node);
                return;
            }
            nodeCompare = this.nodeList.get(this.nodeList.size() - 1).compareTo(node, new BlockVec3((TileEntity)this));
            if (nodeCompare >= 0) {
                this.nodeList.addLast(node);
                return;
            }
            for (index = 1; index < this.nodeList.size(); ++index) {
            }
            this.nodeList.add(index, node);
        }
    }

    public void removeNode(ILaserNode node) {
        int index = -1;
        for (int i = 0; i < this.nodeList.size(); ++i) {
            if (!new BlockVec3(this.nodeList.get(i).getTile()).equals((Object)new BlockVec3(node.getTile()))) continue;
            index = i;
            break;
        }
        if (new BlockVec3(node.getTile()).equals((Object)new BlockVec3(this.targetVec))) {
            if (index == 0) {
                if (this.nodeList.size() > 1) {
                    this.setTarget(this.nodeList.get(index + 1));
                } else {
                    this.setTarget(null);
                }
            } else if (index > 0) {
                this.setTarget(this.nodeList.get(index - 1));
            } else {
                this.setTarget(null);
            }
        }
        if (index != -1) {
            this.nodeList.remove(index);
        }
    }

    public void updateOrientation() {
        if (this.getTarget() != null) {
            Vector3 direction = Vector3.subtract((Vector3)this.getOutputPoint(false), (Vector3)this.getTarget().getInputPoint()).normalize();
            this.pitch = (float)(-Vector3.getAngle((Vector3)new Vector3(-direction.x, -direction.y, -direction.z), (Vector3)new Vector3(0.0, 1.0, 0.0))) * 57.295776f + 90.0f;
            this.yaw = (float)(-(Math.atan2(direction.z, direction.x) * 57.2957763671875)) + 90.0f;
        }
    }

    public TileEntity getTile() {
        return this;
    }

    public int compareTo(ILaserNode otherNode, BlockVec3 origin) {
        int otherDistance;
        int thisDistance = new BlockVec3((TileEntity)this).subtract(origin).getMagnitudeSquared();
        if (thisDistance < (otherDistance = new BlockVec3(otherNode.getTile()).subtract(origin).getMagnitudeSquared())) {
            return 1;
        }
        if (thisDistance > otherDistance) {
            return -1;
        }
        return 0;
    }

    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.nodeList.size() > 1) {
            int index = -1;
            if (this.getTarget() != null) {
                for (int i = 0; i < this.nodeList.size(); ++i) {
                    if (!new BlockVec3(this.nodeList.get(i).getTile()).equals((Object)new BlockVec3(this.getTarget().getTile()))) continue;
                    index = i;
                    break;
                }
            }
            if (index == -1) {
                this.initiateReflector();
            } else {
                ++index;
                this.setTarget(this.nodeList.get(index %= this.nodeList.size()));
                return true;
            }
        }
        return false;
    }

    public ILaserNode getTarget() {
        if (this.targetVec.func_177958_n() != -1 || this.targetVec.func_177956_o() != -1 || this.targetVec.func_177952_p() != -1) {
            TileEntity tileAtTarget = this.field_145850_b.func_175625_s(this.targetVec);
            if (tileAtTarget != null && tileAtTarget instanceof ILaserNode) {
                return (ILaserNode)tileAtTarget;
            }
            return null;
        }
        return null;
    }

    public void setTarget(ILaserNode target) {
        this.targetVec = target != null ? target.getTile().func_174877_v() : new BlockPos(-1, -1, -1);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74767_n("HasTarget")) {
            this.preLoadTarget = new BlockPos(nbt.func_74762_e("TargetX"), nbt.func_74762_e("TargetY"), nbt.func_74762_e("TargetZ"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("HasTarget", this.getTarget() != null);
        if (this.getTarget() != null) {
            nbt.func_74768_a("TargetX", this.getTarget().getTile().func_174877_v().func_177958_n());
            nbt.func_74768_a("TargetY", this.getTarget().getTile().func_174877_v().func_177956_o());
            nbt.func_74768_a("TargetZ", this.getTarget().getTile().func_174877_v().func_177952_p());
        }
        return nbt;
    }
}

