/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.blocks;

import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTransmitter;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWire;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidPipe;
import micdoodle8.mods.galacticraft.core.tile.TileEntityNull;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWalkway
extends BlockTransmitter
implements ITileEntityProvider,
IShiftDescription,
ISortableBlock {
    public static final PropertyEnum WALKWAY_TYPE = PropertyEnum.func_177709_a((String)"type", EnumWalkwayType.class);
    protected static final AxisAlignedBB AABB_UNCONNECTED = new AxisAlignedBB(0.0, 0.32, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_CONNECTED_DOWN = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    protected BlockWalkway(String assetName) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149663_c(assetName);
        this.func_149672_a(SoundType.field_185852_e);
        this.field_149758_A = true;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)WALKWAY_TYPE, (Comparable)((Object)EnumWalkwayType.WALKWAY)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)(state = this.func_176221_a(state, source, pos)).func_177229_b((IProperty)DOWN)).booleanValue()) {
            return AABB_CONNECTED_DOWN;
        }
        return AABB_UNCONNECTED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return state.func_177230_c().func_149688_o(state).func_76230_c() && state.func_177230_c().func_149686_d(state);
    }

    public TileEntity func_149915_a(World worldIn, int metadata) {
        if (metadata == EnumWalkwayType.WALKWAY_PIPE.getMeta()) {
            return new TileEntityFluidPipe();
        }
        if (metadata == EnumWalkwayType.WALKWAY_WIRE.getMeta()) {
            return new TileEntityAluminumWire(2);
        }
        return new TileEntityNull();
    }

    public NetworkType getNetworkType(IBlockState state) {
        if (state.func_177229_b((IProperty)WALKWAY_TYPE) == EnumWalkwayType.WALKWAY_PIPE) {
            return NetworkType.FLUID;
        }
        if (state.func_177229_b((IProperty)WALKWAY_TYPE) == EnumWalkwayType.WALKWAY_PIPE) {
            return NetworkType.POWER;
        }
        return null;
    }

    public String getShiftDescription(int meta) {
        if (meta == EnumWalkwayType.WALKWAY.getMeta()) {
            return GCCoreUtil.translate((String)"tile.walkway.walkway.description");
        }
        if (meta == EnumWalkwayType.WALKWAY_WIRE.getMeta()) {
            return GCCoreUtil.translate((String)"tile.walkway.walkway_wire.description");
        }
        if (meta == EnumWalkwayType.WALKWAY_PIPE.getMeta()) {
            return GCCoreUtil.translate((String)"tile.walkway.walkway_pipe.description");
        }
        return "";
    }

    public boolean showDescription(int meta) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{WALKWAY_TYPE, NORTH, EAST, SOUTH, WEST, DOWN});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Object[] connectable = new Object[EnumFacing.values().length];
        TileEntity tileEntity = null;
        if (state.func_177229_b((IProperty)WALKWAY_TYPE) != EnumWalkwayType.WALKWAY) {
            tileEntity = worldIn.func_175625_s(pos);
        }
        for (EnumFacing direction : EnumFacing.values()) {
            if (direction == EnumFacing.UP || direction == EnumFacing.DOWN && tileEntity == null) continue;
            if (state.func_177229_b((IProperty)WALKWAY_TYPE) == EnumWalkwayType.WALKWAY) {
                BlockPos neighbour = pos.func_177972_a(direction);
                Block block = worldIn.func_180495_p(neighbour).func_177230_c();
                if (block != this && !block.isSideSolid(worldIn.func_180495_p(neighbour), worldIn, neighbour, direction.func_176734_d())) continue;
                connectable[direction.ordinal()] = block;
                continue;
            }
            if (tileEntity != null && state.func_177229_b((IProperty)WALKWAY_TYPE) == EnumWalkwayType.WALKWAY_PIPE) {
                connectable = OxygenUtil.getAdjacentFluidConnections((TileEntity)tileEntity);
                continue;
            }
            if (tileEntity == null || state.func_177229_b((IProperty)WALKWAY_TYPE) != EnumWalkwayType.WALKWAY_WIRE) continue;
            connectable = EnergyUtil.getAdjacentPowerConnections((TileEntity)tileEntity);
        }
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(connectable[EnumFacing.NORTH.ordinal()] != null)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(connectable[EnumFacing.EAST.ordinal()] != null)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(connectable[EnumFacing.SOUTH.ordinal()] != null)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(connectable[EnumFacing.WEST.ordinal()] != null)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(connectable[EnumFacing.DOWN.ordinal()] != null));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)WALKWAY_TYPE, (Comparable)((Object)EnumWalkwayType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumWalkwayType)((Object)state.func_177229_b((IProperty)WALKWAY_TYPE))).getMeta();
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack(itemIn, 1, 0));
        list.add((Object)new ItemStack(itemIn, 1, 1));
        list.add((Object)new ItemStack(itemIn, 1, 2));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.GENERAL;
    }

    public static enum EnumWalkwayType implements IStringSerializable
    {
        WALKWAY(0, "walkway"),
        WALKWAY_WIRE(1, "walkway_wire"),
        WALKWAY_PIPE(2, "walkway_pipe");

        private final int meta;
        private final String name;

        private EnumWalkwayType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumWalkwayType byMetadata(int meta) {
            return EnumWalkwayType.values()[meta];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

