/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevator.init;

import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.vsngamer.elevator.blocks.BlockElevator;

@Mod.EventBusSubscriber(modid="elevatorid")
public class Registry {
    public static EnumMap<EnumDyeColor, BlockElevator> elevatorsBlocks = new EnumMap(EnumDyeColor.class);
    public static EnumMap<EnumDyeColor, ItemBlock> elevatorsItems = new EnumMap(EnumDyeColor.class);

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            BlockElevator block = new BlockElevator();
            block.setRegistryName("elevatorid", "elevator_" + color.func_176610_l());
            block.func_149663_c("elevator_" + color.func_176610_l());
            e.getRegistry().register((IForgeRegistryEntry)block);
            elevatorsBlocks.put(color, block);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ItemBlock itemBlock = new ItemBlock((Block)elevatorsBlocks.get(color));
            itemBlock.setRegistryName("elevator_" + color.func_176610_l());
            e.getRegistry().register((IForgeRegistryEntry)itemBlock);
            elevatorsItems.put(color, itemBlock);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenders() {
        for (ItemBlock itemBlock : elevatorsItems.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)new ModelResourceLocation(itemBlock.getRegistryName(), "inventory"));
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent e) {
        Registry.registerRenders();
    }
}

