/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.vector;

import com.flansmod.common.vector.ReadableVector2f;
import com.flansmod.common.vector.Vector;
import com.flansmod.common.vector.WritableVector2f;
import java.io.Serializable;
import java.nio.FloatBuffer;

public class Vector2f
extends Vector
implements Serializable,
ReadableVector2f,
WritableVector2f {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;

    public Vector2f() {
    }

    public Vector2f(ReadableVector2f src) {
        this.set(src);
    }

    public Vector2f(float x, float y) {
        this.set(x, y);
    }

    @Override
    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2f set(ReadableVector2f src) {
        this.x = src.getX();
        this.y = src.getY();
        return this;
    }

    @Override
    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public Vector2f translate(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    @Override
    public Vector negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2f negate(Vector2f dest) {
        if (dest == null) {
            dest = new Vector2f();
        }
        dest.x = -this.x;
        dest.y = -this.y;
        return dest;
    }

    public Vector2f normalise(Vector2f dest) {
        float l = this.length();
        if (dest == null) {
            dest = new Vector2f(this.x / l, this.y / l);
        } else {
            dest.set(this.x / l, this.y / l);
        }
        return dest;
    }

    public static float dot(Vector2f left, Vector2f right) {
        return left.x * right.x + left.y * right.y;
    }

    public static float angle(Vector2f a, Vector2f b) {
        float dls = Vector2f.dot(a, b) / (a.length() * b.length());
        if (dls < -1.0f) {
            dls = -1.0f;
        } else if (dls > 1.0f) {
            dls = 1.0f;
        }
        return (float)Math.acos(dls);
    }

    public static Vector2f add(Vector2f left, Vector2f right, Vector2f dest) {
        if (dest == null) {
            return new Vector2f(left.x + right.x, left.y + right.y);
        }
        dest.set(left.x + right.x, left.y + right.y);
        return dest;
    }

    public static Vector2f sub(Vector2f left, Vector2f right, Vector2f dest) {
        if (dest == null) {
            return new Vector2f(left.x - right.x, left.y - right.y);
        }
        dest.set(left.x - right.x, left.y - right.y);
        return dest;
    }

    @Override
    public Vector store(FloatBuffer buf) {
        buf.put(this.x);
        buf.put(this.y);
        return this;
    }

    @Override
    public Vector load(FloatBuffer buf) {
        this.x = buf.get();
        this.y = buf.get();
        return this;
    }

    @Override
    public Vector scale(float scale) {
        this.x *= scale;
        this.y *= scale;
        return this;
    }

    public String toString() {
        return "Vector2f[" + this.x + ", " + this.y + ']';
    }

    @Override
    public final float getX() {
        return this.x;
    }

    @Override
    public final float getY() {
        return this.y;
    }

    @Override
    public final void setX(float x) {
        this.x = x;
    }

    @Override
    public final void setY(float y) {
        this.y = y;
    }
}

