/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.PlayerData;
import com.flansmod.common.teams.Gametype;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.teams.TeamsRound;
import com.flansmod.common.types.InfoType;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class GametypeZombies
extends Gametype {
    public boolean friendlyFire = false;
    public int humanPrepTime = 600;

    public GametypeZombies() {
        super("Zombies", "ZOM", 2);
    }

    @Override
    public void roundStart() {
    }

    @Override
    public void roundEnd() {
    }

    @Override
    public void roundCleanup() {
    }

    @Override
    public void tick() {
        if (GametypeZombies.teamsManager.roundTimeLeft + this.humanPrepTime - 200 == GametypeZombies.teamsManager.currentRound.timeLimit * 20 * 60) {
            TeamsManager.messageAll("\u00a7cThe \u00a74zombies \u00a7care upon us! 10 seconds to \u00a74infection\u00a7c!");
        }
        if (GametypeZombies.teamsManager.roundTimeLeft + this.humanPrepTime == GametypeZombies.teamsManager.currentRound.timeLimit * 20 * 60) {
            TeamsManager.messageAll("\u00a7cThe \u00a74zombie plague \u00a7cis here!");
            this.zombifySomeone();
        }
        if (GametypeZombies.teamsManager.roundTimeLeft + this.humanPrepTime < GametypeZombies.teamsManager.currentRound.timeLimit * 20 * 60 && GametypeZombies.teamsManager.roundTimeLeft % 200 == 0 && GametypeZombies.teamsManager.currentRound.teams[1].members.size() == 0) {
            this.zombifySomeone();
        }
    }

    public void zombifySomeone() {
        if (GametypeZombies.teamsManager.currentRound.teams[0].members.size() > 0) {
            EntityPlayerMP zombifiedPlayer = teamsManager.getPlayer(GametypeZombies.teamsManager.currentRound.teams[0].members.get(rand.nextInt(GametypeZombies.teamsManager.currentRound.teams[0].members.size())));
            TeamsManager.messageAll("\u00a74" + zombifiedPlayer.func_70005_c_() + "\u00a7c was infected with the \u00a74zombie plague\u00a7c!");
            zombifiedPlayer.func_70097_a(DamageSource.field_76377_j, 1.0E9f);
        }
    }

    @Override
    public Team[] getTeamsCanSpawnAs(TeamsRound currentRound, EntityPlayer player) {
        if (GametypeZombies.teamsManager.roundTimeLeft + this.humanPrepTime > GametypeZombies.teamsManager.currentRound.timeLimit * 20 * 60) {
            return new Team[]{currentRound.teams[0]};
        }
        return new Team[]{currentRound.teams[1]};
    }

    @Override
    public boolean playerAttacked(EntityPlayerMP player, DamageSource source) {
        if (GametypeZombies.getPlayerData(player) == null || GametypeZombies.getPlayerData((EntityPlayerMP)player).team == null) {
            return false;
        }
        EntityPlayerMP attacker = GametypeZombies.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GametypeZombies.getPlayerData(attacker) == null || GametypeZombies.getPlayerData((EntityPlayerMP)attacker).team == null) {
                return false;
            }
            if (GametypeZombies.getPlayerData((EntityPlayerMP)player).team == GametypeZombies.getPlayerData((EntityPlayerMP)attacker).team) {
                return this.friendlyFire;
            }
        }
        return GametypeZombies.getPlayerData((EntityPlayerMP)player).team != Team.spectators;
    }

    @Override
    public boolean playerCanAttack(EntityPlayerMP attacker, Team attackerTeam, EntityPlayerMP victim, Team victimTeam) {
        return attackerTeam != victimTeam || this.friendlyFire;
    }

    @Override
    public void playerKilled(EntityPlayerMP player, DamageSource source) {
        PlayerData playerData = GametypeZombies.getPlayerData(player);
        EntityPlayerMP attacker = GametypeZombies.getPlayerFromDamageSource(source);
        if (attacker != null) {
            PlayerData attackerData = GametypeZombies.getPlayerData(attacker);
            if (attacker != player) {
                if (attackerData.team == playerData.team) {
                    if (this.isHuman(attackerData.team)) {
                        ++attackerData.score;
                    } else {
                        --attackerData.zombieScore;
                    }
                } else {
                    if (this.isHuman(attackerData.team)) {
                        ++attackerData.score;
                    } else if (this.isZombie(attackerData.team)) {
                        ++attackerData.zombieScore;
                    }
                    ++attackerData.kills;
                }
            }
        }
        ++playerData.deaths;
        if (GametypeZombies.teamsManager.roundTimeLeft + this.humanPrepTime <= GametypeZombies.teamsManager.currentRound.timeLimit * 20 * 60) {
            if (playerData.team != null) {
                playerData.team.removePlayer((EntityPlayer)player);
            }
            playerData.team = playerData.newTeam = GametypeZombies.teamsManager.currentRound.teams[1];
            playerData.team.addPlayer((EntityPlayer)player);
            teamsManager.sendClassMenuToPlayer(player);
        }
    }

    @Override
    public boolean teamHasWon(Team team) {
        if (this.isHuman(team)) {
            return GametypeZombies.teamsManager.roundTimeLeft == 1 && team.members.size() > 0;
        }
        if (this.isZombie(team)) {
            return GametypeZombies.teamsManager.roundTimeLeft + this.humanPrepTime <= GametypeZombies.teamsManager.currentRound.timeLimit * 20 * 60 && GametypeZombies.teamsManager.currentRound.teams[0].members.size() == 0;
        }
        return false;
    }

    public boolean isHuman(Team team) {
        return team == GametypeZombies.teamsManager.currentRound.teams[0];
    }

    public boolean isZombie(Team team) {
        return team == GametypeZombies.teamsManager.currentRound.teams[1];
    }

    @Override
    public Vec3 getSpawnPoint(EntityPlayerMP player) {
        if (GametypeZombies.teamsManager.currentRound == null) {
            return null;
        }
        PlayerData data = GametypeZombies.getPlayerData(player);
        ArrayList<ITeamObject> validSpawnPoints = new ArrayList<ITeamObject>();
        if (data.newTeam == null) {
            return null;
        }
        if (data.newTeam == Team.spectators) {
            ArrayList<ITeamBase> bases = GametypeZombies.teamsManager.currentRound.map.getBasesPerTeam(1);
            for (ITeamBase base : bases) {
                if (base.getMap() != GametypeZombies.teamsManager.currentRound.map) continue;
                for (int i = 0; i < base.getObjects().size(); ++i) {
                    if (!base.getObjects().get(i).isSpawnPoint()) continue;
                    validSpawnPoints.add(base.getObjects().get(i));
                }
            }
        } else {
            for (int k = 2; k < 4; ++k) {
                ArrayList<ITeamBase> bases = GametypeZombies.teamsManager.currentRound.map.getBasesPerTeam(k);
                for (ITeamBase base : bases) {
                    if (base.getMap() != GametypeZombies.teamsManager.currentRound.map) continue;
                    for (int i = 0; i < base.getObjects().size(); ++i) {
                        if (!base.getObjects().get(i).isSpawnPoint()) continue;
                        validSpawnPoints.add(base.getObjects().get(i));
                    }
                }
            }
        }
        if (validSpawnPoints.size() > 0) {
            ITeamObject spawnPoint = (ITeamObject)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return new Vec3(spawnPoint.getPosX(), spawnPoint.getPosY(), spawnPoint.getPosZ());
        }
        return null;
    }

    @Override
    public boolean showZombieScore() {
        return true;
    }

    @Override
    public boolean playerCanLoot(ItemStack stack, InfoType infoType, EntityPlayer player, Team playerTeam) {
        return playerTeam != GametypeZombies.teamsManager.currentRound.teams[1];
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        this.humanPrepTime = tags.func_74762_e("ZOMPrepTime");
    }

    @Override
    public void saveToNBT(NBTTagCompound tags) {
        tags.func_74768_a("ZOMPrepTime", this.humanPrepTime);
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("humanpreptime")) {
            this.humanPrepTime = Integer.parseInt(value) * 20;
            return true;
        }
        return false;
    }
}

