/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.PlayerData;
import com.flansmod.common.teams.Gametype;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.Team;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class GametypeDM
extends Gametype {
    public int scoreLimit = 25;
    public int newRoundTimer = 0;
    public int time;

    public GametypeDM() {
        super("Free For All", "DM", 2);
    }

    @Override
    public void roundStart() {
    }

    @Override
    public void roundEnd() {
    }

    @Override
    public void roundCleanup() {
    }

    @Override
    public void tick() {
    }

    @Override
    public void playerQuit(EntityPlayerMP player) {
    }

    @Override
    public boolean playerAttacked(EntityPlayerMP player, DamageSource source) {
        if (GametypeDM.getPlayerData(player) == null || GametypeDM.getPlayerData((EntityPlayerMP)player).team == null) {
            return false;
        }
        EntityPlayerMP attacker = GametypeDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (GametypeDM.getPlayerData(attacker) == null || GametypeDM.getPlayerData((EntityPlayerMP)attacker).team == null) {
                return false;
            }
            if (GametypeDM.getPlayerData((EntityPlayerMP)attacker).team == Team.spectators) {
                return false;
            }
        }
        return GametypeDM.getPlayerData((EntityPlayerMP)player).team != Team.spectators;
    }

    @Override
    public void playerKilled(EntityPlayerMP player, DamageSource source) {
        EntityPlayerMP attacker = GametypeDM.getPlayerFromDamageSource(source);
        if (attacker != null) {
            if (attacker == player) {
                --GametypeDM.getPlayerData((EntityPlayerMP)player).score;
            } else {
                ++GametypeDM.getPlayerData((EntityPlayerMP)attacker).score;
                ++GametypeDM.getPlayerData((EntityPlayerMP)attacker).kills;
            }
        } else {
            --GametypeDM.getPlayerData((EntityPlayerMP)player).score;
        }
        ++GametypeDM.getPlayerData((EntityPlayerMP)player).deaths;
    }

    @Override
    public void baseAttacked(ITeamBase base, DamageSource source) {
    }

    @Override
    public void objectAttacked(ITeamObject object, DamageSource source) {
    }

    @Override
    public void baseClickedByPlayer(ITeamBase base, EntityPlayerMP player) {
    }

    @Override
    public void objectClickedByPlayer(ITeamObject object, EntityPlayerMP player) {
    }

    @Override
    public Vec3 getSpawnPoint(EntityPlayerMP player) {
        if (GametypeDM.teamsManager.currentRound == null) {
            return null;
        }
        PlayerData data = GametypeDM.getPlayerData(player);
        ArrayList<ITeamObject> validSpawnPoints = new ArrayList<ITeamObject>();
        if (data.newTeam == null) {
            return null;
        }
        if (data.newTeam == Team.spectators) {
            ArrayList<ITeamBase> bases = GametypeDM.teamsManager.currentRound.map.getBasesPerTeam(GametypeDM.teamsManager.currentRound.getTeamID(data.newTeam));
            for (ITeamBase base : bases) {
                if (base.getMap() != GametypeDM.teamsManager.currentRound.map) continue;
                for (int i = 0; i < base.getObjects().size(); ++i) {
                    if (!base.getObjects().get(i).isSpawnPoint()) continue;
                    validSpawnPoints.add(base.getObjects().get(i));
                }
            }
        } else {
            for (int k = 2; k < 4; ++k) {
                ArrayList<ITeamBase> bases = GametypeDM.teamsManager.currentRound.map.getBasesPerTeam(k);
                for (ITeamBase base : bases) {
                    if (base.getMap() != GametypeDM.teamsManager.currentRound.map) continue;
                    for (int i = 0; i < base.getObjects().size(); ++i) {
                        if (!base.getObjects().get(i).isSpawnPoint()) continue;
                        validSpawnPoints.add(base.getObjects().get(i));
                    }
                }
            }
        }
        if (validSpawnPoints.size() > 0) {
            ITeamObject spawnPoint = (ITeamObject)validSpawnPoints.get(rand.nextInt(validSpawnPoints.size()));
            return new Vec3(spawnPoint.getPosX(), spawnPoint.getPosY(), spawnPoint.getPosZ());
        }
        return null;
    }

    @Override
    public void playerRespawned(EntityPlayerMP player) {
    }

    @Override
    public boolean setVariable(String variable, String value) {
        if (variable.toLowerCase().equals("scorelimit")) {
            this.scoreLimit = Integer.parseInt(value);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        this.scoreLimit = tags.func_74762_e("DMScoreLimit");
    }

    @Override
    public void saveToNBT(NBTTagCompound tags) {
        tags.func_74768_a("DMScoreLimit", this.scoreLimit);
    }

    @Override
    public boolean sortScoreboardByTeam() {
        return false;
    }

    @Override
    public boolean shouldAutobalance() {
        return false;
    }

    @Override
    public boolean teamHasWon(Team team) {
        return false;
    }
}

