/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.boxes.GunBoxType;
import com.flansmod.common.network.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketBuyWeapon
extends PacketBase {
    public String boxShortName;
    public int purchaseType;
    public int weaponID;

    public PacketBuyWeapon() {
    }

    public PacketBuyWeapon(GunBoxType box, int type, int wepID) {
        this.boxShortName = box.shortName;
        this.purchaseType = type;
        this.weaponID = wepID;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.writeUTF(data, this.boxShortName);
        data.writeInt(this.purchaseType);
        data.writeInt(this.weaponID);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.boxShortName = this.readUTF(data);
        this.purchaseType = data.readInt();
        this.weaponID = data.readInt();
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        GunBoxType box = GunBoxType.getBox(this.boxShortName);
        box.block.purchaseItem(this.purchaseType, this.weaponID, playerEntity.field_71071_by, box);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        FlansMod.log("Received gun box purchase packet on client. Skipping.");
    }
}

