/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns.boxes;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.boxes.GunBoxType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockGunBox
extends Block {
    public GunBoxType type;

    public BlockGunBox(GunBoxType t) {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(4.0f);
        this.type = t;
        this.func_149663_c(this.type.shortName);
        GameRegistry.registerBlock((Block)this, (String)this.type.shortName);
        this.func_149647_a(FlansMod.tabFlanGuns);
        this.type.block = this;
        this.type.item = Item.func_150898_a((Block)this);
    }

    public void buyGun(int i, InventoryPlayer inventory, GunBoxType type) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            FlansMod.proxy.buyGun(type, i);
        }
        if (i <= type.numGuns && type.guns[i] != null) {
            ItemStack stack;
            int j;
            boolean canBuy = true;
            for (ItemStack check : type.gunParts[i]) {
                int numMatchingStuff = 0;
                for (j = 0; j < inventory.func_70302_i_(); ++j) {
                    stack = inventory.func_70301_a(j);
                    if (stack == null || stack.func_77973_b() != check.func_77973_b() || stack.func_77952_i() != check.func_77952_i()) continue;
                    numMatchingStuff += stack.field_77994_a;
                }
                if (numMatchingStuff >= check.field_77994_a) continue;
                canBuy = false;
            }
            if (canBuy) {
                for (ItemStack remove : type.gunParts[i]) {
                    int amountLeft = remove.field_77994_a;
                    for (j = 0; j < inventory.func_70302_i_(); ++j) {
                        stack = inventory.func_70301_a(j);
                        if (amountLeft <= 0 || stack == null || stack.func_77973_b() != remove.func_77973_b() || stack.func_77952_i() != remove.func_77952_i()) continue;
                        amountLeft -= inventory.func_70298_a((int)j, (int)amountLeft).field_77994_a;
                    }
                }
                ItemStack gunStack = new ItemStack(type.guns[i].getItem());
                if (type.guns[i] instanceof GunType) {
                    GunType gunType = (GunType)type.guns[i];
                    NBTTagCompound tags = new NBTTagCompound();
                    tags.func_74778_a("Paint", gunType.defaultPaintjob.iconName);
                    NBTTagList ammoTagsList = new NBTTagList();
                    for (int j2 = 0; j2 < gunType.numAmmoItemsInGun; ++j2) {
                        ammoTagsList.func_74742_a((NBTBase)new NBTTagCompound());
                    }
                    tags.func_74782_a("ammo", (NBTBase)ammoTagsList);
                    gunStack.func_77982_d(tags);
                }
                if (!inventory.func_70441_a(gunStack)) {
                    inventory.field_70458_d.func_71019_a(gunStack, false);
                }
            }
        }
    }

    public void buyAmmo(int i, InventoryPlayer inventory, GunBoxType type) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            FlansMod.proxy.buyAmmo(type, i, 1);
        }
        if (i <= type.numGuns && type.bulletParts[i] != null) {
            ItemStack stack;
            int j;
            boolean canBuy = true;
            for (ItemStack check : type.bulletParts[i]) {
                int numMatchingStuff = 0;
                for (j = 0; j < inventory.func_70302_i_(); ++j) {
                    stack = inventory.func_70301_a(j);
                    if (stack == null || stack.func_77973_b() != check.func_77973_b() || stack.func_77952_i() != check.func_77952_i()) continue;
                    numMatchingStuff += stack.field_77994_a;
                }
                if (numMatchingStuff >= check.field_77994_a) continue;
                canBuy = false;
            }
            if (canBuy) {
                for (ItemStack remove : type.bulletParts[i]) {
                    int amountLeft = remove.field_77994_a;
                    for (j = 0; j < inventory.func_70302_i_(); ++j) {
                        stack = inventory.func_70301_a(j);
                        if (amountLeft <= 0 || stack == null || stack.func_77973_b() != remove.func_77973_b() || stack.func_77952_i() != remove.func_77952_i()) continue;
                        amountLeft -= inventory.func_70298_a((int)j, (int)amountLeft).field_77994_a;
                    }
                }
                if (!inventory.func_70441_a(new ItemStack(type.bullets[i].getItem()))) {
                    // empty if block
                }
            }
        }
    }

    public void buyAltAmmo(int i, InventoryPlayer inventory, GunBoxType type) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            FlansMod.proxy.buyAmmo(type, i, 2);
        }
        if (i <= type.numGuns && type.altBulletParts[i] != null) {
            ItemStack stack;
            int j;
            boolean canBuy = true;
            for (ItemStack check : type.altBulletParts[i]) {
                int numMatchingStuff = 0;
                for (j = 0; j < inventory.func_70302_i_(); ++j) {
                    stack = inventory.func_70301_a(j);
                    if (stack == null || stack.func_77973_b() != check.func_77973_b() || stack.func_77952_i() != check.func_77952_i()) continue;
                    numMatchingStuff += stack.field_77994_a;
                }
                if (numMatchingStuff >= check.field_77994_a) continue;
                canBuy = false;
            }
            if (canBuy) {
                for (ItemStack remove : type.altBulletParts[i]) {
                    int amountLeft = remove.field_77994_a;
                    for (j = 0; j < inventory.func_70302_i_(); ++j) {
                        stack = inventory.func_70301_a(j);
                        if (amountLeft <= 0 || stack == null || stack.func_77973_b() != remove.func_77973_b() || stack.func_77952_i() != remove.func_77952_i()) continue;
                        amountLeft -= inventory.func_70298_a((int)j, (int)amountLeft).field_77994_a;
                    }
                }
                if (!inventory.func_70441_a(new ItemStack(type.altBullets[i].getItem()))) {
                    // empty if block
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float par7, float par8, float par9) {
        if (player.func_70093_af()) {
            return false;
        }
        player.openGui((Object)FlansMod.INSTANCE, 5, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public Block purchaseItem(int i, int id, InventoryPlayer inventory, GunBoxType type) {
        switch (i) {
            case 0: {
                this.buyGun(id, inventory, type);
                break;
            }
            case 1: {
                this.buyAmmo(id, inventory, type);
                break;
            }
            case 2: {
                this.buyAltAmmo(id, inventory, type);
            }
        }
        return this;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, 0));
        return ret;
    }
}

