/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.client.model.ModelVehicle;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class VehicleType
extends DriveableType {
    public float turnLeftModifier = 1.0f;
    public float turnRightModifier = 1.0f;
    public boolean squashMobs = false;
    public boolean fourWheelDrive = false;
    public boolean rotateWheels = false;
    public boolean tank = false;
    public int vehicleShootDelay;
    public int vehicleShellDelay;
    public boolean hasDoor = false;
    public static ArrayList<VehicleType> types = new ArrayList();

    public VehicleType(TypeFile file) {
        super(file);
        types.add(this);
    }

    @Override
    public void preRead(TypeFile file) {
        super.preRead(file);
        this.wheelPositions = new DriveablePosition[4];
    }

    @Override
    protected void postRead(TypeFile file) {
        super.postRead(file);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (split[0].equals("TurnLeftSpeed")) {
                this.turnLeftModifier = Float.parseFloat(split[1]);
            }
            if (split[0].equals("TurnRightSpeed")) {
                this.turnRightModifier = Float.parseFloat(split[1]);
            }
            if (split[0].equals("SquashMobs")) {
                this.squashMobs = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("FourWheelDrive")) {
                this.fourWheelDrive = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("Tank") || split[0].equals("TankMode")) {
                this.tank = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("HasDoor")) {
                this.hasDoor = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("RotateWheels")) {
                this.rotateWheels = Boolean.parseBoolean(split[1].toLowerCase());
            }
            if (split[0].equals("ShootDelay")) {
                this.vehicleShootDelay = Integer.parseInt(split[1]);
            }
            if (split[0].equals("ShellDelay")) {
                this.vehicleShellDelay = Integer.parseInt(split[1]);
            }
            if (split[0].equals("ShootSound")) {
                this.shootSoundPrimary = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
            }
            if (split[0].equals("ShellSound")) {
                this.shootSoundSecondary = split[1];
                FlansMod.proxy.loadSound(this.contentPack, "driveables", split[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public ArrayList<ItemStack> getItemsRequired(DriveablePart part, PartType engine) {
        ArrayList<ItemStack> stacks = super.getItemsRequired(part, engine);
        if (EnumDriveablePart.core == part.type) {
            stacks.add(new ItemStack(engine.item));
        }
        return stacks;
    }

    public static VehicleType getVehicle(String find) {
        for (VehicleType type : types) {
            if (!type.shortName.equals(find)) continue;
            return type;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelVehicle.class);
    }

    @Override
    public EntityDriveable createDriveable(World world, double x, double y, double z, DriveableData data) {
        return new EntityVehicle(world, x, y, z, this, data);
    }
}

