/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.CollisionBox;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.VehicleType;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.types.EnumType;
import com.flansmod.common.types.IFlanItem;
import com.flansmod.common.types.InfoType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMapBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemVehicle
extends ItemMapBase
implements IFlanItem {
    public VehicleType type;

    public ItemVehicle(VehicleType type1) {
        this.field_77777_bU = 1;
        this.type = type1;
        this.type.item = this;
        this.func_77637_a(FlansMod.tabFlanDriveables);
        GameRegistry.registerItem((Item)this, (String)this.type.shortName, (String)"flansmod");
    }

    public boolean func_77651_p() {
        return true;
    }

    private NBTTagCompound getTagCompound(ItemStack stack, World world) {
        if (stack.func_77978_p() == null) {
            if (!world.field_72995_K && stack.func_77952_i() != 0) {
                stack.func_77982_d(this.getOldTagCompound(stack, world));
            }
            if (stack.func_77978_p() == null) {
                NBTTagCompound tags = new NBTTagCompound();
                stack.func_77982_d(tags);
                tags.func_74778_a("Type", this.type.shortName);
                tags.func_74778_a("Engine", PartType.defaultEngines.get((Object)((Object)EnumType.vehicle)).shortName);
            }
        }
        return stack.func_77978_p();
    }

    private NBTTagCompound getOldTagCompound(ItemStack stack, World world) {
        try {
            File file1 = world.func_72860_G().func_75758_b("vehicle_" + stack.func_77952_i());
            FileInputStream fileinputstream = new FileInputStream(file1);
            NBTTagCompound tags = CompressedStreamTools.func_74796_a((InputStream)fileinputstream).func_74775_l("data");
            for (EnumDriveablePart part : EnumDriveablePart.values()) {
                tags.func_74768_a(part.getShortName() + "_Health", this.type.health.get((Object)part) == null ? 0 : ((CollisionBox)this.type.health.get((Object)((Object)part))).health);
                tags.func_74757_a(part.getShortName() + "_Fire", false);
            }
            fileinputstream.close();
            return tags;
        }
        catch (IOException e) {
            FlansMod.log("Failed to read old vehicle file");
            e.printStackTrace();
            return null;
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lines, boolean advancedTooltips) {
        NBTTagCompound tags;
        String engineName;
        PartType part;
        if (this.type.description != null) {
            Collections.addAll(lines, this.type.description.split("_"));
        }
        if ((part = PartType.getPart(engineName = (tags = this.getTagCompound(stack, player.field_70170_p)).func_74779_i("Engine"))) != null) {
            lines.add(part.name);
        }
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        Vec3 lookVec;
        float cosYaw = MathHelper.func_76134_b((float)(-entityplayer.field_70177_z * 0.01745329f - 3.141593f));
        float sinYaw = MathHelper.func_76126_a((float)(-entityplayer.field_70177_z * 0.01745329f - 3.141593f));
        float cosPitch = -MathHelper.func_76134_b((float)(-entityplayer.field_70125_A * 0.01745329f));
        float sinPitch = MathHelper.func_76126_a((float)(-entityplayer.field_70125_A * 0.01745329f));
        double length = 5.0;
        Vec3 posVec = new Vec3(entityplayer.field_70165_t, entityplayer.field_70163_u + 1.62 - entityplayer.func_70033_W(), entityplayer.field_70161_v);
        MovingObjectPosition movingobjectposition = world.func_72901_a(posVec, lookVec = posVec.func_72441_c((double)(sinYaw * cosPitch) * length, (double)sinPitch * length, (double)(cosYaw * cosPitch) * length), this.type.placeableOnWater);
        if (movingobjectposition == null) {
            return itemstack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            BlockPos pos = movingobjectposition.func_178782_a();
            Block block = world.func_180495_p(pos).func_177230_c();
            if (this.type.placeableOnLand || block instanceof BlockLiquid) {
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityVehicle(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.5, (double)pos.func_177952_p() + 0.5, entityplayer, this.type, this.getData(itemstack, world)));
                }
                if (!entityplayer.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
            }
        }
        return itemstack;
    }

    public Entity spawnVehicle(World world, double x, double y, double z, ItemStack stack) {
        EntityVehicle entity = new EntityVehicle(world, x, y, z, this.type, this.getData(stack, world));
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)entity);
        }
        return entity;
    }

    public DriveableData getData(ItemStack itemstack, World world) {
        return new DriveableData(this.getTagCompound(itemstack, world));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        return this.type.colour;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        ItemStack planeStack = new ItemStack(item, 1, 0);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("Type", this.type.shortName);
        if (PartType.defaultEngines.containsKey((Object)EnumType.vehicle)) {
            tags.func_74778_a("Engine", PartType.defaultEngines.get((Object)((Object)EnumType.vehicle)).shortName);
        }
        for (EnumDriveablePart part : EnumDriveablePart.values()) {
            tags.func_74768_a(part.getShortName() + "_Health", this.type.health.get((Object)part) == null ? 0 : ((CollisionBox)this.type.health.get((Object)((Object)part))).health);
            tags.func_74757_a(part.getShortName() + "_Fire", false);
        }
        planeStack.func_77982_d(tags);
        list.add(planeStack);
    }

    @Override
    public InfoType getInfoType() {
        return this.type;
    }
}

