/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWheel
extends Entity
implements IEntityAdditionalSpawnData {
    public EntityDriveable vehicle;
    public int ID;
    @SideOnly(value=Side.CLIENT)
    public boolean foundVehicle;
    private int vehicleID;

    public EntityWheel(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70138_W = 1.0f;
    }

    public EntityWheel(World world, EntityDriveable entity, int i) {
        this(world);
        this.vehicle = entity;
        this.vehicleID = entity.func_145782_y();
        this.ID = i;
        this.initPosition();
    }

    public void initPosition() {
        Vector3f wheelVector = this.vehicle.axes.findLocalVectorGlobally(this.vehicle.getDriveableType().wheelPositions[this.ID].position);
        this.func_70107_b(this.vehicle.field_70165_t + (double)wheelVector.x, this.vehicle.field_70163_u + (double)wheelVector.y, this.vehicle.field_70161_v + (double)wheelVector.z);
        this.field_70138_W = this.vehicle.getDriveableType().wheelStepHeight;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public void func_180430_e(float k, float l) {
        if (this.vehicle == null || k <= 0.0f) {
            return;
        }
        int i = MathHelper.func_76123_f((float)(k - 3.0f));
        if (i > 0) {
            this.vehicle.attackPart(this.vehicle.getDriveableType().wheelPositions[this.ID].part, DamageSource.field_76379_h, i);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tags) {
        this.func_70106_y();
    }

    protected void func_70014_b(NBTTagCompound tags) {
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && !this.foundVehicle) {
            if (!(this.field_70170_p.func_73045_a(this.vehicleID) instanceof EntityDriveable)) {
                return;
            }
            this.vehicle = (EntityDriveable)this.field_70170_p.func_73045_a(this.vehicleID);
            this.foundVehicle = true;
            this.vehicle.wheels[this.ID] = this;
        }
        if (this.vehicle == null) {
            return;
        }
        if (!this.field_70175_ag) {
            this.field_70170_p.func_72838_d((Entity)this);
        }
    }

    public double getSpeedXZ() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
    }

    public void func_180426_a(double d, double d1, double d2, float f, float f1, int i, boolean b) {
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.vehicleID);
        data.writeInt(this.ID);
    }

    public void readSpawnData(ByteBuf data) {
        this.vehicleID = data.readInt();
        this.ID = data.readInt();
        if (this.field_70170_p.func_73045_a(this.vehicleID) instanceof EntityDriveable) {
            this.vehicle = (EntityDriveable)this.field_70170_p.func_73045_a(this.vehicleID);
        }
        if (this.vehicle != null) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }
}

