/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.api.IExplodeable;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityWheel;
import com.flansmod.common.driveables.VehicleType;
import com.flansmod.common.network.PacketDriveableKey;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.network.PacketVehicleControl;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.tools.ItemTool;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityVehicle
extends EntityDriveable
implements IExplodeable {
    public int shellDelay;
    public int gunDelay;
    public int soundPosition;
    public float wheelsYaw;
    private int ticksSinceUsed = 0;
    public boolean varDoor;
    public float wheelsAngle;
    public int toggleTimer = 0;

    public EntityVehicle(World world) {
        super(world);
        this.field_70138_W = 1.0f;
    }

    public EntityVehicle(World world, double x, double y, double z, VehicleType type, DriveableData data) {
        super(world, type, data);
        this.field_70138_W = 1.0f;
        this.func_70107_b(x, y, z);
        this.initType(type, false);
    }

    public EntityVehicle(World world, double x, double y, double z, EntityPlayer placer, VehicleType type, DriveableData data) {
        super(world, type, data);
        this.field_70138_W = 1.0f;
        this.func_70107_b(x, y, z);
        this.rotateYaw(placer.field_70177_z + 90.0f);
        this.initType(type, false);
    }

    @Override
    protected void initType(DriveableType type, boolean clientSide) {
        super.initType(type, clientSide);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("VarDoor", this.varDoor);
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.varDoor = tag.func_74767_n("VarDoor");
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
    }

    @Override
    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, float roll, double motX, double motY, double motZ, float velYaw, float velPitch, float velRoll, float throt, float steeringYaw) {
        super.setPositionRotationAndMotion(x, y, z, yaw, pitch, roll, motX, motY, motZ, velYaw, velPitch, velRoll, throt, steeringYaw);
        this.wheelsYaw = steeringYaw;
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (this.field_70128_L) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack currentItem = entityplayer.func_71045_bC();
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemTool && ((ItemTool)currentItem.func_77973_b()).type.healDriveables) {
            return true;
        }
        VehicleType type = this.getVehicleType();
        for (int i = 0; i <= type.numPassengers; ++i) {
            if (!this.seats[i].func_130002_c(entityplayer)) continue;
            if (i == 0) {
                this.shellDelay = type.vehicleShellDelay;
                FlansMod.proxy.doTutorialStuff(entityplayer, this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean pressKey(int key, EntityPlayer player) {
        VehicleType type = this.getVehicleType();
        if (this.field_70170_p.field_72995_K && (key == 6 || key == 8 || key == 9)) {
            FlansMod.getPacketHandler().sendToServer(new PacketDriveableKey(key));
            return true;
        }
        switch (key) {
            case 0: {
                this.throttle += 0.01f;
                if (this.throttle > 1.0f) {
                    this.throttle = 1.0f;
                }
                return true;
            }
            case 1: {
                this.throttle -= 0.01f;
                if (this.throttle < -1.0f) {
                    this.throttle = -1.0f;
                }
                if (this.throttle < 0.0f && type.maxNegativeThrottle == 0.0f) {
                    this.throttle = 0.0f;
                }
                return true;
            }
            case 2: {
                this.wheelsYaw -= 1.0f;
                return true;
            }
            case 3: {
                this.wheelsYaw += 1.0f;
                return true;
            }
            case 4: {
                this.throttle *= 0.8f;
                if (this.field_70122_E) {
                    this.field_70159_w *= (double)0.8f;
                    this.field_70179_y *= (double)0.8f;
                }
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                this.seats[0].field_70153_n.func_70078_a(null);
                return true;
            }
            case 7: {
                if (this.field_70170_p.field_72995_K) {
                    FlansMod.proxy.openDriveableMenu((EntityPlayer)this.seats[0].field_70153_n, this.field_70170_p, this);
                }
                return true;
            }
            case 8: 
            case 9: {
                return super.pressKey(key, player);
            }
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: {
                return true;
            }
            case 14: {
                if (this.toggleTimer <= 0) {
                    boolean bl = this.varDoor = !this.varDoor;
                    if (type.hasDoor) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Doors " + (this.varDoor ? "open" : "closed")));
                    }
                    this.toggleTimer = 10;
                    FlansMod.getPacketHandler().sendToServer(new PacketVehicleControl(this));
                }
                return true;
            }
            case 15: {
                return true;
            }
            case 16: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Vector3f getLookVector(DriveablePosition dp) {
        return this.rotate(this.seats[0].looking.getXAxis());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        VehicleType type = this.getVehicleType();
        DriveableData data = this.getDriveableData();
        if (type == null) {
            FlansMod.log("Vehicle type null. Not ticking vehicle");
            return;
        }
        boolean thePlayerIsDrivingThis = this.field_70170_p.field_72995_K && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && FlansMod.proxy.isThePlayer((EntityPlayer)this.seats[0].field_70153_n);
        ++this.ticksSinceUsed;
        if (!this.field_70170_p.field_72995_K && this.seats[0].field_70153_n != null) {
            this.ticksSinceUsed = 0;
        }
        if (!this.field_70170_p.field_72995_K && TeamsManager.vehicleLife > 0 && this.ticksSinceUsed > TeamsManager.vehicleLife * 20) {
            this.func_70106_y();
        }
        if (this.shellDelay > 0) {
            --this.shellDelay;
        }
        if (this.gunDelay > 0) {
            --this.gunDelay;
        }
        if (this.toggleTimer > 0) {
            --this.toggleTimer;
        }
        if (this.soundPosition > 0) {
            --this.soundPosition;
        }
        if (this.hasEnoughFuel()) {
            this.wheelsAngle = (float)((double)this.wheelsAngle + Math.pow(this.throttle, 0.4) * 0.2);
        }
        this.wheelsYaw *= 0.9f;
        if (this.wheelsYaw > 20.0f) {
            this.wheelsYaw = 20.0f;
        }
        if (this.wheelsYaw < -20.0f) {
            this.wheelsYaw = -20.0f;
        }
        if (this.field_70170_p.field_72995_K && !thePlayerIsDrivingThis && this.serverPositionTransitionTicker > 0) {
            double x = this.field_70165_t + (this.field_70118_ct - this.field_70165_t) / (double)this.serverPositionTransitionTicker;
            double y = this.field_70163_u + (this.field_70117_cu - this.field_70163_u) / (double)this.serverPositionTransitionTicker;
            double d = this.field_70161_v + (this.field_70116_cv - this.field_70161_v) / (double)this.serverPositionTransitionTicker;
            double dYaw = MathHelper.func_76138_g((double)(this.serverYaw - (double)this.axes.getYaw()));
            double dPitch = MathHelper.func_76138_g((double)(this.serverPitch - (double)this.axes.getPitch()));
            double dRoll = MathHelper.func_76138_g((double)(this.serverRoll - (double)this.axes.getRoll()));
            this.field_70177_z = (float)((double)this.axes.getYaw() + dYaw / (double)this.serverPositionTransitionTicker);
            this.field_70125_A = (float)((double)this.axes.getPitch() + dPitch / (double)this.serverPositionTransitionTicker);
            float rotationRoll = (float)((double)this.axes.getRoll() + dRoll / (double)this.serverPositionTransitionTicker);
            --this.serverPositionTransitionTicker;
            this.func_70107_b(x, y, d);
            this.setRotation(this.field_70177_z, this.field_70125_A, rotationRoll);
        }
        Vector3f amountToMoveCar = new Vector3f();
        for (EntityWheel entityWheel : this.wheels) {
            if (entityWheel == null || this.field_70170_p == null) continue;
            entityWheel.field_70169_q = entityWheel.field_70165_t;
            entityWheel.field_70167_r = entityWheel.field_70163_u;
            entityWheel.field_70166_s = entityWheel.field_70166_s;
        }
        for (EntityWheel entityWheel : this.wheels) {
            boolean canThrustCreatively;
            if (entityWheel == null) continue;
            this.field_70122_E = true;
            entityWheel.field_70122_E = true;
            entityWheel.field_70177_z = this.axes.getYaw();
            if (!(type.tank || entityWheel.ID != 2 && entityWheel.ID != 3)) {
                entityWheel.field_70177_z += this.wheelsYaw;
            }
            entityWheel.field_70159_w *= (double)0.9f;
            entityWheel.field_70181_x *= (double)0.9f;
            entityWheel.field_70179_y *= (double)0.9f;
            entityWheel.field_70181_x -= 0.049000002443790436;
            boolean bl = canThrustCreatively = !TeamsManager.vehiclesNeedFuel || this.seats != null && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
            if (canThrustCreatively || data.fuelInTank > data.engine.fuelConsumption * this.throttle) {
                if (this.getVehicleType().tank) {
                    boolean left = entityWheel.ID == 0 || entityWheel.ID == 3;
                    float turningDrag = 0.02f;
                    entityWheel.field_70159_w *= (double)(1.0f - Math.abs(this.wheelsYaw) * turningDrag);
                    entityWheel.field_70179_y *= (double)(1.0f - Math.abs(this.wheelsYaw) * turningDrag);
                    float velocityScale = 0.04f * (this.throttle > 0.0f ? type.maxThrottle : type.maxNegativeThrottle) * data.engine.engineSpeed;
                    float steeringScale = 0.1f * (this.wheelsYaw > 0.0f ? type.turnLeftModifier : type.turnRightModifier);
                    float effectiveWheelSpeed = (this.throttle + this.wheelsYaw * (float)(left ? 1 : -1) * steeringScale) * velocityScale;
                    entityWheel.field_70159_w += (double)effectiveWheelSpeed * Math.cos(entityWheel.field_70177_z * (float)Math.PI / 180.0f);
                    entityWheel.field_70179_y += (double)effectiveWheelSpeed * Math.sin(entityWheel.field_70177_z * (float)Math.PI / 180.0f);
                } else {
                    float velocityScale = 0.1f * this.throttle * (this.throttle > 0.0f ? type.maxThrottle : type.maxNegativeThrottle) * data.engine.engineSpeed;
                    entityWheel.field_70159_w += Math.cos(entityWheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale;
                    entityWheel.field_70179_y += Math.sin(entityWheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale;
                    if (entityWheel.ID == 2 || entityWheel.ID == 3) {
                        velocityScale = 0.01f * (this.wheelsYaw > 0.0f ? type.turnLeftModifier : type.turnRightModifier) * (float)(this.throttle > 0.0f ? 1 : -1);
                        entityWheel.field_70159_w -= entityWheel.getSpeedXZ() * Math.sin(entityWheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale * (double)this.wheelsYaw;
                        entityWheel.field_70179_y += entityWheel.getSpeedXZ() * Math.cos(entityWheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale * (double)this.wheelsYaw;
                    } else {
                        entityWheel.field_70159_w *= (double)0.9f;
                        entityWheel.field_70179_y *= (double)0.9f;
                    }
                }
            }
            if (type.floatOnWater && this.field_70170_p.func_72953_d(entityWheel.func_174813_aQ())) {
                entityWheel.field_70181_x += (double)type.buoyancy;
            }
            entityWheel.func_70091_d(entityWheel.field_70159_w, entityWheel.field_70181_x, entityWheel.field_70179_y);
            Vector3f targetWheelPos = this.axes.findLocalVectorGlobally(this.getVehicleType().wheelPositions[entityWheel.ID].position);
            Vector3f currentWheelPos = new Vector3f(entityWheel.field_70165_t - this.field_70165_t, entityWheel.field_70163_u - this.field_70163_u, entityWheel.field_70161_v - this.field_70161_v);
            Vector3f dPos = (Vector3f)Vector3f.sub(targetWheelPos, currentWheelPos, null).scale(this.getVehicleType().wheelSpringStrength);
            if (!(dPos.length() > 0.001f)) continue;
            entityWheel.func_70091_d(dPos.x, dPos.y, dPos.z);
            dPos.scale(0.5f);
            Vector3f.sub(amountToMoveCar, dPos, amountToMoveCar);
        }
        this.func_70091_d(amountToMoveCar.x, amountToMoveCar.y, amountToMoveCar.z);
        if (this.wheels[0] != null && this.wheels[1] != null && this.wheels[2] != null && this.wheels[3] != null) {
            Vector3f frontAxleCentre = new Vector3f((this.wheels[2].field_70165_t + this.wheels[3].field_70165_t) / 2.0, (this.wheels[2].field_70163_u + this.wheels[3].field_70163_u) / 2.0, (this.wheels[2].field_70161_v + this.wheels[3].field_70161_v) / 2.0);
            Vector3f backAxleCentre = new Vector3f((this.wheels[0].field_70165_t + this.wheels[1].field_70165_t) / 2.0, (this.wheels[0].field_70163_u + this.wheels[1].field_70163_u) / 2.0, (this.wheels[0].field_70161_v + this.wheels[1].field_70161_v) / 2.0);
            float dx = frontAxleCentre.x - backAxleCentre.x;
            float f = frontAxleCentre.y - backAxleCentre.y;
            float dz = frontAxleCentre.z - backAxleCentre.z;
            float dxz = (float)Math.sqrt(dx * dx + dz * dz);
            float yaw = (float)Math.atan2(dz, dx);
            float pitch = -((float)Math.atan2(f, dxz));
            float roll = 0.0f;
            if (type.tank) {
                yaw = (float)Math.atan2(this.wheels[3].field_70161_v - this.wheels[2].field_70161_v, this.wheels[3].field_70165_t - this.wheels[2].field_70165_t) + 1.5707964f;
            }
            this.axes.setAngles(yaw * 180.0f / 3.14159f, pitch * 180.0f / 3.14159f, roll * 180.0f / 3.14159f);
        }
        this.checkForCollisions();
        if (this.throttle > 0.01f && this.throttle < 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.startSound, false);
            this.soundPosition = type.startSoundLength;
        }
        if (this.throttle > 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.engineSound, false);
            this.soundPosition = type.engineSoundLength;
        }
        for (Entity entity : this.seats) {
            if (entity == null) continue;
            entity.updatePosition();
        }
        if (thePlayerIsDrivingThis) {
            FlansMod.getPacketHandler().sendToServer(new PacketVehicleControl(this));
            this.field_70118_ct = this.field_70165_t;
            this.field_70117_cu = this.field_70163_u;
            this.field_70116_cv = this.field_70161_v;
            this.serverYaw = this.axes.getYaw();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketVehicleControl(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, 200.0f, this.field_71093_bK);
        }
    }

    private float averageAngles(float a, float b) {
        float avg;
        FlansMod.log("Pre  " + a + " " + b);
        float pi = (float)Math.PI;
        while (a > b + pi) {
            a -= 2.0f * pi;
        }
        while (a < b - pi) {
            a += 2.0f * pi;
        }
        for (avg = (a + b) / 2.0f; avg > pi; avg -= 2.0f * pi) {
        }
        while (avg < -pi) {
            avg += 2.0f * pi;
        }
        FlansMod.log("Post " + a + " " + b + " " + avg);
        return avg;
    }

    private Vec3 subtract(Vec3 a, Vec3 b) {
        return new Vec3(a.field_72450_a - b.field_72450_a, a.field_72448_b - b.field_72448_b, a.field_72449_c - b.field_72449_c);
    }

    private Vec3 crossProduct(Vec3 a, Vec3 b) {
        return new Vec3(a.field_72448_b * b.field_72449_c - a.field_72449_c * b.field_72448_b, a.field_72449_c * b.field_72450_a - a.field_72450_a * b.field_72449_c, a.field_72450_a * b.field_72448_b - a.field_72448_b * b.field_72450_a);
    }

    @Override
    public boolean landVehicle() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        VehicleType type = this.getVehicleType();
        if (damagesource.field_76373_n.equals("player") && damagesource.func_76346_g().field_70122_E && (this.seats[0] == null || this.seats[0].field_70153_n == null)) {
            ItemStack vehicleStack = new ItemStack(type.item, 1, 0);
            NBTTagCompound tags = new NBTTagCompound();
            vehicleStack.func_77982_d(tags);
            this.driveableData.writeToNBT(tags);
            this.func_70099_a(vehicleStack, 0.5f);
            this.func_70106_y();
        }
        return true;
    }

    public VehicleType getVehicleType() {
        return VehicleType.getVehicle(this.driveableType);
    }

    @Override
    public float getPlayerRoll() {
        return this.axes.getRoll();
    }

    @Override
    protected void dropItemsOnPartDeath(Vector3f midpoint, DriveablePart part) {
    }

    @Override
    public String getBombInventoryName() {
        return "Mines";
    }

    @Override
    public String getMissileInventoryName() {
        return "Shells";
    }

    @Override
    public boolean hasMouseControlMode() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityLivingBase getCamera() {
        return null;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        for (EntityWheel wheel : this.wheels) {
            if (wheel == null) continue;
            wheel.func_70106_y();
        }
    }
}

