/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client;

import com.flansmod.client.ClientRenderHooks;
import com.flansmod.client.FlansModClient;
import com.flansmod.client.model.RenderFlag;
import com.flansmod.client.model.RenderGun;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.vector.Vector3i;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MouseHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;

public class TickHandlerClient {
    public static ArrayList<Vector3i> blockLightOverrides = new ArrayList();
    public static int lightOverrideRefreshRate = 5;

    public TickHandlerClient() {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void eventHandler(MouseEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemGun && ((ItemGun)player.func_71045_bC().func_77973_b()).type.oneHanded && Keyboard.isKeyDown((int)Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151463_i()) && Math.abs(event.dwheel) > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        switch (event.phase) {
            case START: {
                RenderGun.smoothing = event.renderTickTime;
                this.renderTickStart(Minecraft.func_71410_x(), event.renderTickTime);
                break;
            }
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        switch (event.phase) {
            case START: {
                this.clientTickStart(Minecraft.func_71410_x());
                break;
            }
            case END: {
                this.clientTickEnd(Minecraft.func_71410_x());
            }
        }
    }

    public void clientTickStart(Minecraft mc) {
        FlansMod.getPacketHandler().handleClientPackets();
        if (FlansMod.ticker % lightOverrideRefreshRate == 0 && mc.field_71441_e != null) {
            int i;
            lightOverrideRefreshRate = mc.field_71474_y.field_74347_j ? 10 : 20;
            for (Vector3i v : blockLightOverrides) {
                mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(v.x, v.y, v.z));
            }
            blockLightOverrides.clear();
            for (Vector3i obj : mc.field_71441_e.field_73010_i) {
                GunType type;
                AttachmentType grip;
                EntityPlayer player = (EntityPlayer)obj;
                ItemStack currentHeldItem = player.func_71045_bC();
                if (currentHeldItem == null || !(currentHeldItem.func_77973_b() instanceof ItemGun) || (grip = (type = ((ItemGun)currentHeldItem.func_77973_b()).type).getGrip(currentHeldItem)) == null || !grip.flashlight) continue;
                for (i = 0; i < 2; ++i) {
                    MovingObjectPosition ray = player.func_174822_a((double)(grip.flashlightRange / 2.0f * (float)(i + 1)), 1.0f);
                    if (ray == null) continue;
                    int x = ray.func_178782_a().func_177958_n();
                    int y = ray.func_178782_a().func_177956_o();
                    int z = ray.func_178782_a().func_177952_p();
                    EnumFacing side = ray.field_178784_b;
                    switch (side) {
                        case DOWN: {
                            --y;
                            break;
                        }
                        case UP: {
                            ++y;
                            break;
                        }
                        case NORTH: {
                            --z;
                            break;
                        }
                        case SOUTH: {
                            ++z;
                            break;
                        }
                        case WEST: {
                            --x;
                            break;
                        }
                        case EAST: {
                            ++x;
                        }
                    }
                    blockLightOverrides.add(new Vector3i(x, y, z));
                    mc.field_71441_e.func_175653_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z), 12);
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y + 1, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y - 1, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x + 1, y, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x - 1, y, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z + 1));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z - 1));
                }
            }
            for (Vector3i obj : mc.field_71441_e.field_72996_f) {
                int z;
                int y;
                int x;
                if (obj instanceof EntityBullet) {
                    EntityBullet bullet = (EntityBullet)((Object)obj);
                    if (bullet.field_70128_L || !bullet.type.hasLight) continue;
                    x = MathHelper.func_76128_c((double)bullet.field_70165_t);
                    y = MathHelper.func_76128_c((double)bullet.field_70163_u);
                    z = MathHelper.func_76128_c((double)bullet.field_70161_v);
                    blockLightOverrides.add(new Vector3i(x, y, z));
                    mc.field_71441_e.func_175653_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z), 15);
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y + 1, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y - 1, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x + 1, y, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x - 1, y, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z + 1));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z - 1));
                    continue;
                }
                if (!(obj instanceof EntityMecha)) continue;
                EntityMecha mecha = (EntityMecha)((Object)obj);
                x = MathHelper.func_76128_c((double)mecha.field_70165_t);
                y = MathHelper.func_76128_c((double)mecha.field_70163_u);
                z = MathHelper.func_76128_c((double)mecha.field_70161_v);
                if (mecha.lightLevel() > 0) {
                    blockLightOverrides.add(new Vector3i(x, y, z));
                    mc.field_71441_e.func_175653_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z), Math.max(mc.field_71441_e.func_175642_b(EnumSkyBlock.BLOCK, new BlockPos(x, y, z)), mecha.lightLevel()));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y + 1, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y - 1, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x + 1, y, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x - 1, y, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z + 1));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z - 1));
                }
                if (!mecha.forceDark()) continue;
                for (i = -3; i <= 3; ++i) {
                    for (int j = -3; j <= 3; ++j) {
                        for (int k = -3; k <= 3; ++k) {
                            int xd = i + x;
                            int yd = j + y;
                            int zd = k + z;
                            blockLightOverrides.add(new Vector3i(xd, yd, zd));
                            mc.field_71441_e.func_175653_a(EnumSkyBlock.SKY, new BlockPos(xd, yd, zd), Math.abs(i) + Math.abs(j) + Math.abs(k));
                        }
                    }
                }
            }
        }
    }

    public void clientTickEnd(Minecraft minecraft) {
        ClientRenderHooks.gameTick();
        RenderFlag.angle += 2.0f;
        FlansModClient.tick();
    }

    public void renderTickStart(Minecraft mc, float smoothing) {
        if (mc.field_71462_r == null && FlansModClient.controlModeMouse) {
            MouseHelper mouse = mc.field_71417_B;
            Entity ridden = mc.field_71439_g.field_70154_o;
            if (ridden instanceof EntityDriveable) {
                EntityDriveable entity = (EntityDriveable)ridden;
                entity.onMouseMoved(mouse.field_74377_a, mouse.field_74375_b);
            }
        }
        FlansModClient.renderTick(smoothing);
        ClientRenderHooks.updateRenderTick(smoothing);
    }
}

