/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.server;

import cpw.mods.fml.common.network.ByteBufUtils;
import fiskfille.tf.data.TFPlayerData;
import fiskfille.tf.server.TransformersPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;

public class PacketHandleTransformation
extends TransformersPacket {
    public boolean mode;
    public String uuid;

    public PacketHandleTransformation() {
    }

    public PacketHandleTransformation(UUID uuid, boolean mode) {
        this.mode = mode;
        this.uuid = uuid.toString();
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.uuid);
        buffer.writeBoolean(this.mode);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.uuid = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.mode = buffer.readBoolean();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        EntityPlayer from = null;
        for (Object cPlayer : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
            if (!(cPlayer instanceof EntityPlayer) || !((EntityPlayer)cPlayer).func_110124_au().equals(UUID.fromString(this.uuid))) continue;
            from = (EntityPlayer)cPlayer;
            break;
        }
        System.out.println(from);
        if (from != null) {
            System.out.println(from.func_70005_c_() + ": " + this.mode);
            TFPlayerData.setInVehichleMode(from, this.mode);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        EntityPlayer from = null;
        block0: for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
            for (Object cPlayer : world.field_73010_i) {
                if (!(cPlayer instanceof EntityPlayer) || !((EntityPlayer)cPlayer).func_110124_au().equals(UUID.fromString(this.uuid))) continue;
                from = (EntityPlayer)cPlayer;
                continue block0;
            }
        }
        System.out.println(from);
        if (from != null) {
            System.out.println(from.func_70005_c_() + ": " + this.mode);
            TFPlayerData.setInVehichleMode(from, this.mode);
            TFPlayerData.sync(player);
        }
    }
}

