/*
 * Decompiled with CFR 0.152.
 */
package fiskfille.tf.main;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import fiskfille.tf.data.TFPlayerData;
import fiskfille.tf.data.TFPlayerDataNew;
import fiskfille.tf.main.TFHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class CommonEventHandler {
    @SubscribeEvent
    public void onEntityLoad(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            event.entity.registerExtendedProperties("TFPLAYERDATA", (IExtendedEntityProperties)new TFPlayerDataNew());
        }
    }

    @SubscribeEvent
    public void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        if (TFPlayerData.isInVehicleMode(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (TFPlayerData.isInVehicleMode(event.entityPlayer)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        if (TFPlayerData.isInVehicleMode(event.entityPlayer)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (TFHelper.isPlayerSkystrike(player)) {
                player.field_70181_x += 0.205;
            }
            if (TFHelper.isPlayerPurge(player) && TFPlayerData.isInVehicleMode(player) && TFPlayerData.getTransformationTimer(player) < 5) {
                player.field_70181_x = 0.0;
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        EntityPlayer player;
        if (event.entity instanceof EntityPlayer && TFHelper.isPlayerSkystrike(player = (EntityPlayer)event.entity)) {
            event.setCanceled(true);
        }
    }
}

