/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class JsonHelper {
    public static JsonArray GetArray(JsonObject json, String id) {
        if (json == null) {
            return new JsonArray();
        }
        if (json.has(id) && json.get(id).isJsonArray()) {
            return json.get(id).getAsJsonArray();
        }
        return new JsonArray();
    }

    public static JsonObject GetObject(JsonObject json, String id) {
        if (json == null) {
            return new JsonObject();
        }
        if (json.has(id) && json.get(id).isJsonObject()) {
            return json.get(id).getAsJsonObject();
        }
        return new JsonObject();
    }

    public static String GetString(JsonObject json, String id, String def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive() && json.get(id).getAsJsonPrimitive().isString()) {
            return json.get(id).getAsString();
        }
        return def;
    }

    public static Number GetNumber(JsonObject json, String id, Number def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive()) {
            try {
                return json.get(id).getAsNumber();
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    public static boolean GetBoolean(JsonObject json, String id, boolean def) {
        if (json == null) {
            return def;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive()) {
            try {
                return json.get(id).getAsBoolean();
            }
            catch (Exception e) {
                JsonPrimitive prim = new JsonPrimitive(Boolean.valueOf(def));
                json.add(id, (JsonElement)prim);
                return def;
            }
        }
        return def;
    }
}

