/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import oreexcavation.client.ExcavationKeys;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.core.OreExcavation;
import oreexcavation.handlers.EventHandler;
import oreexcavation.handlers.MiningScheduler;
import org.apache.logging.log4j.Level;

public class PacketExcavation
implements IMessage {
    private NBTTagCompound tags = new NBTTagCompound();

    public PacketExcavation() {
    }

    public PacketExcavation(NBTTagCompound tags) {
        this.tags = tags;
    }

    public void fromBytes(ByteBuf buf) {
        this.tags = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tags);
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientHandler
    implements IMessageHandler<PacketExcavation, PacketExcavation> {
        public PacketExcavation onMessage(PacketExcavation message, MessageContext ctx) {
            if (ExcavationSettings.mineMode < 0) {
                return null;
            }
            if (ExcavationSettings.mineMode == 0 ? !ExcavationKeys.excavateKey.func_151470_d() : ExcavationSettings.mineMode != 2 && !Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
                return null;
            }
            EventHandler.isExcavating = true;
            return new PacketExcavation(message.tags);
        }
    }

    public static class ServerHandler
    implements IMessageHandler<PacketExcavation, PacketExcavation> {
        public PacketExcavation onMessage(PacketExcavation message, MessageContext ctx) {
            final EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (message.tags.func_74767_n("cancel")) {
                player.func_184102_h().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        MiningScheduler.INSTANCE.stopMining(player);
                    }
                });
                return null;
            }
            final int x = message.tags.func_74762_e("x");
            final int y = message.tags.func_74762_e("y");
            final int z = message.tags.func_74762_e("z");
            Block block = null;
            try {
                block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(message.tags.func_74779_i("block")));
            }
            catch (Exception e) {
                OreExcavation.logger.log(Level.INFO, "Recieved invalid block ID", (Throwable)e);
            }
            int meta = message.tags.func_74762_e("meta");
            final IBlockState state = block.func_176203_a(meta);
            if (player == null || block == null) {
                return null;
            }
            player.func_184102_h().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    MiningScheduler.INSTANCE.startMining(player, new BlockPos(x, y, z), state);
                }
            });
            return null;
        }
    }
}

